package software.amazon.awscdk.services.sns;

/**
 * Options for creating a new subscription.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-07T12:30:30.508Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sns.$Module.class, fqn = "@aws-cdk/aws-sns.SubscriptionOptions")
@software.amazon.jsii.Jsii.Proxy(SubscriptionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subscription endpoint.
     * <p>
     * The meaning of this value depends on the value for 'protocol'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

    /**
     * What type of subscription to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol();

    /**
     * The filter policy.
     * <p>
     * Default: - all messages are delivered
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
        return null;
    }

    /**
     * true if raw message delivery is enabled for the subscription.
     * <p>
     * Raw messages are free of JSON formatting and can be
     * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
     * Notification Service API Reference.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRawMessageDelivery() {
        return null;
    }

    /**
     * The region where the topic resides, in the case of cross-region subscriptions.
     * <p>
     * Default: - the region where the CloudFormation stack is being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String endpoint;
        private software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private java.lang.Boolean rawMessageDelivery;
        private java.lang.String region;

        /**
         * Sets the value of {@link SubscriptionOptions#getEndpoint}
         * @param endpoint The subscription endpoint. This parameter is required.
         *                 The meaning of this value depends on the value for 'protocol'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getProtocol}
         * @param protocol What type of subscription to add. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getFilterPolicy}
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getRawMessageDelivery}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription.
         *                           Raw messages are free of JSON formatting and can be
         *                           sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         *                           Notification Service API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getRegion}
         * @param region The region where the topic resides, in the case of cross-region subscriptions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SubscriptionOptions build() {
            return new Jsii$Proxy(endpoint, protocol, filterPolicy, rawMessageDelivery, region);
        }
    }

    /**
     * An implementation for {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionOptions {
        private final java.lang.String endpoint;
        private final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private final java.lang.Boolean rawMessageDelivery;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpoint = this.jsiiGet("endpoint", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.sns.SubscriptionProtocol.class);
            this.filterPolicy = this.jsiiGet("filterPolicy", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class)));
            this.rawMessageDelivery = this.jsiiGet("rawMessageDelivery", java.lang.Boolean.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String endpoint, final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol, final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy, final java.lang.Boolean rawMessageDelivery, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpoint = java.util.Objects.requireNonNull(endpoint, "endpoint is required");
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.filterPolicy = filterPolicy;
            this.rawMessageDelivery = rawMessageDelivery;
            this.region = region;
        }

        @Override
        public java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public java.lang.Boolean getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpoint", om.valueToTree(this.getEndpoint()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sns.SubscriptionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionOptions.Jsii$Proxy that = (SubscriptionOptions.Jsii$Proxy) o;

            if (!endpoint.equals(that.endpoint)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.endpoint.hashCode();
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
