package software.amazon.awscdk.services.sqs;

/**
 * A new Amazon SQS queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:24.914Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.Queue")
public class Queue extends software.amazon.awscdk.services.sqs.QueueBase {

    protected Queue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Queue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Queue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.QueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Queue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing SQS queue provided an ARN.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param queueArn queue ARN (i.e. arn:aws:sqs:us-east-2:444455556666:queue1). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue fromQueueArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String queueArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sqs.Queue.class, "fromQueueArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(queueArn, "queueArn is required") });
    }

    /**
     * Import an existing queue.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue fromQueueAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.QueueAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sqs.Queue.class, "fromQueueAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Controls automatic creation of policy objects.
     * <p>
     * Set by subclasses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether this queue is an Amazon SQS FIFO queue.
     * <p>
     * If false, this is a standard queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo() {
        return software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The ARN of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueueArn() {
        return software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueueName() {
        return software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of this queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl() {
        return software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this queue is encrypted, this is the KMS key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionMasterKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sqs.Queue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sqs.Queue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sqs.QueueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies whether to enable content-based deduplication.
         * <p>
         * During the deduplication interval (5 minutes), Amazon SQS treats
         * messages that are sent with identical content (excluding attributes) as
         * duplicates and delivers only one copy of the message.
         * <p>
         * If you don't enable content-based deduplication and you want to deduplicate
         * messages, provide an explicit deduplication ID in your SendMessage() call.
         * <p>
         * (Only applies to FIFO queues.)
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param contentBasedDeduplication Specifies whether to enable content-based deduplication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final java.lang.Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        /**
         * The length of time that Amazon SQS reuses a data key before calling KMS again.
         * <p>
         * The value must be an integer between 60 (1 minute) and 86,400 (24
         * hours). The default is 300 (5 minutes).
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param dataKeyReuse The length of time that Amazon SQS reuses a data key before calling KMS again. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataKeyReuse(final software.amazon.awscdk.core.Duration dataKeyReuse) {
            this.props().dataKeyReuse(dataKeyReuse);
            return this;
        }

        /**
         * Send messages to this queue if they were unsuccessfully dequeued a number of times.
         * <p>
         * Default: no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Send messages to this queue if they were unsuccessfully dequeued a number of times. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The time in seconds that the delivery of all messages in the queue is delayed.
         * <p>
         * You can specify an integer value of 0 to 900 (15 minutes). The default
         * value is 0.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param deliveryDelay The time in seconds that the delivery of all messages in the queue is delayed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryDelay(final software.amazon.awscdk.core.Duration deliveryDelay) {
            this.props().deliveryDelay(deliveryDelay);
            return this;
        }

        /**
         * Whether the contents of the queue are encrypted, and by what type of key.
         * <p>
         * Be aware that encryption is not available in all regions, please see the docs
         * for current availability details.
         * <p>
         * Default: Unencrypted
         * <p>
         * @return {@code this}
         * @param encryption Whether the contents of the queue are encrypted, and by what type of key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.sqs.QueueEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS master key to use for queue encryption.
         * <p>
         * Individual messages will be encrypted using data keys. The data keys in
         * turn will be encrypted using this key, and reused for a maximum of
         * <code>dataKeyReuseSecs</code> seconds.
         * <p>
         * If the 'encryptionMasterKey' property is set, 'encryption' type will be
         * implicitly set to "KMS".
         * <p>
         * Default: If encryption is set to KMS and not specified, a key will be created.
         * <p>
         * @return {@code this}
         * @param encryptionMasterKey External KMS master key to use for queue encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionMasterKey(final software.amazon.awscdk.services.kms.IKey encryptionMasterKey) {
            this.props().encryptionMasterKey(encryptionMasterKey);
            return this;
        }

        /**
         * Whether this a first-in-first-out (FIFO) queue.
         * <p>
         * Default: false, unless queueName ends in '.fifo' or 'contentBasedDeduplication' is true.
         * <p>
         * @return {@code this}
         * @param fifo Whether this a first-in-first-out (FIFO) queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifo(final java.lang.Boolean fifo) {
            this.props().fifo(fifo);
            return this;
        }

        /**
         * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
         * <p>
         * You can specify an integer value from 1024 bytes (1 KiB) to 262144 bytes
         * (256 KiB). The default value is 262144 (256 KiB).
         * <p>
         * Default: 256KiB
         * <p>
         * @return {@code this}
         * @param maxMessageSizeBytes The limit of how many bytes that a message can contain before Amazon SQS rejects it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxMessageSizeBytes(final java.lang.Number maxMessageSizeBytes) {
            this.props().maxMessageSizeBytes(maxMessageSizeBytes);
            return this;
        }

        /**
         * A name for the queue.
         * <p>
         * If specified and this is a FIFO queue, must end in the string '.fifo'.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param queueName A name for the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(final java.lang.String queueName) {
            this.props().queueName(queueName);
            return this;
        }

        /**
         * Default wait time for ReceiveMessage calls.
         * <p>
         * Does not wait if set to 0, otherwise waits this amount of seconds
         * by default for messages to arrive.
         * <p>
         * For more information, see Amazon SQS Long Poll.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param receiveMessageWaitTime Default wait time for ReceiveMessage calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTime(final software.amazon.awscdk.core.Duration receiveMessageWaitTime) {
            this.props().receiveMessageWaitTime(receiveMessageWaitTime);
            return this;
        }

        /**
         * Policy to apply when the user pool is removed from the stack.
         * <p>
         * Even though queues are technically stateful, their contents are transient and it
         * is common to add and remove Queues while rearchitecting your application. The
         * default is therefore <code>DESTROY</code>. Change it to <code>RETAIN</code> if the messages are so
         * valuable that accidentally losing them would be unacceptable.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the user pool is removed from the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The number of seconds that Amazon SQS retains a message.
         * <p>
         * You can specify an integer value from 60 seconds (1 minute) to 1209600
         * seconds (14 days). The default value is 345600 seconds (4 days).
         * <p>
         * Default: Duration.days(4)
         * <p>
         * @return {@code this}
         * @param retentionPeriod The number of seconds that Amazon SQS retains a message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.core.Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * Timeout of processing a single message.
         * <p>
         * After dequeuing, the processor has this much time to handle the message
         * and delete it from the queue before it becomes visible again for dequeueing
         * by another processor.
         * <p>
         * Values must be from 0 to 43200 seconds (12 hours). If you don't specify
         * a value, AWS CloudFormation uses the default value of 30 seconds.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param visibilityTimeout Timeout of processing a single message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(final software.amazon.awscdk.core.Duration visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sqs.Queue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sqs.Queue build() {
            return new software.amazon.awscdk.services.sqs.Queue(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sqs.QueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sqs.QueueProps.Builder();
            }
            return this.props;
        }
    }
}
