/**
 * <h1>Amazon Simple Queue Service Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Amazon Simple Queue Service (SQS) is a fully managed message queuing service that
 * enables you to decouple and scale microservices, distributed systems, and serverless
 * applications. SQS eliminates the complexity and overhead associated with managing and
 * operating message oriented middleware, and empowers developers to focus on differentiating work.
 * Using SQS, you can send, store, and receive messages between software components at any volume,
 * without losing messages or requiring other services to be available.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sqs.*;
 * </pre></blockquote>
 * <p>
 * <h2>Basic usage</h2>
 * <p>
 * Here's how to add a basic queue to your application:
 * <p>
 * <blockquote><pre>
 * new Queue(this, "Queue");
 * </pre></blockquote>
 * <p>
 * <h2>Encryption</h2>
 * <p>
 * If you want to encrypt the queue contents, set the <code>encryption</code> property. You can have
 * the messages encrypted with a key that SQS manages for you, or a key that you
 * can manage yourself.
 * <p>
 * <blockquote><pre>
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS_MANAGED)
 *         .build();
 * 
 * // Use custom key
 * Key myKey = new Key(this, "Key");
 * 
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS)
 *         .encryptionMasterKey(myKey)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>First-In-First-Out (FIFO) queues</h2>
 * <p>
 * FIFO queues give guarantees on the order in which messages are dequeued, and have additional
 * features in order to help guarantee exactly-once processing. For more information, see
 * the SQS manual. Note that FIFO queues are not available in all AWS regions.
 * <p>
 * A queue can be made a FIFO queue by either setting <code>fifo: true</code>, giving it a name which ends
 * in <code>".fifo"</code>, or by enabling a FIFO specific feature such as: content-based deduplication,
 * deduplication scope or fifo throughput limit.
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@Deprecated
package software.amazon.awscdk.services.sqs;
