package software.amazon.awscdk.services.sqs;

/**
 * Reference to a queue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:40.997Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.sqs.$Module.class, fqn = "@aws-cdk/aws-sqs.QueueAttributes")
@software.amazon.jsii.Jsii.Proxy(QueueAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueArn();

    /**
     * KMS encryption key, if this queue is server-side encrypted by a KMS key.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyArn() {
        return null;
    }

    /**
     * The name of the queue.
     * <p>
     * Default: if queue name is not specified, the name will be derived from the queue ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return null;
    }

    /**
     * The URL of the queue.
     * <p>
     * Default: - 'https://sqs.<region-endpoint>/<account-ID>/<queue-name>'
     * <p>
     * @see https://docs.aws.amazon.com/sdk-for-net/v2/developer-guide/QueueURL.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueAttributes> {
        private java.lang.String queueArn;
        private java.lang.String keyArn;
        private java.lang.String queueName;
        private java.lang.String queueUrl;

        /**
         * Sets the value of {@link QueueAttributes#getQueueArn}
         * @param queueArn The ARN of the queue. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueArn(java.lang.String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        /**
         * Sets the value of {@link QueueAttributes#getKeyArn}
         * @param keyArn KMS encryption key, if this queue is server-side encrypted by a KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyArn(java.lang.String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        /**
         * Sets the value of {@link QueueAttributes#getQueueName}
         * @param queueName The name of the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(java.lang.String queueName) {
            this.queueName = queueName;
            return this;
        }

        /**
         * Sets the value of {@link QueueAttributes#getQueueUrl}
         * @param queueUrl The URL of the queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueUrl(java.lang.String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueAttributes build() {
            return new Jsii$Proxy(queueArn, keyArn, queueName, queueUrl);
        }
    }

    /**
     * An implementation for {@link QueueAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueAttributes {
        private final java.lang.String queueArn;
        private final java.lang.String keyArn;
        private final java.lang.String queueName;
        private final java.lang.String queueUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queueArn = software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyArn = software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueUrl = software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String queueArn, final java.lang.String keyArn, final java.lang.String queueName, final java.lang.String queueUrl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queueArn = java.util.Objects.requireNonNull(queueArn, "queueArn is required");
            this.keyArn = keyArn;
            this.queueName = queueName;
            this.queueUrl = queueUrl;
        }

        @Override
        public final java.lang.String getQueueArn() {
            return this.queueArn;
        }

        @Override
        public final java.lang.String getKeyArn() {
            return this.keyArn;
        }

        @Override
        public final java.lang.String getQueueName() {
            return this.queueName;
        }

        @Override
        public final java.lang.String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queueArn", om.valueToTree(this.getQueueArn()));
            if (this.getKeyArn() != null) {
                data.set("keyArn", om.valueToTree(this.getKeyArn()));
            }
            if (this.getQueueName() != null) {
                data.set("queueName", om.valueToTree(this.getQueueName()));
            }
            if (this.getQueueUrl() != null) {
                data.set("queueUrl", om.valueToTree(this.getQueueUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-sqs.QueueAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueAttributes.Jsii$Proxy that = (QueueAttributes.Jsii$Proxy) o;

            if (!queueArn.equals(that.queueArn)) return false;
            if (this.keyArn != null ? !this.keyArn.equals(that.keyArn) : that.keyArn != null) return false;
            if (this.queueName != null ? !this.queueName.equals(that.queueName) : that.queueName != null) return false;
            return this.queueUrl != null ? this.queueUrl.equals(that.queueUrl) : that.queueUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.queueArn.hashCode();
            result = 31 * result + (this.keyArn != null ? this.keyArn.hashCode() : 0);
            result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
            result = 31 * result + (this.queueUrl != null ? this.queueUrl.hashCode() : 0);
            return result;
        }
    }
}
