package software.amazon.awscdk.services.ssm;

/**
 * Properties needed to create a StringList SSM Parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a new SSM Parameter holding a String
 * StringParameter param = StringParameter.Builder.create(stack, "StringParameter")
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringValue("Initial parameter value")
 *         .build();
 * // Grant read access to some Role
 * param.grantRead(role);
 * // Create a new SSM Parameter holding a StringList
 * StringListParameter listParameter = StringListParameter.Builder.create(stack, "StringListParameter")
 *         // description: 'Some user-friendly description',
 *         // name: 'ParameterName',
 *         .stringListValue(List.of("Initial parameter value A", "Initial parameter value B"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-30T16:29:44.461Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ssm.$Module.class, fqn = "@aws-cdk/aws-ssm.StringListParameterProps")
@software.amazon.jsii.Jsii.Proxy(StringListParameterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringListParameterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ssm.ParameterOptions {

    /**
     * The values of the parameter.
     * <p>
     * It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStringListValue();

    /**
     * @return a {@link Builder} of {@link StringListParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringListParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringListParameterProps> {
        java.util.List<java.lang.String> stringListValue;
        java.lang.String allowedPattern;
        java.lang.String description;
        java.lang.String parameterName;
        java.lang.Boolean simpleName;
        software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Sets the value of {@link StringListParameterProps#getStringListValue}
         * @param stringListValue The values of the parameter. This parameter is required.
         *                        It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringListValue(java.util.List<java.lang.String> stringListValue) {
            this.stringListValue = stringListValue;
            return this;
        }

        /**
         * Sets the value of {@link StringListParameterProps#getAllowedPattern}
         * @param allowedPattern A regular expression used to validate the parameter value.
         *                       For example, for String types with values restricted to
         *                       numbers, you can specify the following: <code>^\d+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(java.lang.String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        /**
         * Sets the value of {@link StringListParameterProps#getDescription}
         * @param description Information about the parameter that you want to add to the system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StringListParameterProps#getParameterName}
         * @param parameterName The name of the parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link StringListParameterProps#getSimpleName}
         * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
         *                   This is only required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Sets the value of {@link StringListParameterProps#getTier}
         * @param tier The tier of the string parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(software.amazon.awscdk.services.ssm.ParameterTier tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringListParameterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringListParameterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringListParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringListParameterProps {
        private final java.util.List<java.lang.String> stringListValue;
        private final java.lang.String allowedPattern;
        private final java.lang.String description;
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;
        private final software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stringListValue = software.amazon.jsii.Kernel.get(this, "stringListValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowedPattern = software.amazon.jsii.Kernel.get(this, "allowedPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterTier.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stringListValue = java.util.Objects.requireNonNull(builder.stringListValue, "stringListValue is required");
            this.allowedPattern = builder.allowedPattern;
            this.description = builder.description;
            this.parameterName = builder.parameterName;
            this.simpleName = builder.simpleName;
            this.tier = builder.tier;
        }

        @Override
        public final java.util.List<java.lang.String> getStringListValue() {
            return this.stringListValue;
        }

        @Override
        public final java.lang.String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterTier getTier() {
            return this.tier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stringListValue", om.valueToTree(this.getStringListValue()));
            if (this.getAllowedPattern() != null) {
                data.set("allowedPattern", om.valueToTree(this.getAllowedPattern()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameterName() != null) {
                data.set("parameterName", om.valueToTree(this.getParameterName()));
            }
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ssm.StringListParameterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringListParameterProps.Jsii$Proxy that = (StringListParameterProps.Jsii$Proxy) o;

            if (!stringListValue.equals(that.stringListValue)) return false;
            if (this.allowedPattern != null ? !this.allowedPattern.equals(that.allowedPattern) : that.allowedPattern != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameterName != null ? !this.parameterName.equals(that.parameterName) : that.parameterName != null) return false;
            if (this.simpleName != null ? !this.simpleName.equals(that.simpleName) : that.simpleName != null) return false;
            return this.tier != null ? this.tier.equals(that.tier) : that.tier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stringListValue.hashCode();
            result = 31 * result + (this.allowedPattern != null ? this.allowedPattern.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameterName != null ? this.parameterName.hashCode() : 0);
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            return result;
        }
    }
}
