package software.amazon.awscdk.services.ssm;

/**
 * Properties needed to create a String SSM parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StringParameter.Builder.create(this, "Parameter")
 *         .allowedPattern(".*")
 *         .description("The value Foo")
 *         .parameterName("FooParameter")
 *         .stringValue("Foo")
 *         .tier(ParameterTier.ADVANCED)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-28T21:34:20.973Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ssm.$Module.class, fqn = "@aws-cdk/aws-ssm.StringParameterProps")
@software.amazon.jsii.Jsii.Proxy(StringParameterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringParameterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ssm.ParameterOptions {

    /**
     * The value of the parameter.
     * <p>
     * It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStringValue();

    /**
     * The data type of the parameter, such as `text` or `aws:ec2:image`.
     * <p>
     * Default: ParameterDataType.TEXT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterDataType getDataType() {
        return null;
    }

    /**
     * The type of the string parameter.
     * <p>
     * Default: ParameterType.STRING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterType getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StringParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringParameterProps> {
        java.lang.String stringValue;
        software.amazon.awscdk.services.ssm.ParameterDataType dataType;
        software.amazon.awscdk.services.ssm.ParameterType type;
        java.lang.String allowedPattern;
        java.lang.String description;
        java.lang.String parameterName;
        java.lang.Boolean simpleName;
        software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Sets the value of {@link StringParameterProps#getStringValue}
         * @param stringValue The value of the parameter. This parameter is required.
         *                    It may not reference another parameter and <code>{{}}</code> cannot be used in the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringValue(java.lang.String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getDataType}
         * @param dataType The data type of the parameter, such as `text` or `aws:ec2:image`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.services.ssm.ParameterDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getType}
         * @param type The type of the string parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.ssm.ParameterType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getAllowedPattern}
         * @param allowedPattern A regular expression used to validate the parameter value.
         *                       For example, for String types with values restricted to
         *                       numbers, you can specify the following: <code>^\d+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPattern(java.lang.String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getDescription}
         * @param description Information about the parameter that you want to add to the system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getParameterName}
         * @param parameterName The name of the parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getSimpleName}
         * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
         *                   This is only required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterProps#getTier}
         * @param tier The tier of the string parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(software.amazon.awscdk.services.ssm.ParameterTier tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringParameterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringParameterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringParameterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringParameterProps {
        private final java.lang.String stringValue;
        private final software.amazon.awscdk.services.ssm.ParameterDataType dataType;
        private final software.amazon.awscdk.services.ssm.ParameterType type;
        private final java.lang.String allowedPattern;
        private final java.lang.String description;
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;
        private final software.amazon.awscdk.services.ssm.ParameterTier tier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterDataType.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterType.class));
            this.allowedPattern = software.amazon.jsii.Kernel.get(this, "allowedPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterTier.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stringValue = java.util.Objects.requireNonNull(builder.stringValue, "stringValue is required");
            this.dataType = builder.dataType;
            this.type = builder.type;
            this.allowedPattern = builder.allowedPattern;
            this.description = builder.description;
            this.parameterName = builder.parameterName;
            this.simpleName = builder.simpleName;
            this.tier = builder.tier;
        }

        @Override
        public final java.lang.String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterDataType getDataType() {
            return this.dataType;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterTier getTier() {
            return this.tier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stringValue", om.valueToTree(this.getStringValue()));
            if (this.getDataType() != null) {
                data.set("dataType", om.valueToTree(this.getDataType()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getAllowedPattern() != null) {
                data.set("allowedPattern", om.valueToTree(this.getAllowedPattern()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getParameterName() != null) {
                data.set("parameterName", om.valueToTree(this.getParameterName()));
            }
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ssm.StringParameterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringParameterProps.Jsii$Proxy that = (StringParameterProps.Jsii$Proxy) o;

            if (!stringValue.equals(that.stringValue)) return false;
            if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.allowedPattern != null ? !this.allowedPattern.equals(that.allowedPattern) : that.allowedPattern != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.parameterName != null ? !this.parameterName.equals(that.parameterName) : that.parameterName != null) return false;
            if (this.simpleName != null ? !this.simpleName.equals(that.simpleName) : that.simpleName != null) return false;
            return this.tier != null ? this.tier.equals(that.tier) : that.tier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stringValue.hashCode();
            result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.allowedPattern != null ? this.allowedPattern.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.parameterName != null ? this.parameterName.hashCode() : 0);
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            return result;
        }
    }
}
