package software.amazon.awscdk.services.synthetics.alpha;

/**
 * (experimental) Canary code from an Asset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.synthetics.alpha.*;
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * ILocalBundling localBundling;
 * AssetCode assetCode = AssetCode.Builder.create("assetPath")
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .network("network")
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .volumesFrom(List.of("volumesFrom"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-09T02:01:26.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.synthetics.alpha.$Module.class, fqn = "@aws-cdk/aws-synthetics-alpha.AssetCode")
public class AssetCode extends software.amazon.awscdk.services.synthetics.alpha.Code {

    protected AssetCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assetPath The path to the asset file or directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String assetPath, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required"), options });
    }

    /**
     * @param assetPath The path to the asset file or directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * (experimental) Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope This parameter is required.
     * @param handler This parameter is required.
     * @param family This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily family) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(handler, "handler is required"), java.util.Objects.requireNonNull(family, "family is required") });
    }
}
