package software.amazon.awscdk.services.synthetics.alpha;

/**
 * (experimental) Runtime options for a canary.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_8)
 *         .environmentVariables(Map.of(
 *                 "stage", "prod"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-09T02:01:26.355Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.synthetics.alpha.$Module.class, fqn = "@aws-cdk/aws-synthetics-alpha.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        SYNTHETICS_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.alpha.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.Runtime.class));
    }

    /**
     * @param name The name of the runtime version. This parameter is required.
     * @param family The Lambda runtime family. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily family) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(family, "family is required") });
    }

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-1.0</code> includes the following:
     * <p>
     * <ul>
     * <li>Synthetics library 1.0</li>
     * <li>Synthetics handler code 1.0</li>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 1.14.0</li>
     * <li>The Chromium version that matches Puppeteer-core 1.14.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_1_0;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.0</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_2_0;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.1</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_2_1;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.2</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_2_2;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-puppeteer-3.0</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 12.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 88.0.4298.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_0;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-puppeteer-3.1</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 12.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 88.0.4298.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_1;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-puppeteer-3.2</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 12.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 88.0.4298.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_2;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.3` includes the following: **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 12.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 88.0.4298.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_3;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-puppeteer-3.4</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 12.x</li>
     * <li>Puppeteer-core version 5.5.0</li>
     * <li>Chromium version 88.0.4298.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_4;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.5` includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_5;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.6` includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_6;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.7` includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Logging enhancement</strong>: The canary will upload logs to Amazon S3 even if it times out or crashes.</li>
     * <li><strong>Lambda layer size reduced</strong>: The size of the Lambda layer used for canaries is reduced by 34%.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_7;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.8` includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Profile cleanup</strong>: Chromium profiles are now cleaned up after each canary run.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_8;

    /**
     * (experimental) `syn-python-selenium-1.0` includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 83.0.4103.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_PYTHON_SELENIUM_1_0;

    /**
     * (experimental) `syn-python-selenium-1.1` includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 83.0.4103.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Custom handler function</strong>: You can now use a custom handler function for your canary scripts.</li>
     * <li><strong>Configuration options for adding metrics and step failure configurations</strong>: These options were already available in runtimes for Node.js canaries.</li>
     * <li><strong>Custom arguments in Chrome</strong>: You can now open a browser in incognito mode or pass in proxy server configuration.</li>
     * <li><strong>Cross-Region artifact buckets</strong>: A canary can store its artifacts in an Amazon S3 bucket in a different Region.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_PYTHON_SELENIUM_1_1;

    /**
     * (experimental) `syn-python-selenium-1.2` includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 92.0.4512.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>Updated dependencies</strong>: The only new features in this runtime are the updated dependencies.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_PYTHON_SELENIUM_1_2;

    /**
     * (experimental) `syn-python-selenium-1.3` includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 92.0.4512.0.
     * <p>
     * New Features:
     * <p>
     * <ul>
     * <li><strong>More precise timestamps</strong>: The start time and stop time of canary runs are now precise to the millisecond.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.3">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.3</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.alpha.Runtime SYNTHETICS_PYTHON_SELENIUM_1_3;

    /**
     * (experimental) The Lambda runtime family.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily.class));
    }

    /**
     * (experimental) The name of the runtime version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
