package software.amazon.awscdk.services.synthetics.alpha;

/**
 * (experimental) The code the canary should execute.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_9)
 *         .environmentVariables(Map.of(
 *                 "stage", "prod"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.78.1 (build 878761e)", date = "2023-04-13T16:39:57.552Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.synthetics.alpha.$Module.class, fqn = "@aws-cdk/aws-synthetics-alpha.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Specify code from a local path.
     * <p>
     * Path must include the folder structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return `AssetCode` associated with the specified path.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param assetPath Either a directory or a .zip file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String assetPath, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.alpha.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required"), options });
    }

    /**
     * (experimental) Specify code from a local path.
     * <p>
     * Path must include the folder structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return `AssetCode` associated with the specified path.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param assetPath Either a directory or a .zip file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.alpha.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * (experimental) Specify code from an s3 bucket.
     * <p>
     * The object in the s3 bucket must be a .zip file that contains
     * the structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return `S3Code` associated with the specified S3 object.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     * @param objectVersion Optional S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.alpha.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * (experimental) Specify code from an s3 bucket.
     * <p>
     * The object in the s3 bucket must be a .zip file that contains
     * the structure <code>nodejs/node_modules/myCanaryFilename.js</code>.
     * <p>
     * @return `S3Code` associated with the specified S3 object.
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary.html#CloudWatch_Synthetics_Canaries_write_from_scratch</a>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.alpha.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * (experimental) Specify code inline.
     * <p>
     * @return `InlineCode` with inline code.
     * @param code The actual handler code (limited to 5MB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.InlineCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.alpha.Code.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.InlineCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (experimental) Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @return a bound `CodeConfig`.
     * @param scope The binding scope. This parameter is required.
     * @param handler This parameter is required.
     * @param family This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily family);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.synthetics.alpha.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Called when the canary is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @return a bound `CodeConfig`.
         * @param scope The binding scope. This parameter is required.
         * @param handler This parameter is required.
         * @param family This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String handler, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.alpha.RuntimeFamily family) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.alpha.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(handler, "handler is required"), java.util.Objects.requireNonNull(family, "family is required") });
        }
    }
}
