package software.amazon.awscdk.services.synthetics.alpha;

/**
 * (experimental) Different ways to clean up underlying Canary resources when the Canary is deleted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "Canary")
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .handler("index.handler")
 *                 .code(Code.fromInline("/* Synthetics handler code"))
 *                 .build()))
 *         .cleanup(Cleanup.LAMBDA)
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_4_0)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-13T16:50:20.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.synthetics.alpha.$Module.class, fqn = "@aws-cdk/aws-synthetics-alpha.Cleanup")
public enum Cleanup {
    /**
     * (experimental) Clean up nothing.
     * <p>
     * The user is responsible for cleaning up
     * all resources left behind by the Canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOTHING,
    /**
     * (experimental) Clean up the underlying Lambda function only.
     * <p>
     * The user is
     * responsible for cleaning up all other resources left behind
     * by the Canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LAMBDA,
}
