package software.amazon.awscdk.services.synthetics;

/**
 * (experimental) Configuration of the code class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.synthetics.*;
 * CodeConfig codeConfig = CodeConfig.builder()
 *         .inlineCode("inlineCode")
 *         .s3Location(Location.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 // the properties below are optional
 *                 .objectVersion("objectVersion")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:41.816Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.synthetics.$Module.class, fqn = "@aws-cdk/aws-synthetics.CodeConfig")
@software.amazon.jsii.Jsii.Proxy(CodeConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CodeConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Inline code (mutually exclusive with `s3Location`).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInlineCode() {
        return null;
    }

    /**
     * (experimental) The location of the code in S3 (mutually exclusive with `inlineCode`).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CodeConfig> {
        java.lang.String inlineCode;
        software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Sets the value of {@link CodeConfig#getInlineCode}
         * @param inlineCode Inline code (mutually exclusive with `s3Location`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inlineCode(java.lang.String inlineCode) {
            this.inlineCode = inlineCode;
            return this;
        }

        /**
         * Sets the value of {@link CodeConfig#getS3Location}
         * @param s3Location The location of the code in S3 (mutually exclusive with `inlineCode`).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CodeConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeConfig {
        private final java.lang.String inlineCode;
        private final software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inlineCode = software.amazon.jsii.Kernel.get(this, "inlineCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inlineCode = builder.inlineCode;
            this.s3Location = builder.s3Location;
        }

        @Override
        public final java.lang.String getInlineCode() {
            return this.inlineCode;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInlineCode() != null) {
                data.set("inlineCode", om.valueToTree(this.getInlineCode()));
            }
            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-synthetics.CodeConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeConfig.Jsii$Proxy that = (CodeConfig.Jsii$Proxy) o;

            if (this.inlineCode != null ? !this.inlineCode.equals(that.inlineCode) : that.inlineCode != null) return false;
            return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inlineCode != null ? this.inlineCode.hashCode() : 0;
            result = 31 * result + (this.s3Location != null ? this.s3Location.hashCode() : 0);
            return result;
        }
    }
}
