package software.amazon.awscdk.services.transfer;

/**
 * A CloudFormation `AWS::Transfer::Server`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:02:53.859Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer")
public class CfnServer extends software.amazon.awscdk.CfnResource {
    protected CfnServer(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnServer.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::Transfer::Server`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnServer(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.transfer.CfnServerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::Transfer::Server`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    public CfnServer(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.transfer.CfnServerProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.transfer.CfnServerProps.class);
    }

    /**
     */
    public java.lang.String getServerArn() {
        return this.jsiiGet("serverArn", java.lang.String.class);
    }

    /**
     */
    public java.lang.String getServerId() {
        return this.jsiiGet("serverId", java.lang.String.class);
    }

    /**
     * The `TagManager` handles setting, removing and formatting tags.
     * 
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    public software.amazon.awscdk.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.TagManager.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html
     */
    public static interface EndpointDetailsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnServer.EndpointDetailsProperty.VpcEndpointId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcendpointid
         */
        java.lang.String getVpcEndpointId();

        /**
         * @return a {@link Builder} of {@link EndpointDetailsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EndpointDetailsProperty}
         */
        final class Builder {
            private java.lang.String _vpcEndpointId;

            /**
             * Sets the value of VpcEndpointId
             * @param value `CfnServer.EndpointDetailsProperty.VpcEndpointId`.
             * @return {@code this}
             */
            public Builder withVpcEndpointId(final java.lang.String value) {
                this._vpcEndpointId = java.util.Objects.requireNonNull(value, "vpcEndpointId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EndpointDetailsProperty build() {
                return new EndpointDetailsProperty() {
                    private final java.lang.String $vpcEndpointId = java.util.Objects.requireNonNull(_vpcEndpointId, "vpcEndpointId is required");

                    @Override
                    public java.lang.String getVpcEndpointId() {
                        return this.$vpcEndpointId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnServer.EndpointDetailsProperty.VpcEndpointId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcendpointid
             */
            @Override
            public java.lang.String getVpcEndpointId() {
                return this.jsiiGet("vpcEndpointId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html
     */
    public static interface IdentityProviderDetailsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnServer.IdentityProviderDetailsProperty.InvocationRole`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-invocationrole
         */
        java.lang.String getInvocationRole();
        /**
         * `CfnServer.IdentityProviderDetailsProperty.Url`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-url
         */
        java.lang.String getUrl();

        /**
         * @return a {@link Builder} of {@link IdentityProviderDetailsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IdentityProviderDetailsProperty}
         */
        final class Builder {
            private java.lang.String _invocationRole;
            private java.lang.String _url;

            /**
             * Sets the value of InvocationRole
             * @param value `CfnServer.IdentityProviderDetailsProperty.InvocationRole`.
             * @return {@code this}
             */
            public Builder withInvocationRole(final java.lang.String value) {
                this._invocationRole = java.util.Objects.requireNonNull(value, "invocationRole is required");
                return this;
            }
            /**
             * Sets the value of Url
             * @param value `CfnServer.IdentityProviderDetailsProperty.Url`.
             * @return {@code this}
             */
            public Builder withUrl(final java.lang.String value) {
                this._url = java.util.Objects.requireNonNull(value, "url is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityProviderDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IdentityProviderDetailsProperty build() {
                return new IdentityProviderDetailsProperty() {
                    private final java.lang.String $invocationRole = java.util.Objects.requireNonNull(_invocationRole, "invocationRole is required");
                    private final java.lang.String $url = java.util.Objects.requireNonNull(_url, "url is required");

                    @Override
                    public java.lang.String getInvocationRole() {
                        return this.$invocationRole;
                    }

                    @Override
                    public java.lang.String getUrl() {
                        return this.$url;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("invocationRole", om.valueToTree(this.getInvocationRole()));
                        obj.set("url", om.valueToTree(this.getUrl()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnServer.IdentityProviderDetailsProperty.InvocationRole`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-invocationrole
             */
            @Override
            public java.lang.String getInvocationRole() {
                return this.jsiiGet("invocationRole", java.lang.String.class);
            }

            /**
             * `CfnServer.IdentityProviderDetailsProperty.Url`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-url
             */
            @Override
            public java.lang.String getUrl() {
                return this.jsiiGet("url", java.lang.String.class);
            }
        }
    }
}
