package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `AWS::Transfer::User`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:02:53.872Z")
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::Transfer::User.Role`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     */
    java.lang.String getRole();
    /**
     * `AWS::Transfer::User.ServerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     */
    java.lang.String getServerId();
    /**
     * `AWS::Transfer::User.UserName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     */
    java.lang.String getUserName();
    /**
     * `AWS::Transfer::User.HomeDirectory`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     */
    java.lang.String getHomeDirectory();
    /**
     * `AWS::Transfer::User.Policy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     */
    java.lang.String getPolicy();
    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     */
    java.util.List<java.lang.String> getSshPublicKeys();
    /**
     * `AWS::Transfer::User.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     */
    java.util.List<software.amazon.awscdk.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnUserProps}
     */
    final class Builder {
        private java.lang.String _role;
        private java.lang.String _serverId;
        private java.lang.String _userName;
        @javax.annotation.Nullable
        private java.lang.String _homeDirectory;
        @javax.annotation.Nullable
        private java.lang.String _policy;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _sshPublicKeys;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.CfnTag> _tags;

        /**
         * Sets the value of Role
         * @param value `AWS::Transfer::User.Role`.
         * @return {@code this}
         */
        public Builder withRole(final java.lang.String value) {
            this._role = java.util.Objects.requireNonNull(value, "role is required");
            return this;
        }
        /**
         * Sets the value of ServerId
         * @param value `AWS::Transfer::User.ServerId`.
         * @return {@code this}
         */
        public Builder withServerId(final java.lang.String value) {
            this._serverId = java.util.Objects.requireNonNull(value, "serverId is required");
            return this;
        }
        /**
         * Sets the value of UserName
         * @param value `AWS::Transfer::User.UserName`.
         * @return {@code this}
         */
        public Builder withUserName(final java.lang.String value) {
            this._userName = java.util.Objects.requireNonNull(value, "userName is required");
            return this;
        }
        /**
         * Sets the value of HomeDirectory
         * @param value `AWS::Transfer::User.HomeDirectory`.
         * @return {@code this}
         */
        public Builder withHomeDirectory(@javax.annotation.Nullable final java.lang.String value) {
            this._homeDirectory = value;
            return this;
        }
        /**
         * Sets the value of Policy
         * @param value `AWS::Transfer::User.Policy`.
         * @return {@code this}
         */
        public Builder withPolicy(@javax.annotation.Nullable final java.lang.String value) {
            this._policy = value;
            return this;
        }
        /**
         * Sets the value of SshPublicKeys
         * @param value `AWS::Transfer::User.SshPublicKeys`.
         * @return {@code this}
         */
        public Builder withSshPublicKeys(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._sshPublicKeys = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::Transfer::User.Tags`.
         * @return {@code this}
         */
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.CfnTag> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnUserProps build() {
            return new CfnUserProps() {
                private final java.lang.String $role = java.util.Objects.requireNonNull(_role, "role is required");
                private final java.lang.String $serverId = java.util.Objects.requireNonNull(_serverId, "serverId is required");
                private final java.lang.String $userName = java.util.Objects.requireNonNull(_userName, "userName is required");
                @javax.annotation.Nullable
                private final java.lang.String $homeDirectory = _homeDirectory;
                @javax.annotation.Nullable
                private final java.lang.String $policy = _policy;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $sshPublicKeys = _sshPublicKeys;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.CfnTag> $tags = _tags;

                @Override
                public java.lang.String getRole() {
                    return this.$role;
                }

                @Override
                public java.lang.String getServerId() {
                    return this.$serverId;
                }

                @Override
                public java.lang.String getUserName() {
                    return this.$userName;
                }

                @Override
                public java.lang.String getHomeDirectory() {
                    return this.$homeDirectory;
                }

                @Override
                public java.lang.String getPolicy() {
                    return this.$policy;
                }

                @Override
                public java.util.List<java.lang.String> getSshPublicKeys() {
                    return this.$sshPublicKeys;
                }

                @Override
                public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                    return this.$tags;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("role", om.valueToTree(this.getRole()));
                    obj.set("serverId", om.valueToTree(this.getServerId()));
                    obj.set("userName", om.valueToTree(this.getUserName()));
                    obj.set("homeDirectory", om.valueToTree(this.getHomeDirectory()));
                    obj.set("policy", om.valueToTree(this.getPolicy()));
                    obj.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
                    obj.set("tags", om.valueToTree(this.getTags()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.transfer.CfnUserProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::Transfer::User.Role`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
         */
        @Override
        public java.lang.String getRole() {
            return this.jsiiGet("role", java.lang.String.class);
        }

        /**
         * `AWS::Transfer::User.ServerId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
         */
        @Override
        public java.lang.String getServerId() {
            return this.jsiiGet("serverId", java.lang.String.class);
        }

        /**
         * `AWS::Transfer::User.UserName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
         */
        @Override
        public java.lang.String getUserName() {
            return this.jsiiGet("userName", java.lang.String.class);
        }

        /**
         * `AWS::Transfer::User.HomeDirectory`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHomeDirectory() {
            return this.jsiiGet("homeDirectory", java.lang.String.class);
        }

        /**
         * `AWS::Transfer::User.Policy`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPolicy() {
            return this.jsiiGet("policy", java.lang.String.class);
        }

        /**
         * `AWS::Transfer::User.SshPublicKeys`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSshPublicKeys() {
            return this.jsiiGet("sshPublicKeys", java.util.List.class);
        }

        /**
         * `AWS::Transfer::User.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }
    }
}
