package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `CfnServer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnServerProps cfnServerProps = CfnServerProps.builder()
 *         .certificate("certificate")
 *         .domain("domain")
 *         .endpointDetails(EndpointDetailsProperty.builder()
 *                 .addressAllocationIds(List.of("addressAllocationIds"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcEndpointId("vpcEndpointId")
 *                 .vpcId("vpcId")
 *                 .build())
 *         .endpointType("endpointType")
 *         .identityProviderDetails(IdentityProviderDetailsProperty.builder()
 *                 .directoryId("directoryId")
 *                 .function("function")
 *                 .invocationRole("invocationRole")
 *                 .url("url")
 *                 .build())
 *         .identityProviderType("identityProviderType")
 *         .loggingRole("loggingRole")
 *         .protocolDetails(ProtocolDetailsProperty.builder()
 *                 .passiveIp("passiveIp")
 *                 .build())
 *         .protocols(List.of("protocols"))
 *         .securityPolicyName("securityPolicyName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workflowDetails(WorkflowDetailsProperty.builder()
 *                 .onUpload(List.of(WorkflowDetailProperty.builder()
 *                         .executionRole("executionRole")
 *                         .workflowId("workflowId")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-04T15:38:51.515Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServerProps")
@software.amazon.jsii.Jsii.Proxy(CfnServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
     * <p>
     * Required when <code>Protocols</code> is set to <code>FTPS</code> .
     * <p>
     * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * Certificates with the following cryptographic algorithms and key sizes are supported:
     * <p>
     * <ul>
     * <li>2048-bit RSA (RSA_2048)</li>
     * <li>4096-bit RSA (RSA_4096)</li>
     * <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
     * <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
     * <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
        return null;
    }

    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IPs and make it accessible to clients over the internet. You VPC's default security groups are automatically assigned to your endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointDetails() {
        return null;
    }

    /**
     * The type of VPC endpoint that you want your server to connect to.
     * <p>
     * You can choose to connect to the public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your server and resources only within your VPC.
     * <p>
     * <blockquote>
     * <p>
     * It is recommended that you use <code>VPC</code> as the <code>EndpointType</code> . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointType() {
        return null;
    }

    /**
     * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderDetails() {
        return null;
    }

    /**
     * Specifies the mode of authentication for a server.
     * <p>
     * The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
     * <p>
     * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentityProviderType() {
        return null;
    }

    /**
     * Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events.
     * <p>
     * When set, user activity can be viewed in your CloudWatch logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return null;
    }

    /**
     * Protocol settings that are configured for your server.
     * <p>
     * <blockquote>
     * <p>
     * Only valid in the <code>UpdateServer</code> API.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProtocolDetails() {
        return null;
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
        return null;
    }

    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicyName() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowDetails() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServerProps> {
        java.lang.String certificate;
        java.lang.String domain;
        java.lang.Object endpointDetails;
        java.lang.String endpointType;
        java.lang.Object identityProviderDetails;
        java.lang.String identityProviderType;
        java.lang.String loggingRole;
        java.lang.Object protocolDetails;
        java.util.List<java.lang.String> protocols;
        java.lang.String securityPolicyName;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object workflowDetails;

        /**
         * Sets the value of {@link CfnServerProps#getCertificate}
         * @param certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
         *                    Required when <code>Protocols</code> is set to <code>FTPS</code> .
         *                    <p>
         *                    To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         *                    <p>
         *                    To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
         *                    <p>
         *                    To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         *                    <p>
         *                    Certificates with the following cryptographic algorithms and key sizes are supported:
         *                    <p>
         *                    <ul>
         *                    <li>2048-bit RSA (RSA_2048)</li>
         *                    <li>4096-bit RSA (RSA_4096)</li>
         *                    <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
         *                    <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
         *                    <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getDomain}
         * @param domain Specifies the domain of the storage system that is used for file transfers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEndpointDetails}
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server.
         *                        When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IPs and make it accessible to clients over the internet. You VPC's default security groups are automatically assigned to your endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(software.amazon.awscdk.core.IResolvable endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEndpointDetails}
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server.
         *                        When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IPs and make it accessible to clients over the internet. You VPC's default security groups are automatically assigned to your endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEndpointType}
         * @param endpointType The type of VPC endpoint that you want your server to connect to.
         *                     You can choose to connect to the public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your server and resources only within your VPC.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     It is recommended that you use <code>VPC</code> as the <code>EndpointType</code> . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(java.lang.String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getIdentityProviderDetails}
         * @param identityProviderDetails Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
         *                                Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(software.amazon.awscdk.core.IResolvable identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getIdentityProviderDetails}
         * @param identityProviderDetails Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
         *                                Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getIdentityProviderType}
         * @param identityProviderType Specifies the mode of authentication for a server.
         *                             The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
         *                             <p>
         *                             Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.
         *                             <p>
         *                             Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
         *                             <p>
         *                             Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderType(java.lang.String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getLoggingRole}
         * @param loggingRole Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events.
         *                    When set, user activity can be viewed in your CloudWatch logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(java.lang.String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getProtocolDetails}
         * @param protocolDetails Protocol settings that are configured for your server.
         *                        <blockquote>
         *                        <p>
         *                        Only valid in the <code>UpdateServer</code> API.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(software.amazon.awscdk.core.IResolvable protocolDetails) {
            this.protocolDetails = protocolDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getProtocolDetails}
         * @param protocolDetails Protocol settings that are configured for your server.
         *                        <blockquote>
         *                        <p>
         *                        Only valid in the <code>UpdateServer</code> API.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(software.amazon.awscdk.services.transfer.CfnServer.ProtocolDetailsProperty protocolDetails) {
            this.protocolDetails = protocolDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getProtocols}
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocols(java.util.List<java.lang.String> protocols) {
            this.protocols = protocols;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getSecurityPolicyName}
         * @param securityPolicyName Specifies the name of the security policy that is attached to the server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicyName(java.lang.String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for servers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getWorkflowDetails}
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(software.amazon.awscdk.core.IResolvable workflowDetails) {
            this.workflowDetails = workflowDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getWorkflowDetails}
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(software.amazon.awscdk.services.transfer.CfnServer.WorkflowDetailsProperty workflowDetails) {
            this.workflowDetails = workflowDetails;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServerProps {
        private final java.lang.String certificate;
        private final java.lang.String domain;
        private final java.lang.Object endpointDetails;
        private final java.lang.String endpointType;
        private final java.lang.Object identityProviderDetails;
        private final java.lang.String identityProviderType;
        private final java.lang.String loggingRole;
        private final java.lang.Object protocolDetails;
        private final java.util.List<java.lang.String> protocols;
        private final java.lang.String securityPolicyName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object workflowDetails;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointDetails = software.amazon.jsii.Kernel.get(this, "endpointDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderDetails = software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.identityProviderType = software.amazon.jsii.Kernel.get(this, "identityProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingRole = software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocolDetails = software.amazon.jsii.Kernel.get(this, "protocolDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityPolicyName = software.amazon.jsii.Kernel.get(this, "securityPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.workflowDetails = software.amazon.jsii.Kernel.get(this, "workflowDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = builder.certificate;
            this.domain = builder.domain;
            this.endpointDetails = builder.endpointDetails;
            this.endpointType = builder.endpointType;
            this.identityProviderDetails = builder.identityProviderDetails;
            this.identityProviderType = builder.identityProviderType;
            this.loggingRole = builder.loggingRole;
            this.protocolDetails = builder.protocolDetails;
            this.protocols = builder.protocols;
            this.securityPolicyName = builder.securityPolicyName;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.workflowDetails = builder.workflowDetails;
        }

        @Override
        public final java.lang.String getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.Object getEndpointDetails() {
            return this.endpointDetails;
        }

        @Override
        public final java.lang.String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final java.lang.Object getIdentityProviderDetails() {
            return this.identityProviderDetails;
        }

        @Override
        public final java.lang.String getIdentityProviderType() {
            return this.identityProviderType;
        }

        @Override
        public final java.lang.String getLoggingRole() {
            return this.loggingRole;
        }

        @Override
        public final java.lang.Object getProtocolDetails() {
            return this.protocolDetails;
        }

        @Override
        public final java.util.List<java.lang.String> getProtocols() {
            return this.protocols;
        }

        @Override
        public final java.lang.String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkflowDetails() {
            return this.workflowDetails;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getEndpointDetails() != null) {
                data.set("endpointDetails", om.valueToTree(this.getEndpointDetails()));
            }
            if (this.getEndpointType() != null) {
                data.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            if (this.getIdentityProviderDetails() != null) {
                data.set("identityProviderDetails", om.valueToTree(this.getIdentityProviderDetails()));
            }
            if (this.getIdentityProviderType() != null) {
                data.set("identityProviderType", om.valueToTree(this.getIdentityProviderType()));
            }
            if (this.getLoggingRole() != null) {
                data.set("loggingRole", om.valueToTree(this.getLoggingRole()));
            }
            if (this.getProtocolDetails() != null) {
                data.set("protocolDetails", om.valueToTree(this.getProtocolDetails()));
            }
            if (this.getProtocols() != null) {
                data.set("protocols", om.valueToTree(this.getProtocols()));
            }
            if (this.getSecurityPolicyName() != null) {
                data.set("securityPolicyName", om.valueToTree(this.getSecurityPolicyName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkflowDetails() != null) {
                data.set("workflowDetails", om.valueToTree(this.getWorkflowDetails()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServerProps.Jsii$Proxy that = (CfnServerProps.Jsii$Proxy) o;

            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.endpointDetails != null ? !this.endpointDetails.equals(that.endpointDetails) : that.endpointDetails != null) return false;
            if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
            if (this.identityProviderDetails != null ? !this.identityProviderDetails.equals(that.identityProviderDetails) : that.identityProviderDetails != null) return false;
            if (this.identityProviderType != null ? !this.identityProviderType.equals(that.identityProviderType) : that.identityProviderType != null) return false;
            if (this.loggingRole != null ? !this.loggingRole.equals(that.loggingRole) : that.loggingRole != null) return false;
            if (this.protocolDetails != null ? !this.protocolDetails.equals(that.protocolDetails) : that.protocolDetails != null) return false;
            if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
            if (this.securityPolicyName != null ? !this.securityPolicyName.equals(that.securityPolicyName) : that.securityPolicyName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workflowDetails != null ? this.workflowDetails.equals(that.workflowDetails) : that.workflowDetails == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificate != null ? this.certificate.hashCode() : 0;
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.endpointDetails != null ? this.endpointDetails.hashCode() : 0);
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            result = 31 * result + (this.identityProviderDetails != null ? this.identityProviderDetails.hashCode() : 0);
            result = 31 * result + (this.identityProviderType != null ? this.identityProviderType.hashCode() : 0);
            result = 31 * result + (this.loggingRole != null ? this.loggingRole.hashCode() : 0);
            result = 31 * result + (this.protocolDetails != null ? this.protocolDetails.hashCode() : 0);
            result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
            result = 31 * result + (this.securityPolicyName != null ? this.securityPolicyName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workflowDetails != null ? this.workflowDetails.hashCode() : 0);
            return result;
        }
    }
}
