package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `CfnWorkflow`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * Object copyStepDetails;
 * Object customStepDetails;
 * Object deleteStepDetails;
 * Object tagStepDetails;
 * CfnWorkflowProps cfnWorkflowProps = CfnWorkflowProps.builder()
 *         .steps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .onExceptionSteps(List.of(WorkflowStepProperty.builder()
 *                 .copyStepDetails(copyStepDetails)
 *                 .customStepDetails(customStepDetails)
 *                 .deleteStepDetails(deleteStepDetails)
 *                 .tagStepDetails(tagStepDetails)
 *                 .type("type")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:27:57.619Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnWorkflowProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkflowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkflowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the details for the steps that are in the specified workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSteps();

    /**
     * Specifies the text description for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnExceptionSteps() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for workflows.
     * <p>
     * Tags are metadata attached to workflows for any purpose.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkflowProps> {
        java.lang.Object steps;
        java.lang.String description;
        java.lang.Object onExceptionSteps;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnWorkflowProps#getSteps}
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(software.amazon.awscdk.core.IResolvable steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowProps#getSteps}
         * @param steps Specifies the details for the steps that are in the specified workflow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(java.util.List<? extends java.lang.Object> steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowProps#getDescription}
         * @param description Specifies the text description for the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowProps#getOnExceptionSteps}
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(software.amazon.awscdk.core.IResolvable onExceptionSteps) {
            this.onExceptionSteps = onExceptionSteps;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowProps#getOnExceptionSteps}
         * @param onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onExceptionSteps(java.util.List<? extends java.lang.Object> onExceptionSteps) {
            this.onExceptionSteps = onExceptionSteps;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for workflows.
         *             Tags are metadata attached to workflows for any purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkflowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkflowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkflowProps {
        private final java.lang.Object steps;
        private final java.lang.String description;
        private final java.lang.Object onExceptionSteps;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onExceptionSteps = software.amazon.jsii.Kernel.get(this, "onExceptionSteps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.steps = java.util.Objects.requireNonNull(builder.steps, "steps is required");
            this.description = builder.description;
            this.onExceptionSteps = builder.onExceptionSteps;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getSteps() {
            return this.steps;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getOnExceptionSteps() {
            return this.onExceptionSteps;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("steps", om.valueToTree(this.getSteps()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getOnExceptionSteps() != null) {
                data.set("onExceptionSteps", om.valueToTree(this.getOnExceptionSteps()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnWorkflowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkflowProps.Jsii$Proxy that = (CfnWorkflowProps.Jsii$Proxy) o;

            if (!steps.equals(that.steps)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.onExceptionSteps != null ? !this.onExceptionSteps.equals(that.onExceptionSteps) : that.onExceptionSteps != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.steps.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.onExceptionSteps != null ? this.onExceptionSteps.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
