package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `AWS::Transfer::User`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:48.041Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Transfer::User.Role`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRole();

    /**
     * `AWS::Transfer::User.ServerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServerId();

    /**
     * `AWS::Transfer::User.UserName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getUserName();

    /**
     * `AWS::Transfer::User.HomeDirectory`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getHomeDirectory() {
        return null;
    }

    /**
     * `AWS::Transfer::User.Policy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getPolicy() {
        return null;
    }

    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<java.lang.String> getSshPublicKeys() {
        return null;
    }

    /**
     * `AWS::Transfer::User.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String role;
        private java.lang.String serverId;
        private java.lang.String userName;
        private java.lang.String homeDirectory;
        private java.lang.String policy;
        private java.util.List<java.lang.String> sshPublicKeys;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of Role
         * @param role `AWS::Transfer::User.Role`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of ServerId
         * @param serverId `AWS::Transfer::User.ServerId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Sets the value of UserName
         * @param userName `AWS::Transfer::User.UserName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Sets the value of HomeDirectory
         * @param homeDirectory `AWS::Transfer::User.HomeDirectory`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder homeDirectory(java.lang.String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        /**
         * Sets the value of Policy
         * @param policy `AWS::Transfer::User.Policy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policy(java.lang.String policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of SshPublicKeys
         * @param sshPublicKeys `AWS::Transfer::User.SshPublicKeys`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sshPublicKeys(java.util.List<java.lang.String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::Transfer::User.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnUserProps build() {
            return new Jsii$Proxy(role, serverId, userName, homeDirectory, policy, sshPublicKeys, tags);
        }
    }

    /**
     * An implementation for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProps {
        private final java.lang.String role;
        private final java.lang.String serverId;
        private final java.lang.String userName;
        private final java.lang.String homeDirectory;
        private final java.lang.String policy;
        private final java.util.List<java.lang.String> sshPublicKeys;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = this.jsiiGet("role", java.lang.String.class);
            this.serverId = this.jsiiGet("serverId", java.lang.String.class);
            this.userName = this.jsiiGet("userName", java.lang.String.class);
            this.homeDirectory = this.jsiiGet("homeDirectory", java.lang.String.class);
            this.policy = this.jsiiGet("policy", java.lang.String.class);
            this.sshPublicKeys = this.jsiiGet("sshPublicKeys", java.util.List.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String role, final java.lang.String serverId, final java.lang.String userName, final java.lang.String homeDirectory, final java.lang.String policy, final java.util.List<java.lang.String> sshPublicKeys, final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.serverId = java.util.Objects.requireNonNull(serverId, "serverId is required");
            this.userName = java.util.Objects.requireNonNull(userName, "userName is required");
            this.homeDirectory = homeDirectory;
            this.policy = policy;
            this.sshPublicKeys = sshPublicKeys;
            this.tags = tags;
        }

        @Override
        public java.lang.String getRole() {
            return this.role;
        }

        @Override
        public java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        public java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        public java.lang.String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public java.lang.String getPolicy() {
            return this.policy;
        }

        @Override
        public java.util.List<java.lang.String> getSshPublicKeys() {
            return this.sshPublicKeys;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("serverId", om.valueToTree(this.getServerId()));
            data.set("userName", om.valueToTree(this.getUserName()));
            if (this.getHomeDirectory() != null) {
                data.set("homeDirectory", om.valueToTree(this.getHomeDirectory()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getSshPublicKeys() != null) {
                data.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProps.Jsii$Proxy that = (CfnUserProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!serverId.equals(that.serverId)) return false;
            if (!userName.equals(that.userName)) return false;
            if (this.homeDirectory != null ? !this.homeDirectory.equals(that.homeDirectory) : that.homeDirectory != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.sshPublicKeys != null ? !this.sshPublicKeys.equals(that.sshPublicKeys) : that.sshPublicKeys != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.serverId.hashCode());
            result = 31 * result + (this.userName.hashCode());
            result = 31 * result + (this.homeDirectory != null ? this.homeDirectory.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.sshPublicKeys != null ? this.sshPublicKeys.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
