package software.amazon.awscdk.services.transfer;

/**
 * A CloudFormation `AWS::Transfer::Server`.
 * <p>
 * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in AWS . When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated <code>ServerId</code> property that is assigned to the newly created server.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnServer cfnServer = CfnServer.Builder.create(this, "MyCfnServer")
 *         .certificate("certificate")
 *         .domain("domain")
 *         .endpointDetails(EndpointDetailsProperty.builder()
 *                 .addressAllocationIds(List.of("addressAllocationIds"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .vpcEndpointId("vpcEndpointId")
 *                 .vpcId("vpcId")
 *                 .build())
 *         .endpointType("endpointType")
 *         .identityProviderDetails(IdentityProviderDetailsProperty.builder()
 *                 .directoryId("directoryId")
 *                 .function("function")
 *                 .invocationRole("invocationRole")
 *                 .url("url")
 *                 .build())
 *         .identityProviderType("identityProviderType")
 *         .loggingRole("loggingRole")
 *         .postAuthenticationLoginBanner("postAuthenticationLoginBanner")
 *         .preAuthenticationLoginBanner("preAuthenticationLoginBanner")
 *         .protocolDetails(ProtocolDetailsProperty.builder()
 *                 .passiveIp("passiveIp")
 *                 .setStatOption("setStatOption")
 *                 .tlsSessionResumptionMode("tlsSessionResumptionMode")
 *                 .build())
 *         .protocols(List.of("protocols"))
 *         .securityPolicyName("securityPolicyName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workflowDetails(WorkflowDetailsProperty.builder()
 *                 .onUpload(List.of(WorkflowDetailProperty.builder()
 *                         .executionRole("executionRole")
 *                         .workflowId("workflowId")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-09T01:30:39.478Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer")
public class CfnServer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnServer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnServer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Transfer::Server`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Transfer::Server`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name associated with the server, in the form `arn:aws:transfer:region: *account-id* :server/ *server-id* /` .
     * <p>
     * An example of a server ARN is: <code>arn:aws:transfer:us-east-1:123456789012:server/s-01234567890abcdef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service-assigned ID of the server that is created.
     * <p>
     * An example <code>ServerId</code> is <code>s-01234567890abcdef</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServerId() {
        return software.amazon.jsii.Kernel.get(this, "attrServerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs that can be used to group and search for servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
     * <p>
     * Required when <code>Protocols</code> is set to <code>FTPS</code> .
     * <p>
     * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * Certificates with the following cryptographic algorithms and key sizes are supported:
     * <p>
     * <ul>
     * <li>2048-bit RSA (RSA_2048)</li>
     * <li>4096-bit RSA (RSA_4096)</li>
     * <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
     * <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
     * <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificate() {
        return software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
     * <p>
     * Required when <code>Protocols</code> is set to <code>FTPS</code> .
     * <p>
     * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * Certificates with the following cryptographic algorithms and key sizes are supported:
     * <p>
     * <ul>
     * <li>2048-bit RSA (RSA_2048)</li>
     * <li>4096-bit RSA (RSA_4096)</li>
     * <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
     * <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
     * <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificate", value);
    }

    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEndpointDetails() {
        return software.amazon.jsii.Kernel.get(this, "endpointDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "endpointDetails", value);
    }

    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "endpointDetails", value);
    }

    /**
     * The type of endpoint that you want your server to use.
     * <p>
     * You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of endpoint that you want your server to use.
     * <p>
     * You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointType", value);
    }

    /**
     * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderDetails() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", value);
    }

    /**
     * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderDetails", value);
    }

    /**
     * Specifies the mode of authentication for a server.
     * <p>
     * The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
     * <p>
     * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityProviderType() {
        return software.amazon.jsii.Kernel.get(this, "identityProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the mode of authentication for a server.
     * <p>
     * The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
     * <p>
     * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * <p>
     * Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityProviderType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityProviderType", value);
    }

    /**
     * Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events.
     * <p>
     * When set, user activity can be viewed in your CloudWatch logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events.
     * <p>
     * When set, user activity can be viewed in your CloudWatch logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loggingRole", value);
    }

    /**
     * Specify a string to display when users connect to a server. This string is displayed after the user authenticates.
     * <p>
     * <blockquote>
     * <p>
     * The SFTP protocol does not support post-authentication display banners.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPostAuthenticationLoginBanner() {
        return software.amazon.jsii.Kernel.get(this, "postAuthenticationLoginBanner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify a string to display when users connect to a server. This string is displayed after the user authenticates.
     * <p>
     * <blockquote>
     * <p>
     * The SFTP protocol does not support post-authentication display banners.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostAuthenticationLoginBanner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "postAuthenticationLoginBanner", value);
    }

    /**
     * Specify a string to display when users connect to a server.
     * <p>
     * This string is displayed before the user authenticates. For example, the following banner displays details about using the system.
     * <p>
     * <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreAuthenticationLoginBanner() {
        return software.amazon.jsii.Kernel.get(this, "preAuthenticationLoginBanner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify a string to display when users connect to a server.
     * <p>
     * This string is displayed before the user authenticates. For example, the following banner displays details about using the system.
     * <p>
     * <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreAuthenticationLoginBanner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preAuthenticationLoginBanner", value);
    }

    /**
     * The protocol settings that are configured for your server.
     * <p>
     * <ul>
     * <li>Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
     * <li>Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with <code>SetStatOption</code> set to <code>ENABLE_NO_OP</code> , Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.</li>
     * <li>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProtocolDetails() {
        return software.amazon.jsii.Kernel.get(this, "protocolDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The protocol settings that are configured for your server.
     * <p>
     * <ul>
     * <li>Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
     * <li>Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with <code>SetStatOption</code> set to <code>ENABLE_NO_OP</code> , Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.</li>
     * <li>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "protocolDetails", value);
    }

    /**
     * The protocol settings that are configured for your server.
     * <p>
     * <ul>
     * <li>Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
     * <li>Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with <code>SetStatOption</code> set to <code>ENABLE_NO_OP</code> , Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.</li>
     * <li>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.ProtocolDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "protocolDetails", value);
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
     * <p>
     * The available protocols are:
     * <p>
     * <ul>
     * <li><code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</li>
     * <li><code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</li>
     * <li><code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you select <code>FTPS</code> , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
     * <p>
     * If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code> , then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code> .
     * <p>
     * If <code>Protocol</code> includes <code>FTP</code> , then <code>AddressAllocationIds</code> cannot be associated.
     * <p>
     * If <code>Protocol</code> is set only to <code>SFTP</code> , the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
     * <p>
     * The available protocols are:
     * <p>
     * <ul>
     * <li><code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</li>
     * <li><code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</li>
     * <li><code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you select <code>FTPS</code> , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
     * <p>
     * If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code> , then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code> .
     * <p>
     * If <code>Protocol</code> includes <code>FTP</code> , then <code>AddressAllocationIds</code> cannot be associated.
     * <p>
     * If <code>Protocol</code> is set only to <code>SFTP</code> , the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocols(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "protocols", value);
    }

    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "securityPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityPolicyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityPolicyName", value);
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowDetails() {
        return software.amazon.jsii.Kernel.get(this, "workflowDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workflowDetails", value);
    }

    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnServer.WorkflowDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "workflowDetails", value);
    }
    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * <p>
     * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * EndpointDetailsProperty endpointDetailsProperty = EndpointDetailsProperty.builder()
     *         .addressAllocationIds(List.of("addressAllocationIds"))
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .vpcEndpointId("vpcEndpointId")
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer.EndpointDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAddressAllocationIds() {
            return null;
        }

        /**
         * A list of security groups IDs that are available to attach to your server's endpoint.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code> . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * A list of subnet IDs that are required to host your server endpoint in your VPC.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * The ID of the VPC endpoint.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
            return null;
        }

        /**
         * The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
         * <p>
         * <blockquote>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointDetailsProperty> {
            java.util.List<java.lang.String> addressAllocationIds;
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;
            java.lang.String vpcEndpointId;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link EndpointDetailsProperty#getAddressAllocationIds}
             * @param addressAllocationIds A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
             *                             <blockquote>
             *                             <p>
             *                             This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressAllocationIds(java.util.List<java.lang.String> addressAllocationIds) {
                this.addressAllocationIds = addressAllocationIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of security groups IDs that are available to attach to your server's endpoint.
             *                         <blockquote>
             *                         <p>
             *                         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *                         <p>
             *                         You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code> . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getSubnetIds}
             * @param subnetIds A list of subnet IDs that are required to host your server endpoint in your VPC.
             *                  <blockquote>
             *                  <p>
             *                  This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getVpcEndpointId}
             * @param vpcEndpointId The ID of the VPC endpoint.
             *                      <blockquote>
             *                      <p>
             *                      This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            /**
             * Sets the value of {@link EndpointDetailsProperty#getVpcId}
             * @param vpcId The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
             *              <blockquote>
             *              <p>
             *              This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointDetailsProperty {
            private final java.util.List<java.lang.String> addressAllocationIds;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.String vpcEndpointId;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addressAllocationIds = software.amazon.jsii.Kernel.get(this, "addressAllocationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addressAllocationIds = builder.addressAllocationIds;
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
                this.vpcEndpointId = builder.vpcEndpointId;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getAddressAllocationIds() {
                return this.addressAllocationIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.String getVpcEndpointId() {
                return this.vpcEndpointId;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddressAllocationIds() != null) {
                    data.set("addressAllocationIds", om.valueToTree(this.getAddressAllocationIds()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }
                if (this.getVpcEndpointId() != null) {
                    data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServer.EndpointDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointDetailsProperty.Jsii$Proxy that = (EndpointDetailsProperty.Jsii$Proxy) o;

                if (this.addressAllocationIds != null ? !this.addressAllocationIds.equals(that.addressAllocationIds) : that.addressAllocationIds != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
                if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addressAllocationIds != null ? this.addressAllocationIds.hashCode() : 0;
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
     * <p>
     * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * IdentityProviderDetailsProperty identityProviderDetailsProperty = IdentityProviderDetailsProperty.builder()
     *         .directoryId("directoryId")
     *         .function("function")
     *         .invocationRole("invocationRole")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityProviderDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityProviderDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the AWS Directory Service directory that you want to stop sharing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryId() {
            return null;
        }

        /**
         * The ARN for a lambda function to use for the Identity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunction() {
            return null;
        }

        /**
         * Provides the type of `InvocationRole` used to authenticate the user account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationRole() {
            return null;
        }

        /**
         * Provides the location of the service endpoint used to authenticate users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderDetailsProperty> {
            java.lang.String directoryId;
            java.lang.String function;
            java.lang.String invocationRole;
            java.lang.String url;

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getDirectoryId}
             * @param directoryId The identifier of the AWS Directory Service directory that you want to stop sharing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryId(java.lang.String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getFunction}
             * @param function The ARN for a lambda function to use for the Identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder function(java.lang.String function) {
                this.function = function;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getInvocationRole}
             * @param invocationRole Provides the type of `InvocationRole` used to authenticate the user account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationRole(java.lang.String invocationRole) {
                this.invocationRole = invocationRole;
                return this;
            }

            /**
             * Sets the value of {@link IdentityProviderDetailsProperty#getUrl}
             * @param url Provides the location of the service endpoint used to authenticate users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityProviderDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityProviderDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityProviderDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderDetailsProperty {
            private final java.lang.String directoryId;
            private final java.lang.String function;
            private final java.lang.String invocationRole;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryId = software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invocationRole = software.amazon.jsii.Kernel.get(this, "invocationRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryId = builder.directoryId;
                this.function = builder.function;
                this.invocationRole = builder.invocationRole;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getDirectoryId() {
                return this.directoryId;
            }

            @Override
            public final java.lang.String getFunction() {
                return this.function;
            }

            @Override
            public final java.lang.String getInvocationRole() {
                return this.invocationRole;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDirectoryId() != null) {
                    data.set("directoryId", om.valueToTree(this.getDirectoryId()));
                }
                if (this.getFunction() != null) {
                    data.set("function", om.valueToTree(this.getFunction()));
                }
                if (this.getInvocationRole() != null) {
                    data.set("invocationRole", om.valueToTree(this.getInvocationRole()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServer.IdentityProviderDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityProviderDetailsProperty.Jsii$Proxy that = (IdentityProviderDetailsProperty.Jsii$Proxy) o;

                if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) return false;
                if (this.function != null ? !this.function.equals(that.function) : that.function != null) return false;
                if (this.invocationRole != null ? !this.invocationRole.equals(that.invocationRole) : that.invocationRole != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.directoryId != null ? this.directoryId.hashCode() : 0;
                result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
                result = 31 * result + (this.invocationRole != null ? this.invocationRole.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Protocol settings that are configured for your server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * ProtocolDetailsProperty protocolDetailsProperty = ProtocolDetailsProperty.builder()
     *         .passiveIp("passiveIp")
     *         .setStatOption("setStatOption")
     *         .tlsSessionResumptionMode("tlsSessionResumptionMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer.ProtocolDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ProtocolDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProtocolDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates passive mode, for FTP and FTPS protocols.
         * <p>
         * Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
         * <p>
         * <code>aws transfer update-server --protocol-details PassiveIp= *0.0.0.0*</code>
         * <p>
         * Replace <code>*0.0.0.0*</code> in the example above with the actual IP address you want to use.
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see <a href="https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassiveIp() {
            return null;
        }

        /**
         * Use the `SetStatOption` to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket.
         * <p>
         * Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as SETSTAT when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
         * <p>
         * Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. While the <code>SetStatOption</code> <code>ENABLE_NO_OP</code> setting ignores the error, it does generate a log entry in CloudWatch Logs, so you can determine when the client is making a SETSTAT call.
         * <p>
         * <blockquote>
         * <p>
         * If you want to preserve the original timestamp for your file, and modify other file attributes using SETSTAT, you can use Amazon EFS as backend storage with Transfer Family.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSetStatOption() {
            return null;
        }

        /**
         * A property used with Transfer Family servers that use the FTPS protocol.
         * <p>
         * TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during <code>CreateServer</code> , it is set to <code>ENFORCED</code> by default.
         * <p>
         * <ul>
         * <li><code>DISABLED</code> : the server does not process TLS session resumption client requests and creates a new TLS session for each request.</li>
         * <li><code>ENABLED</code> : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</li>
         * <li><code>ENFORCED</code> : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code> , test your clients.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsSessionResumptionMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProtocolDetailsProperty> {
            java.lang.String passiveIp;
            java.lang.String setStatOption;
            java.lang.String tlsSessionResumptionMode;

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getPassiveIp}
             * @param passiveIp Indicates passive mode, for FTP and FTPS protocols.
             *                  Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
             *                  <p>
             *                  <code>aws transfer update-server --protocol-details PassiveIp= *0.0.0.0*</code>
             *                  <p>
             *                  Replace <code>*0.0.0.0*</code> in the example above with the actual IP address you want to use.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see <a href="https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family</a> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passiveIp(java.lang.String passiveIp) {
                this.passiveIp = passiveIp;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getSetStatOption}
             * @param setStatOption Use the `SetStatOption` to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket.
             *                      Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as SETSTAT when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
             *                      <p>
             *                      Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. While the <code>SetStatOption</code> <code>ENABLE_NO_OP</code> setting ignores the error, it does generate a log entry in CloudWatch Logs, so you can determine when the client is making a SETSTAT call.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If you want to preserve the original timestamp for your file, and modify other file attributes using SETSTAT, you can use Amazon EFS as backend storage with Transfer Family.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder setStatOption(java.lang.String setStatOption) {
                this.setStatOption = setStatOption;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolDetailsProperty#getTlsSessionResumptionMode}
             * @param tlsSessionResumptionMode A property used with Transfer Family servers that use the FTPS protocol.
             *                                 TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during <code>CreateServer</code> , it is set to <code>ENFORCED</code> by default.
             *                                 <p>
             *                                 <ul>
             *                                 <li><code>DISABLED</code> : the server does not process TLS session resumption client requests and creates a new TLS session for each request.</li>
             *                                 <li><code>ENABLED</code> : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</li>
             *                                 <li><code>ENFORCED</code> : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code> , test your clients.</li>
             *                                 </ul>
             *                                 <p>
             *                                 <blockquote>
             *                                 <p>
             *                                 Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.
             *                                 <p>
             *                                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsSessionResumptionMode(java.lang.String tlsSessionResumptionMode) {
                this.tlsSessionResumptionMode = tlsSessionResumptionMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProtocolDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProtocolDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProtocolDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProtocolDetailsProperty {
            private final java.lang.String passiveIp;
            private final java.lang.String setStatOption;
            private final java.lang.String tlsSessionResumptionMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.passiveIp = software.amazon.jsii.Kernel.get(this, "passiveIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.setStatOption = software.amazon.jsii.Kernel.get(this, "setStatOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tlsSessionResumptionMode = software.amazon.jsii.Kernel.get(this, "tlsSessionResumptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.passiveIp = builder.passiveIp;
                this.setStatOption = builder.setStatOption;
                this.tlsSessionResumptionMode = builder.tlsSessionResumptionMode;
            }

            @Override
            public final java.lang.String getPassiveIp() {
                return this.passiveIp;
            }

            @Override
            public final java.lang.String getSetStatOption() {
                return this.setStatOption;
            }

            @Override
            public final java.lang.String getTlsSessionResumptionMode() {
                return this.tlsSessionResumptionMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassiveIp() != null) {
                    data.set("passiveIp", om.valueToTree(this.getPassiveIp()));
                }
                if (this.getSetStatOption() != null) {
                    data.set("setStatOption", om.valueToTree(this.getSetStatOption()));
                }
                if (this.getTlsSessionResumptionMode() != null) {
                    data.set("tlsSessionResumptionMode", om.valueToTree(this.getTlsSessionResumptionMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServer.ProtocolDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProtocolDetailsProperty.Jsii$Proxy that = (ProtocolDetailsProperty.Jsii$Proxy) o;

                if (this.passiveIp != null ? !this.passiveIp.equals(that.passiveIp) : that.passiveIp != null) return false;
                if (this.setStatOption != null ? !this.setStatOption.equals(that.setStatOption) : that.setStatOption != null) return false;
                return this.tlsSessionResumptionMode != null ? this.tlsSessionResumptionMode.equals(that.tlsSessionResumptionMode) : that.tlsSessionResumptionMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.passiveIp != null ? this.passiveIp.hashCode() : 0;
                result = 31 * result + (this.setStatOption != null ? this.setStatOption.hashCode() : 0);
                result = 31 * result + (this.tlsSessionResumptionMode != null ? this.tlsSessionResumptionMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WorkflowDetailProperty workflowDetailProperty = WorkflowDetailProperty.builder()
     *         .executionRole("executionRole")
     *         .workflowId("workflowId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer.WorkflowDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * A unique identifier for the workflow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkflowId();

        /**
         * @return a {@link Builder} of {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowDetailProperty> {
            java.lang.String executionRole;
            java.lang.String workflowId;

            /**
             * Sets the value of {@link WorkflowDetailProperty#getExecutionRole}
             * @param executionRole Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailProperty#getWorkflowId}
             * @param workflowId A unique identifier for the workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowId(java.lang.String workflowId) {
                this.workflowId = workflowId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowDetailProperty {
            private final java.lang.String executionRole;
            private final java.lang.String workflowId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workflowId = software.amazon.jsii.Kernel.get(this, "workflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.workflowId = java.util.Objects.requireNonNull(builder.workflowId, "workflowId is required");
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.String getWorkflowId() {
                return this.workflowId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                data.set("workflowId", om.valueToTree(this.getWorkflowId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServer.WorkflowDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowDetailProperty.Jsii$Proxy that = (WorkflowDetailProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                return this.workflowId.equals(that.workflowId);
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.workflowId.hashCode());
                return result;
            }
        }
    }
    /**
     * Container for the `WorkflowDetail` data type.
     * <p>
     * It is used by actions that trigger a workflow to begin execution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * WorkflowDetailsProperty workflowDetailsProperty = WorkflowDetailsProperty.builder()
     *         .onUpload(List.of(WorkflowDetailProperty.builder()
     *                 .executionRole("executionRole")
     *                 .workflowId("workflowId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnServer.WorkflowDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
         * <p>
         * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
         * <p>
         * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOnUpload();

        /**
         * @return a {@link Builder} of {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowDetailsProperty> {
            java.lang.Object onUpload;

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnUpload}
             * @param onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. This parameter is required.
             *                 To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
             *                 <p>
             *                 <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUpload(software.amazon.awscdk.core.IResolvable onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowDetailsProperty#getOnUpload}
             * @param onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. This parameter is required.
             *                 To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the following example.
             *                 <p>
             *                 <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUpload(java.util.List<? extends java.lang.Object> onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowDetailsProperty {
            private final java.lang.Object onUpload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onUpload = software.amazon.jsii.Kernel.get(this, "onUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onUpload = java.util.Objects.requireNonNull(builder.onUpload, "onUpload is required");
            }

            @Override
            public final java.lang.Object getOnUpload() {
                return this.onUpload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onUpload", om.valueToTree(this.getOnUpload()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnServer.WorkflowDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowDetailsProperty.Jsii$Proxy that = (WorkflowDetailsProperty.Jsii$Proxy) o;

                return this.onUpload.equals(that.onUpload);
            }

            @Override
            public final int hashCode() {
                int result = this.onUpload.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnServer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnServer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.transfer.CfnServerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate.
         * <p>
         * Required when <code>Protocols</code> is set to <code>FTPS</code> .
         * <p>
         * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * Certificates with the following cryptographic algorithms and key sizes are supported:
         * <p>
         * <ul>
         * <li>2048-bit RSA (RSA_2048)</li>
         * <li>4096-bit RSA (RSA_4096)</li>
         * <li>Elliptic Prime Curve 256 bit (EC_prime256v1)</li>
         * <li>Elliptic Prime Curve 384 bit (EC_secp384r1)</li>
         * <li>Elliptic Prime Curve 521 bit (EC_secp521r1)</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(final java.lang.String certificate) {
            this.props().certificate(certificate);
            return this;
        }

        /**
         * Specifies the domain of the storage system that is used for file transfers.
         * <p>
         * @return {@code this}
         * @param domain Specifies the domain of the storage system that is used for file transfers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server.
         * <p>
         * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         * <p>
         * @return {@code this}
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(final software.amazon.awscdk.services.transfer.CfnServer.EndpointDetailsProperty endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }
        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server.
         * <p>
         * When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         * <p>
         * @return {@code this}
         * @param endpointDetails The virtual private cloud (VPC) endpoint settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointDetails(final software.amazon.awscdk.core.IResolvable endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        /**
         * The type of endpoint that you want your server to use.
         * <p>
         * You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
         * <p>
         * @return {@code this}
         * @param endpointType The type of endpoint that you want your server to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final java.lang.String endpointType) {
            this.props().endpointType(endpointType);
            return this;
        }

        /**
         * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
         * <p>
         * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * <p>
         * @return {@code this}
         * @param identityProviderDetails Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.core.IResolvable identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }
        /**
         * Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` .
         * <p>
         * Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code> .
         * <p>
         * @return {@code this}
         * @param identityProviderDetails Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` or `API_GATEWAY` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderDetails(final software.amazon.awscdk.services.transfer.CfnServer.IdentityProviderDetailsProperty identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        /**
         * Specifies the mode of authentication for a server.
         * <p>
         * The default value is <code>SERVICE_MANAGED</code> , which allows you to store and access user credentials within the AWS Transfer Family service.
         * <p>
         * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.
         * <p>
         * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
         * <p>
         * Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.
         * <p>
         * @return {@code this}
         * @param identityProviderType Specifies the mode of authentication for a server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderType(final java.lang.String identityProviderType) {
            this.props().identityProviderType(identityProviderType);
            return this;
        }

        /**
         * Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events.
         * <p>
         * When set, user activity can be viewed in your CloudWatch logs.
         * <p>
         * @return {@code this}
         * @param loggingRole Specifies the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(final java.lang.String loggingRole) {
            this.props().loggingRole(loggingRole);
            return this;
        }

        /**
         * Specify a string to display when users connect to a server. This string is displayed after the user authenticates.
         * <p>
         * <blockquote>
         * <p>
         * The SFTP protocol does not support post-authentication display banners.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param postAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed after the user authenticates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postAuthenticationLoginBanner(final java.lang.String postAuthenticationLoginBanner) {
            this.props().postAuthenticationLoginBanner(postAuthenticationLoginBanner);
            return this;
        }

        /**
         * Specify a string to display when users connect to a server.
         * <p>
         * This string is displayed before the user authenticates. For example, the following banner displays details about using the system.
         * <p>
         * <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code>
         * <p>
         * @return {@code this}
         * @param preAuthenticationLoginBanner Specify a string to display when users connect to a server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preAuthenticationLoginBanner(final java.lang.String preAuthenticationLoginBanner) {
            this.props().preAuthenticationLoginBanner(preAuthenticationLoginBanner);
            return this;
        }

        /**
         * The protocol settings that are configured for your server.
         * <p>
         * <ul>
         * <li>Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
         * <li>Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with <code>SetStatOption</code> set to <code>ENABLE_NO_OP</code> , Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.</li>
         * <li>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param protocolDetails The protocol settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(final software.amazon.awscdk.core.IResolvable protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }
        /**
         * The protocol settings that are configured for your server.
         * <p>
         * <ul>
         * <li>Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.</li>
         * <li>Use the <code>SetStatOption</code> to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to <code>ENABLE_NO_OP</code> to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with <code>SetStatOption</code> set to <code>ENABLE_NO_OP</code> , Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.</li>
         * <li>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param protocolDetails The protocol settings that are configured for your server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolDetails(final software.amazon.awscdk.services.transfer.CfnServer.ProtocolDetailsProperty protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        /**
         * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint.
         * <p>
         * The available protocols are:
         * <p>
         * <ul>
         * <li><code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</li>
         * <li><code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</li>
         * <li><code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you select <code>FTPS</code> , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
         * <p>
         * If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code> , then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code> .
         * <p>
         * If <code>Protocol</code> includes <code>FTP</code> , then <code>AddressAllocationIds</code> cannot be associated.
         * <p>
         * If <code>Protocol</code> is set only to <code>SFTP</code> , the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocols(final java.util.List<java.lang.String> protocols) {
            this.props().protocols(protocols);
            return this;
        }

        /**
         * Specifies the name of the security policy that is attached to the server.
         * <p>
         * @return {@code this}
         * @param securityPolicyName Specifies the name of the security policy that is attached to the server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicyName(final java.lang.String securityPolicyName) {
            this.props().securityPolicyName(securityPolicyName);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for servers.
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs that can be used to group and search for servers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         * <p>
         * @return {@code this}
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(final software.amazon.awscdk.core.IResolvable workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }
        /**
         * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         * <p>
         * @return {@code this}
         * @param workflowDetails Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowDetails(final software.amazon.awscdk.services.transfer.CfnServer.WorkflowDetailsProperty workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnServer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnServer build() {
            return new software.amazon.awscdk.services.transfer.CfnServer(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.transfer.CfnServerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.transfer.CfnServerProps.Builder();
            }
            return this.props;
        }
    }
}
