package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `CfnProfile`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnProfileProps cfnProfileProps = CfnProfileProps.builder()
 *         .as2Id("as2Id")
 *         .profileType("profileType")
 *         // the properties below are optional
 *         .certificateIds(List.of("certificateIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T02:14:07.159Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Transfer::Profile.As2Id`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAs2Id();

    /**
     * `AWS::Transfer::Profile.ProfileType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProfileType();

    /**
     * `AWS::Transfer::Profile.CertificateIds`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateIds() {
        return null;
    }

    /**
     * `AWS::Transfer::Profile.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProfileProps> {
        java.lang.String as2Id;
        java.lang.String profileType;
        java.util.List<java.lang.String> certificateIds;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProfileProps#getAs2Id}
         * @param as2Id `AWS::Transfer::Profile.As2Id`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder as2Id(java.lang.String as2Id) {
            this.as2Id = as2Id;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getProfileType}
         * @param profileType `AWS::Transfer::Profile.ProfileType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileType(java.lang.String profileType) {
            this.profileType = profileType;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getCertificateIds}
         * @param certificateIds `AWS::Transfer::Profile.CertificateIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateIds(java.util.List<java.lang.String> certificateIds) {
            this.certificateIds = certificateIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnProfileProps#getTags}
         * @param tags `AWS::Transfer::Profile.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProfileProps {
        private final java.lang.String as2Id;
        private final java.lang.String profileType;
        private final java.util.List<java.lang.String> certificateIds;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.as2Id = software.amazon.jsii.Kernel.get(this, "as2Id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.profileType = software.amazon.jsii.Kernel.get(this, "profileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateIds = software.amazon.jsii.Kernel.get(this, "certificateIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.as2Id = java.util.Objects.requireNonNull(builder.as2Id, "as2Id is required");
            this.profileType = java.util.Objects.requireNonNull(builder.profileType, "profileType is required");
            this.certificateIds = builder.certificateIds;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAs2Id() {
            return this.as2Id;
        }

        @Override
        public final java.lang.String getProfileType() {
            return this.profileType;
        }

        @Override
        public final java.util.List<java.lang.String> getCertificateIds() {
            return this.certificateIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("as2Id", om.valueToTree(this.getAs2Id()));
            data.set("profileType", om.valueToTree(this.getProfileType()));
            if (this.getCertificateIds() != null) {
                data.set("certificateIds", om.valueToTree(this.getCertificateIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProfileProps.Jsii$Proxy that = (CfnProfileProps.Jsii$Proxy) o;

            if (!as2Id.equals(that.as2Id)) return false;
            if (!profileType.equals(that.profileType)) return false;
            if (this.certificateIds != null ? !this.certificateIds.equals(that.certificateIds) : that.certificateIds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.as2Id.hashCode();
            result = 31 * result + (this.profileType.hashCode());
            result = 31 * result + (this.certificateIds != null ? this.certificateIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
