package software.amazon.awscdk.services.transfer;

/**
 * A CloudFormation `AWS::Transfer::Connector`.
 * <p>
 * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The connector is required for sending files to an externally hosted AS2 server. For more details about connectors, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/create-b2b-server.html#configure-as2-connector">Create AS2 connectors</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnConnector cfnConnector = CfnConnector.Builder.create(this, "MyCfnConnector")
 *         .accessRole("accessRole")
 *         .as2Config(As2ConfigProperty.builder()
 *                 .compression("compression")
 *                 .encryptionAlgorithm("encryptionAlgorithm")
 *                 .localProfileId("localProfileId")
 *                 .mdnResponse("mdnResponse")
 *                 .mdnSigningAlgorithm("mdnSigningAlgorithm")
 *                 .messageSubject("messageSubject")
 *                 .partnerProfileId("partnerProfileId")
 *                 .signingAlgorithm("signingAlgorithm")
 *                 .build())
 *         .url("url")
 *         // the properties below are optional
 *         .loggingRole("loggingRole")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:46.881Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnConnector")
public class CfnConnector extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnConnector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnConnector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Transfer::Connector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnector(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnConnectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectorId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key-value pairs that can be used to group and search for connectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` .
     * <p>
     * We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessRole() {
        return software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` .
     * <p>
     * We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessRole", java.util.Objects.requireNonNull(value, "accessRole is required"));
    }

    /**
     * A structure that contains the parameters for a connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAs2Config() {
        return software.amazon.jsii.Kernel.get(this, "as2Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the parameters for a connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAs2Config(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnConnector.As2ConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "as2Config", java.util.Objects.requireNonNull(value, "as2Config is required"));
    }

    /**
     * A structure that contains the parameters for a connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAs2Config(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "as2Config", java.util.Objects.requireNonNull(value, "as2Config is required"));
    }

    /**
     * The URL of the partner's AS2 endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the partner's AS2 endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "url", java.util.Objects.requireNonNull(value, "url is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
     * <p>
     * When set, you can view connector activity in your CloudWatch logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
     * <p>
     * When set, you can view connector activity in your CloudWatch logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loggingRole", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * As2ConfigProperty as2ConfigProperty = As2ConfigProperty.builder()
     *         .compression("compression")
     *         .encryptionAlgorithm("encryptionAlgorithm")
     *         .localProfileId("localProfileId")
     *         .mdnResponse("mdnResponse")
     *         .mdnSigningAlgorithm("mdnSigningAlgorithm")
     *         .messageSubject("messageSubject")
     *         .partnerProfileId("partnerProfileId")
     *         .signingAlgorithm("signingAlgorithm")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnConnector.As2ConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(As2ConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface As2ConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConnector.As2ConfigProperty.Compression`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.EncryptionAlgorithm`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionAlgorithm() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.LocalProfileId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalProfileId() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.MdnResponse`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMdnResponse() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.MdnSigningAlgorithm`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMdnSigningAlgorithm() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.MessageSubject`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageSubject() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.PartnerProfileId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPartnerProfileId() {
            return null;
        }

        /**
         * `CfnConnector.As2ConfigProperty.SigningAlgorithm`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSigningAlgorithm() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<As2ConfigProperty> {
            java.lang.String compression;
            java.lang.String encryptionAlgorithm;
            java.lang.String localProfileId;
            java.lang.String mdnResponse;
            java.lang.String mdnSigningAlgorithm;
            java.lang.String messageSubject;
            java.lang.String partnerProfileId;
            java.lang.String signingAlgorithm;

            /**
             * Sets the value of {@link As2ConfigProperty#getCompression}
             * @param compression `CfnConnector.As2ConfigProperty.Compression`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getEncryptionAlgorithm}
             * @param encryptionAlgorithm `CfnConnector.As2ConfigProperty.EncryptionAlgorithm`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionAlgorithm(java.lang.String encryptionAlgorithm) {
                this.encryptionAlgorithm = encryptionAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getLocalProfileId}
             * @param localProfileId `CfnConnector.As2ConfigProperty.LocalProfileId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localProfileId(java.lang.String localProfileId) {
                this.localProfileId = localProfileId;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMdnResponse}
             * @param mdnResponse `CfnConnector.As2ConfigProperty.MdnResponse`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mdnResponse(java.lang.String mdnResponse) {
                this.mdnResponse = mdnResponse;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMdnSigningAlgorithm}
             * @param mdnSigningAlgorithm `CfnConnector.As2ConfigProperty.MdnSigningAlgorithm`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mdnSigningAlgorithm(java.lang.String mdnSigningAlgorithm) {
                this.mdnSigningAlgorithm = mdnSigningAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMessageSubject}
             * @param messageSubject `CfnConnector.As2ConfigProperty.MessageSubject`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageSubject(java.lang.String messageSubject) {
                this.messageSubject = messageSubject;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getPartnerProfileId}
             * @param partnerProfileId `CfnConnector.As2ConfigProperty.PartnerProfileId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partnerProfileId(java.lang.String partnerProfileId) {
                this.partnerProfileId = partnerProfileId;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getSigningAlgorithm}
             * @param signingAlgorithm `CfnConnector.As2ConfigProperty.SigningAlgorithm`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingAlgorithm(java.lang.String signingAlgorithm) {
                this.signingAlgorithm = signingAlgorithm;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link As2ConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public As2ConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements As2ConfigProperty {
            private final java.lang.String compression;
            private final java.lang.String encryptionAlgorithm;
            private final java.lang.String localProfileId;
            private final java.lang.String mdnResponse;
            private final java.lang.String mdnSigningAlgorithm;
            private final java.lang.String messageSubject;
            private final java.lang.String partnerProfileId;
            private final java.lang.String signingAlgorithm;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionAlgorithm = software.amazon.jsii.Kernel.get(this, "encryptionAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localProfileId = software.amazon.jsii.Kernel.get(this, "localProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mdnResponse = software.amazon.jsii.Kernel.get(this, "mdnResponse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mdnSigningAlgorithm = software.amazon.jsii.Kernel.get(this, "mdnSigningAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageSubject = software.amazon.jsii.Kernel.get(this, "messageSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partnerProfileId = software.amazon.jsii.Kernel.get(this, "partnerProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingAlgorithm = software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compression = builder.compression;
                this.encryptionAlgorithm = builder.encryptionAlgorithm;
                this.localProfileId = builder.localProfileId;
                this.mdnResponse = builder.mdnResponse;
                this.mdnSigningAlgorithm = builder.mdnSigningAlgorithm;
                this.messageSubject = builder.messageSubject;
                this.partnerProfileId = builder.partnerProfileId;
                this.signingAlgorithm = builder.signingAlgorithm;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.String getEncryptionAlgorithm() {
                return this.encryptionAlgorithm;
            }

            @Override
            public final java.lang.String getLocalProfileId() {
                return this.localProfileId;
            }

            @Override
            public final java.lang.String getMdnResponse() {
                return this.mdnResponse;
            }

            @Override
            public final java.lang.String getMdnSigningAlgorithm() {
                return this.mdnSigningAlgorithm;
            }

            @Override
            public final java.lang.String getMessageSubject() {
                return this.messageSubject;
            }

            @Override
            public final java.lang.String getPartnerProfileId() {
                return this.partnerProfileId;
            }

            @Override
            public final java.lang.String getSigningAlgorithm() {
                return this.signingAlgorithm;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getEncryptionAlgorithm() != null) {
                    data.set("encryptionAlgorithm", om.valueToTree(this.getEncryptionAlgorithm()));
                }
                if (this.getLocalProfileId() != null) {
                    data.set("localProfileId", om.valueToTree(this.getLocalProfileId()));
                }
                if (this.getMdnResponse() != null) {
                    data.set("mdnResponse", om.valueToTree(this.getMdnResponse()));
                }
                if (this.getMdnSigningAlgorithm() != null) {
                    data.set("mdnSigningAlgorithm", om.valueToTree(this.getMdnSigningAlgorithm()));
                }
                if (this.getMessageSubject() != null) {
                    data.set("messageSubject", om.valueToTree(this.getMessageSubject()));
                }
                if (this.getPartnerProfileId() != null) {
                    data.set("partnerProfileId", om.valueToTree(this.getPartnerProfileId()));
                }
                if (this.getSigningAlgorithm() != null) {
                    data.set("signingAlgorithm", om.valueToTree(this.getSigningAlgorithm()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnConnector.As2ConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                As2ConfigProperty.Jsii$Proxy that = (As2ConfigProperty.Jsii$Proxy) o;

                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.encryptionAlgorithm != null ? !this.encryptionAlgorithm.equals(that.encryptionAlgorithm) : that.encryptionAlgorithm != null) return false;
                if (this.localProfileId != null ? !this.localProfileId.equals(that.localProfileId) : that.localProfileId != null) return false;
                if (this.mdnResponse != null ? !this.mdnResponse.equals(that.mdnResponse) : that.mdnResponse != null) return false;
                if (this.mdnSigningAlgorithm != null ? !this.mdnSigningAlgorithm.equals(that.mdnSigningAlgorithm) : that.mdnSigningAlgorithm != null) return false;
                if (this.messageSubject != null ? !this.messageSubject.equals(that.messageSubject) : that.messageSubject != null) return false;
                if (this.partnerProfileId != null ? !this.partnerProfileId.equals(that.partnerProfileId) : that.partnerProfileId != null) return false;
                return this.signingAlgorithm != null ? this.signingAlgorithm.equals(that.signingAlgorithm) : that.signingAlgorithm == null;
            }

            @Override
            public final int hashCode() {
                int result = this.compression != null ? this.compression.hashCode() : 0;
                result = 31 * result + (this.encryptionAlgorithm != null ? this.encryptionAlgorithm.hashCode() : 0);
                result = 31 * result + (this.localProfileId != null ? this.localProfileId.hashCode() : 0);
                result = 31 * result + (this.mdnResponse != null ? this.mdnResponse.hashCode() : 0);
                result = 31 * result + (this.mdnSigningAlgorithm != null ? this.mdnSigningAlgorithm.hashCode() : 0);
                result = 31 * result + (this.messageSubject != null ? this.messageSubject.hashCode() : 0);
                result = 31 * result + (this.partnerProfileId != null ? this.partnerProfileId.hashCode() : 0);
                result = 31 * result + (this.signingAlgorithm != null ? this.signingAlgorithm.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnConnector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnConnector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnConnectorProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnConnectorProps.Builder();
        }

        /**
         * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` .
         * <p>
         * We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         * <p>
         * @return {@code this}
         * @param accessRole With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(final java.lang.String accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        /**
         * A structure that contains the parameters for a connector object.
         * <p>
         * @return {@code this}
         * @param as2Config A structure that contains the parameters for a connector object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder as2Config(final software.amazon.awscdk.services.transfer.CfnConnector.As2ConfigProperty as2Config) {
            this.props.as2Config(as2Config);
            return this;
        }
        /**
         * A structure that contains the parameters for a connector object.
         * <p>
         * @return {@code this}
         * @param as2Config A structure that contains the parameters for a connector object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder as2Config(final software.amazon.awscdk.core.IResolvable as2Config) {
            this.props.as2Config(as2Config);
            return this;
        }

        /**
         * The URL of the partner's AS2 endpoint.
         * <p>
         * @return {@code this}
         * @param url The URL of the partner's AS2 endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
         * <p>
         * When set, you can view connector activity in your CloudWatch logs.
         * <p>
         * @return {@code this}
         * @param loggingRole The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(final java.lang.String loggingRole) {
            this.props.loggingRole(loggingRole);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for connectors.
         * <p>
         * @return {@code this}
         * @param tags Key-value pairs that can be used to group and search for connectors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnConnector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnConnector build() {
            return new software.amazon.awscdk.services.transfer.CfnConnector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
