package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `CfnAgreement`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * CfnAgreementProps cfnAgreementProps = CfnAgreementProps.builder()
 *         .accessRole("accessRole")
 *         .baseDirectory("baseDirectory")
 *         .localProfileId("localProfileId")
 *         .partnerProfileId("partnerProfileId")
 *         .serverId("serverId")
 *         // the properties below are optional
 *         .description("description")
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T20:01:35.816Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnAgreementProps")
@software.amazon.jsii.Jsii.Proxy(CfnAgreementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAgreementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` .
     * <p>
     * We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessRole();

    /**
     * The landing directory (folder) for files that are transferred by using the AS2 protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaseDirectory();

    /**
     * A unique identifier for the AS2 local profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalProfileId();

    /**
     * A unique identifier for the partner profile used in the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPartnerProfileId();

    /**
     * A system-assigned unique identifier for a server instance.
     * <p>
     * This identifier indicates the specific server that the agreement uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerId();

    /**
     * The name or short description that's used to identify the agreement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The current status of the agreement, either `ACTIVE` or `INACTIVE` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * Key-value pairs that can be used to group and search for agreements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAgreementProps> {
        java.lang.String accessRole;
        java.lang.String baseDirectory;
        java.lang.String localProfileId;
        java.lang.String partnerProfileId;
        java.lang.String serverId;
        java.lang.String description;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAgreementProps#getAccessRole}
         * @param accessRole With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths` . This parameter is required.
         *                   We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(java.lang.String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getBaseDirectory}
         * @param baseDirectory The landing directory (folder) for files that are transferred by using the AS2 protocol. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseDirectory(java.lang.String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getLocalProfileId}
         * @param localProfileId A unique identifier for the AS2 local profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localProfileId(java.lang.String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getPartnerProfileId}
         * @param partnerProfileId A unique identifier for the partner profile used in the agreement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partnerProfileId(java.lang.String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getServerId}
         * @param serverId A system-assigned unique identifier for a server instance. This parameter is required.
         *                 This identifier indicates the specific server that the agreement uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getDescription}
         * @param description The name or short description that's used to identify the agreement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getStatus}
         * @param status The current status of the agreement, either `ACTIVE` or `INACTIVE` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgreementProps#getTags}
         * @param tags Key-value pairs that can be used to group and search for agreements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAgreementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAgreementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAgreementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAgreementProps {
        private final java.lang.String accessRole;
        private final java.lang.String baseDirectory;
        private final java.lang.String localProfileId;
        private final java.lang.String partnerProfileId;
        private final java.lang.String serverId;
        private final java.lang.String description;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessRole = software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.baseDirectory = software.amazon.jsii.Kernel.get(this, "baseDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localProfileId = software.amazon.jsii.Kernel.get(this, "localProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partnerProfileId = software.amazon.jsii.Kernel.get(this, "partnerProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverId = software.amazon.jsii.Kernel.get(this, "serverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessRole = java.util.Objects.requireNonNull(builder.accessRole, "accessRole is required");
            this.baseDirectory = java.util.Objects.requireNonNull(builder.baseDirectory, "baseDirectory is required");
            this.localProfileId = java.util.Objects.requireNonNull(builder.localProfileId, "localProfileId is required");
            this.partnerProfileId = java.util.Objects.requireNonNull(builder.partnerProfileId, "partnerProfileId is required");
            this.serverId = java.util.Objects.requireNonNull(builder.serverId, "serverId is required");
            this.description = builder.description;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAccessRole() {
            return this.accessRole;
        }

        @Override
        public final java.lang.String getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        public final java.lang.String getLocalProfileId() {
            return this.localProfileId;
        }

        @Override
        public final java.lang.String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        @Override
        public final java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessRole", om.valueToTree(this.getAccessRole()));
            data.set("baseDirectory", om.valueToTree(this.getBaseDirectory()));
            data.set("localProfileId", om.valueToTree(this.getLocalProfileId()));
            data.set("partnerProfileId", om.valueToTree(this.getPartnerProfileId()));
            data.set("serverId", om.valueToTree(this.getServerId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnAgreementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAgreementProps.Jsii$Proxy that = (CfnAgreementProps.Jsii$Proxy) o;

            if (!accessRole.equals(that.accessRole)) return false;
            if (!baseDirectory.equals(that.baseDirectory)) return false;
            if (!localProfileId.equals(that.localProfileId)) return false;
            if (!partnerProfileId.equals(that.partnerProfileId)) return false;
            if (!serverId.equals(that.serverId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessRole.hashCode();
            result = 31 * result + (this.baseDirectory.hashCode());
            result = 31 * result + (this.localProfileId.hashCode());
            result = 31 * result + (this.partnerProfileId.hashCode());
            result = 31 * result + (this.serverId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
