package software.amazon.awscdk.services.transfer;

/**
 * A CloudFormation `AWS::Transfer::User`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-09T11:48:05.063Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnUser")
public class CfnUser extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnUser(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUser(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnUser.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Transfer::User`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnUserProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServerId() {
        return this.jsiiGet("attrServerId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUserName() {
        return this.jsiiGet("attrUserName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Transfer::User.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Transfer::User.Role`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getRole() {
        return this.jsiiGet("role", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.Role`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("role", java.util.Objects.requireNonNull(value, "role is required"));
    }

    /**
     * `AWS::Transfer::User.ServerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerId() {
        return this.jsiiGet("serverId", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.ServerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setServerId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serverId", java.util.Objects.requireNonNull(value, "serverId is required"));
    }

    /**
     * `AWS::Transfer::User.UserName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserName() {
        return this.jsiiGet("userName", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.UserName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setUserName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("userName", java.util.Objects.requireNonNull(value, "userName is required"));
    }

    /**
     * `AWS::Transfer::User.HomeDirectory`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectory() {
        return this.jsiiGet("homeDirectory", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.HomeDirectory`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHomeDirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("homeDirectory", value);
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHomeDirectoryMappings() {
        return this.jsiiGet("homeDirectoryMappings", java.lang.Object.class);
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHomeDirectoryMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("homeDirectoryMappings", value);
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHomeDirectoryMappings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("homeDirectoryMappings", value);
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectoryType() {
        return this.jsiiGet("homeDirectoryType", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHomeDirectoryType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("homeDirectoryType", value);
    }

    /**
     * `AWS::Transfer::User.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getPolicy() {
        return this.jsiiGet("policy", java.lang.String.class);
    }

    /**
     * `AWS::Transfer::User.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("policy", value);
    }

    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSshPublicKeys() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("sshPublicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSshPublicKeys(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("sshPublicKeys", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnUser.HomeDirectoryMapEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(HomeDirectoryMapEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HomeDirectoryMapEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUser.HomeDirectoryMapEntryProperty.Entry`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html#cfn-transfer-user-homedirectorymapentry-entry
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getEntry();

        /**
         * `CfnUser.HomeDirectoryMapEntryProperty.Target`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html#cfn-transfer-user-homedirectorymapentry-target
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * @return a {@link Builder} of {@link HomeDirectoryMapEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HomeDirectoryMapEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String entry;
            private java.lang.String target;

            /**
             * Sets the value of {@link HomeDirectoryMapEntryProperty#getEntry}
             * @param entry `CfnUser.HomeDirectoryMapEntryProperty.Entry`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder entry(java.lang.String entry) {
                this.entry = entry;
                return this;
            }

            /**
             * Sets the value of {@link HomeDirectoryMapEntryProperty#getTarget}
             * @param target `CfnUser.HomeDirectoryMapEntryProperty.Target`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HomeDirectoryMapEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HomeDirectoryMapEntryProperty build() {
                return new Jsii$Proxy(entry, target);
            }
        }

        /**
         * An implementation for {@link HomeDirectoryMapEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HomeDirectoryMapEntryProperty {
            private final java.lang.String entry;
            private final java.lang.String target;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entry = this.jsiiGet("entry", java.lang.String.class);
                this.target = this.jsiiGet("target", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String entry, final java.lang.String target) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entry = java.util.Objects.requireNonNull(entry, "entry is required");
                this.target = java.util.Objects.requireNonNull(target, "target is required");
            }

            @Override
            public java.lang.String getEntry() {
                return this.entry;
            }

            @Override
            public java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entry", om.valueToTree(this.getEntry()));
                data.set("target", om.valueToTree(this.getTarget()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnUser.HomeDirectoryMapEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HomeDirectoryMapEntryProperty.Jsii$Proxy that = (HomeDirectoryMapEntryProperty.Jsii$Proxy) o;

                if (!entry.equals(that.entry)) return false;
                return this.target.equals(that.target);
            }

            @Override
            public int hashCode() {
                int result = this.entry.hashCode();
                result = 31 * result + (this.target.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnUser}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnUserProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnUserProps.Builder();
        }

        /**
         * `AWS::Transfer::User.Role`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
         * @param role `AWS::Transfer::User.Role`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder role(final java.lang.String role) {
            this.props.role(role);
            return this;
        }

        /**
         * `AWS::Transfer::User.ServerId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
         * @param serverId `AWS::Transfer::User.ServerId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serverId(final java.lang.String serverId) {
            this.props.serverId(serverId);
            return this;
        }

        /**
         * `AWS::Transfer::User.UserName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
         * @param userName `AWS::Transfer::User.UserName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder userName(final java.lang.String userName) {
            this.props.userName(userName);
            return this;
        }

        /**
         * `AWS::Transfer::User.HomeDirectory`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
         * @param homeDirectory `AWS::Transfer::User.HomeDirectory`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder homeDirectory(final java.lang.String homeDirectory) {
            this.props.homeDirectory(homeDirectory);
            return this;
        }

        /**
         * `AWS::Transfer::User.HomeDirectoryMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
         * @param homeDirectoryMappings `AWS::Transfer::User.HomeDirectoryMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder homeDirectoryMappings(final software.amazon.awscdk.core.IResolvable homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }
        /**
         * `AWS::Transfer::User.HomeDirectoryMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
         * @param homeDirectoryMappings `AWS::Transfer::User.HomeDirectoryMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder homeDirectoryMappings(final java.util.List<java.lang.Object> homeDirectoryMappings) {
            this.props.homeDirectoryMappings(homeDirectoryMappings);
            return this;
        }

        /**
         * `AWS::Transfer::User.HomeDirectoryType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
         * @param homeDirectoryType `AWS::Transfer::User.HomeDirectoryType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder homeDirectoryType(final java.lang.String homeDirectoryType) {
            this.props.homeDirectoryType(homeDirectoryType);
            return this;
        }

        /**
         * `AWS::Transfer::User.Policy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
         * @param policy `AWS::Transfer::User.Policy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policy(final java.lang.String policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * `AWS::Transfer::User.SshPublicKeys`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
         * @param sshPublicKeys `AWS::Transfer::User.SshPublicKeys`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sshPublicKeys(final java.util.List<java.lang.String> sshPublicKeys) {
            this.props.sshPublicKeys(sshPublicKeys);
            return this;
        }

        /**
         * `AWS::Transfer::User.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
         * @param tags `AWS::Transfer::User.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnUser}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.transfer.CfnUser build() {
            return new software.amazon.awscdk.services.transfer.CfnUser(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
