package software.amazon.awscdk.services.transfer;

/**
 * Properties for defining a `AWS::Transfer::User`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-19T20:38:06.099Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.transfer.$Module.class, fqn = "@aws-cdk/aws-transfer.CfnUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Transfer::User.Role`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * `AWS::Transfer::User.ServerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerId();

    /**
     * `AWS::Transfer::User.UserName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserName();

    /**
     * `AWS::Transfer::User.HomeDirectory`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectory() {
        return null;
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHomeDirectoryMappings() {
        return null;
    }

    /**
     * `AWS::Transfer::User.HomeDirectoryType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHomeDirectoryType() {
        return null;
    }

    /**
     * `AWS::Transfer::User.Policy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicy() {
        return null;
    }

    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSshPublicKeys() {
        return null;
    }

    /**
     * `AWS::Transfer::User.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProps> {
        private java.lang.String role;
        private java.lang.String serverId;
        private java.lang.String userName;
        private java.lang.String homeDirectory;
        private java.lang.Object homeDirectoryMappings;
        private java.lang.String homeDirectoryType;
        private java.lang.String policy;
        private java.util.List<java.lang.String> sshPublicKeys;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnUserProps#getRole}
         * @param role `AWS::Transfer::User.Role`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getServerId}
         * @param serverId `AWS::Transfer::User.ServerId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getUserName}
         * @param userName `AWS::Transfer::User.UserName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectory}
         * @param homeDirectory `AWS::Transfer::User.HomeDirectory`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectory(java.lang.String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryMappings}
         * @param homeDirectoryMappings `AWS::Transfer::User.HomeDirectoryMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryMappings(software.amazon.awscdk.core.IResolvable homeDirectoryMappings) {
            this.homeDirectoryMappings = homeDirectoryMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryMappings}
         * @param homeDirectoryMappings `AWS::Transfer::User.HomeDirectoryMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryMappings(java.util.List<? extends java.lang.Object> homeDirectoryMappings) {
            this.homeDirectoryMappings = homeDirectoryMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHomeDirectoryType}
         * @param homeDirectoryType `AWS::Transfer::User.HomeDirectoryType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeDirectoryType(java.lang.String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPolicy}
         * @param policy `AWS::Transfer::User.Policy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.String policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getSshPublicKeys}
         * @param sshPublicKeys `AWS::Transfer::User.SshPublicKeys`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshPublicKeys(java.util.List<java.lang.String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getTags}
         * @param tags `AWS::Transfer::User.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProps build() {
            return new Jsii$Proxy(role, serverId, userName, homeDirectory, homeDirectoryMappings, homeDirectoryType, policy, sshPublicKeys, tags);
        }
    }

    /**
     * An implementation for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProps {
        private final java.lang.String role;
        private final java.lang.String serverId;
        private final java.lang.String userName;
        private final java.lang.String homeDirectory;
        private final java.lang.Object homeDirectoryMappings;
        private final java.lang.String homeDirectoryType;
        private final java.lang.String policy;
        private final java.util.List<java.lang.String> sshPublicKeys;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = this.jsiiGet("role", java.lang.String.class);
            this.serverId = this.jsiiGet("serverId", java.lang.String.class);
            this.userName = this.jsiiGet("userName", java.lang.String.class);
            this.homeDirectory = this.jsiiGet("homeDirectory", java.lang.String.class);
            this.homeDirectoryMappings = this.jsiiGet("homeDirectoryMappings", java.lang.Object.class);
            this.homeDirectoryType = this.jsiiGet("homeDirectoryType", java.lang.String.class);
            this.policy = this.jsiiGet("policy", java.lang.String.class);
            this.sshPublicKeys = this.jsiiGet("sshPublicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        private Jsii$Proxy(final java.lang.String role, final java.lang.String serverId, final java.lang.String userName, final java.lang.String homeDirectory, final java.lang.Object homeDirectoryMappings, final java.lang.String homeDirectoryType, final java.lang.String policy, final java.util.List<java.lang.String> sshPublicKeys, final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.serverId = java.util.Objects.requireNonNull(serverId, "serverId is required");
            this.userName = java.util.Objects.requireNonNull(userName, "userName is required");
            this.homeDirectory = homeDirectory;
            this.homeDirectoryMappings = homeDirectoryMappings;
            this.homeDirectoryType = homeDirectoryType;
            this.policy = policy;
            this.sshPublicKeys = sshPublicKeys;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
        }

        @Override
        public java.lang.String getRole() {
            return this.role;
        }

        @Override
        public java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        public java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        public java.lang.String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public java.lang.Object getHomeDirectoryMappings() {
            return this.homeDirectoryMappings;
        }

        @Override
        public java.lang.String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        @Override
        public java.lang.String getPolicy() {
            return this.policy;
        }

        @Override
        public java.util.List<java.lang.String> getSshPublicKeys() {
            return this.sshPublicKeys;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("role", om.valueToTree(this.getRole()));
            data.set("serverId", om.valueToTree(this.getServerId()));
            data.set("userName", om.valueToTree(this.getUserName()));
            if (this.getHomeDirectory() != null) {
                data.set("homeDirectory", om.valueToTree(this.getHomeDirectory()));
            }
            if (this.getHomeDirectoryMappings() != null) {
                data.set("homeDirectoryMappings", om.valueToTree(this.getHomeDirectoryMappings()));
            }
            if (this.getHomeDirectoryType() != null) {
                data.set("homeDirectoryType", om.valueToTree(this.getHomeDirectoryType()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getSshPublicKeys() != null) {
                data.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-transfer.CfnUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProps.Jsii$Proxy that = (CfnUserProps.Jsii$Proxy) o;

            if (!role.equals(that.role)) return false;
            if (!serverId.equals(that.serverId)) return false;
            if (!userName.equals(that.userName)) return false;
            if (this.homeDirectory != null ? !this.homeDirectory.equals(that.homeDirectory) : that.homeDirectory != null) return false;
            if (this.homeDirectoryMappings != null ? !this.homeDirectoryMappings.equals(that.homeDirectoryMappings) : that.homeDirectoryMappings != null) return false;
            if (this.homeDirectoryType != null ? !this.homeDirectoryType.equals(that.homeDirectoryType) : that.homeDirectoryType != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.sshPublicKeys != null ? !this.sshPublicKeys.equals(that.sshPublicKeys) : that.sshPublicKeys != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.serverId.hashCode());
            result = 31 * result + (this.userName.hashCode());
            result = 31 * result + (this.homeDirectory != null ? this.homeDirectory.hashCode() : 0);
            result = 31 * result + (this.homeDirectoryMappings != null ? this.homeDirectoryMappings.hashCode() : 0);
            result = 31 * result + (this.homeDirectoryType != null ? this.homeDirectoryType.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.sshPublicKeys != null ? this.sshPublicKeys.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
