/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.iotsqs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.iot.CfnTopicRule;
import software.amazon.awscdk.services.iot.CfnTopicRuleProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.kms.Key;
import software.amazon.awscdk.services.kms.KeyProps;
import software.amazon.awscdk.services.sqs.DeadLetterQueue;
import software.amazon.awscdk.services.sqs.Queue;
import software.amazon.awscdk.services.sqs.QueueProps;
import software.amazon.awsconstructs.services.iotsqs.;
import software.amazon.awsconstructs.services.iotsqs.IotToSqsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/aws-iot-sqs.IotToSqs")
public class IotToSqs
extends Construct {
    protected IotToSqs(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IotToSqs(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public IotToSqs(@NotNull Construct scope, @NotNull String id, @NotNull IotToSqsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Role getIotActionsRole() {
        return (Role)Kernel.get((Object)((Object)this), (String)"iotActionsRole", (NativeType)NativeType.forClass(Role.class));
    }

    @NotNull
    public CfnTopicRule getIotTopicRule() {
        return (CfnTopicRule)Kernel.get((Object)((Object)this), (String)"iotTopicRule", (NativeType)NativeType.forClass(CfnTopicRule.class));
    }

    @NotNull
    public Queue getSqsQueue() {
        return (Queue)Kernel.get((Object)((Object)this), (String)"sqsQueue", (NativeType)NativeType.forClass(Queue.class));
    }

    @Nullable
    public DeadLetterQueue getDeadLetterQueue() {
        return (DeadLetterQueue)Kernel.get((Object)((Object)this), (String)"deadLetterQueue", (NativeType)NativeType.forClass(DeadLetterQueue.class));
    }

    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)((Object)this), (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<IotToSqs> {
        private final Construct scope;
        private final String id;
        private final IotToSqsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new IotToSqsProps.Builder();
        }

        public Builder iotTopicRuleProps(CfnTopicRuleProps iotTopicRuleProps) {
            this.props.iotTopicRuleProps(iotTopicRuleProps);
            return this;
        }

        public Builder deadLetterQueueProps(QueueProps deadLetterQueueProps) {
            this.props.deadLetterQueueProps(deadLetterQueueProps);
            return this;
        }

        public Builder deployDeadLetterQueue(Boolean deployDeadLetterQueue) {
            this.props.deployDeadLetterQueue(deployDeadLetterQueue);
            return this;
        }

        public Builder enableEncryptionWithCustomerManagedKey(Boolean enableEncryptionWithCustomerManagedKey) {
            this.props.enableEncryptionWithCustomerManagedKey(enableEncryptionWithCustomerManagedKey);
            return this;
        }

        public Builder encryptionKey(Key encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder encryptionKeyProps(KeyProps encryptionKeyProps) {
            this.props.encryptionKeyProps(encryptionKeyProps);
            return this;
        }

        public Builder existingQueueObj(Queue existingQueueObj) {
            this.props.existingQueueObj(existingQueueObj);
            return this;
        }

        public Builder maxReceiveCount(Number maxReceiveCount) {
            this.props.maxReceiveCount(maxReceiveCount);
            return this;
        }

        public Builder queueProps(QueueProps queueProps) {
            this.props.queueProps(queueProps);
            return this;
        }

        public IotToSqs build() {
            return new IotToSqs(this.scope, this.id, this.props.build());
        }
    }
}

