/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retroactively applies an archive rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyArchiveRuleRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<ApplyArchiveRuleRequest.Builder, ApplyArchiveRuleRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerArn").getter(getter(ApplyArchiveRuleRequest::analyzerArn)).setter(setter(Builder::analyzerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ApplyArchiveRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(ApplyArchiveRuleRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD,
            CLIENT_TOKEN_FIELD, RULE_NAME_FIELD));

    private final String analyzerArn;

    private final String clientToken;

    private final String ruleName;

    private ApplyArchiveRuleRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.clientToken = builder.clientToken;
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the analyzer.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the analyzer.
     */
    public String analyzerArn() {
        return analyzerArn;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the rule to apply.
     * </p>
     * 
     * @return The name of the rule to apply.
     */
    public String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyArchiveRuleRequest)) {
            return false;
        }
        ApplyArchiveRuleRequest other = (ApplyArchiveRuleRequest) obj;
        return Objects.equals(analyzerArn(), other.analyzerArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(ruleName(), other.ruleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplyArchiveRuleRequest").add("AnalyzerArn", analyzerArn()).add("ClientToken", clientToken())
                .add("RuleName", ruleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerArn":
            return Optional.ofNullable(clazz.cast(analyzerArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyArchiveRuleRequest, T> g) {
        return obj -> g.apply((ApplyArchiveRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ApplyArchiveRuleRequest> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the analyzer.
         * </p>
         * 
         * @param analyzerArn
         *        The Amazon resource name (ARN) of the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerArn(String analyzerArn);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the rule to apply.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerArn;

        private String clientToken;

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyArchiveRuleRequest model) {
            super(model);
            analyzerArn(model.analyzerArn);
            clientToken(model.clientToken);
            ruleName(model.ruleName);
        }

        public final String getAnalyzerArn() {
            return analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyArchiveRuleRequest build() {
            return new ApplyArchiveRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
