/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListFindingsResponse.Builder, ListFindingsResponse> {
    private static final SdkField<List<FindingSummary>> FINDINGS_FIELD = SdkField
            .<List<FindingSummary>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(ListFindingsResponse::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FindingSummary> findings;

    private final String nextToken;

    private ListFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Findings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
     */
    public List<FindingSummary> findings() {
        return findings;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsResponse)) {
            return false;
        }
        ListFindingsResponse other = (ListFindingsResponse) obj;
        return hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFindingsResponse").add("Findings", hasFindings() ? findings() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsResponse, T> g) {
        return obj -> g.apply((ListFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsResponse> {
        /**
         * <p>
         * A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
         * </p>
         * 
         * @param findings
         *        A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<FindingSummary> findings);

        /**
         * <p>
         * A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
         * </p>
         * 
         * @param findings
         *        A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(FindingSummary... findings);

        /**
         * <p>
         * A list of findings retrieved from the analyzer that match the filter criteria specified, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FindingSummary>.Builder} avoiding the need
         * to create one manually via {@link List<FindingSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #findings(List<FindingSummary>)}.
         * 
         * @param findings
         *        a consumer that will call methods on {@link List<FindingSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(List<FindingSummary>)
         */
        Builder findings(Consumer<FindingSummary.Builder>... findings);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private List<FindingSummary> findings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsResponse model) {
            super(model);
            findings(model.findings);
            nextToken(model.nextToken);
        }

        public final Collection<FindingSummary.Builder> getFindings() {
            if (findings instanceof SdkAutoConstructList) {
                return null;
            }
            return findings != null ? findings.stream().map(FindingSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<FindingSummary> findings) {
            this.findings = FindingsListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(FindingSummary... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<FindingSummary.Builder>... findings) {
            findings(Stream.of(findings).map(c -> FindingSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<FindingSummary.BuilderImpl> findings) {
            this.findings = FindingsListCopier.copyFromBuilder(findings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsResponse build() {
            return new ListFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
