/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates findings with the new values provided in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFindingsRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<UpdateFindingsRequest.Builder, UpdateFindingsRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerArn").getter(getter(UpdateFindingsRequest::analyzerArn)).setter(setter(Builder::analyzerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateFindingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ids")
            .getter(getter(UpdateFindingsRequest::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(UpdateFindingsRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateFindingsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD,
            CLIENT_TOKEN_FIELD, IDS_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD));

    private final String analyzerArn;

    private final String clientToken;

    private final List<String> ids;

    private final String resourceArn;

    private final String status;

    private UpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.clientToken = builder.clientToken;
        this.ids = builder.ids;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the analyzer that generated the findings to update.
     * </p>
     * 
     * @return The ARN of the analyzer that generated the findings to update.
     */
    public final String analyzerArn() {
        return analyzerArn;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Ids property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the findings to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the findings to update.
     */
    public final List<String> ids() {
        return ids;
    }

    /**
     * <p>
     * The ARN of the resource identified in the finding.
     * </p>
     * 
     * @return The ARN of the resource identified in the finding.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an
     * Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active
     * finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatusUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change
     *         an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an
     *         Active finding.
     * @see FindingStatusUpdate
     */
    public final FindingStatusUpdate status() {
        return FindingStatusUpdate.fromValue(status);
    }

    /**
     * <p>
     * The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an
     * Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active
     * finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatusUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change
     *         an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an
     *         Active finding.
     * @see FindingStatusUpdate
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsRequest)) {
            return false;
        }
        UpdateFindingsRequest other = (UpdateFindingsRequest) obj;
        return Objects.equals(analyzerArn(), other.analyzerArn()) && Objects.equals(clientToken(), other.clientToken())
                && hasIds() == other.hasIds() && Objects.equals(ids(), other.ids())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFindingsRequest").add("AnalyzerArn", analyzerArn()).add("ClientToken", clientToken())
                .add("Ids", hasIds() ? ids() : null).add("ResourceArn", resourceArn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerArn":
            return Optional.ofNullable(clazz.cast(analyzerArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsRequest, T> g) {
        return obj -> g.apply((UpdateFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFindingsRequest> {
        /**
         * <p>
         * The ARN of the analyzer that generated the findings to update.
         * </p>
         * 
         * @param analyzerArn
         *        The ARN of the analyzer that generated the findings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerArn(String analyzerArn);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IDs of the findings to update.
         * </p>
         * 
         * @param ids
         *        The IDs of the findings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * The IDs of the findings to update.
         * </p>
         * 
         * @param ids
         *        The IDs of the findings to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * The ARN of the resource identified in the finding.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource identified in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an
         * Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active
         * finding.
         * </p>
         * 
         * @param status
         *        The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to
         *        change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding
         *        to an Active finding.
         * @see FindingStatusUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatusUpdate
         */
        Builder status(String status);

        /**
         * <p>
         * The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an
         * Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active
         * finding.
         * </p>
         * 
         * @param status
         *        The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to
         *        change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding
         *        to an Active finding.
         * @see FindingStatusUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatusUpdate
         */
        Builder status(FindingStatusUpdate status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerArn;

        private String clientToken;

        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private String resourceArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsRequest model) {
            super(model);
            analyzerArn(model.analyzerArn);
            clientToken(model.clientToken);
            ids(model.ids);
            resourceArn(model.resourceArn);
            status(model.status);
        }

        public final String getAnalyzerArn() {
            return analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = FindingIdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = FindingIdListCopier.copy(ids);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatusUpdate status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsRequest build() {
            return new UpdateFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
