/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A location in a policy that is represented as a path through the JSON representation and a corresponding span.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Location implements SdkPojo, Serializable, ToCopyableBuilder<Location.Builder, Location> {
    private static final SdkField<List<PathElement>> PATH_FIELD = SdkField
            .<List<PathElement>> builder(MarshallingType.LIST)
            .memberName("path")
            .getter(getter(Location::path))
            .setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PathElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Span> SPAN_FIELD = SdkField.<Span> builder(MarshallingType.SDK_POJO).memberName("span")
            .getter(getter(Location::span)).setter(setter(Builder::span)).constructor(Span::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("span").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SPAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PathElement> path;

    private final Span span;

    private Location(BuilderImpl builder) {
        this.path = builder.path;
        this.span = builder.span;
    }

    /**
     * Returns true if the Path property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPath() {
        return path != null && !(path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A path in a policy, represented as a sequence of path elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPath()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A path in a policy, represented as a sequence of path elements.
     */
    public final List<PathElement> path() {
        return path;
    }

    /**
     * <p>
     * A span in a policy.
     * </p>
     * 
     * @return A span in a policy.
     */
    public final Span span() {
        return span;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPath() ? path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(span());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location) obj;
        return hasPath() == other.hasPath() && Objects.equals(path(), other.path()) && Objects.equals(span(), other.span());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Location").add("Path", hasPath() ? path() : null).add("Span", span()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "span":
            return Optional.ofNullable(clazz.cast(span()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Location> {
        /**
         * <p>
         * A path in a policy, represented as a sequence of path elements.
         * </p>
         * 
         * @param path
         *        A path in a policy, represented as a sequence of path elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(Collection<PathElement> path);

        /**
         * <p>
         * A path in a policy, represented as a sequence of path elements.
         * </p>
         * 
         * @param path
         *        A path in a policy, represented as a sequence of path elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(PathElement... path);

        /**
         * <p>
         * A path in a policy, represented as a sequence of path elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PathElement>.Builder} avoiding the need to
         * create one manually via {@link List<PathElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PathElement>.Builder#build()} is called immediately and its
         * result is passed to {@link #path(List<PathElement>)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link List<PathElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(List<PathElement>)
         */
        Builder path(Consumer<PathElement.Builder>... path);

        /**
         * <p>
         * A span in a policy.
         * </p>
         * 
         * @param span
         *        A span in a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder span(Span span);

        /**
         * <p>
         * A span in a policy.
         * </p>
         * This is a convenience that creates an instance of the {@link Span.Builder} avoiding the need to create one
         * manually via {@link Span#builder()}.
         *
         * When the {@link Consumer} completes, {@link Span.Builder#build()} is called immediately and its result is
         * passed to {@link #span(Span)}.
         * 
         * @param span
         *        a consumer that will call methods on {@link Span.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #span(Span)
         */
        default Builder span(Consumer<Span.Builder> span) {
            return span(Span.builder().applyMutation(span).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<PathElement> path = DefaultSdkAutoConstructList.getInstance();

        private Span span;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            path(model.path);
            span(model.span);
        }

        public final List<PathElement.Builder> getPath() {
            List<PathElement.Builder> result = PathElementListCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder path(Collection<PathElement> path) {
            this.path = PathElementListCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(PathElement... path) {
            path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<PathElement.Builder>... path) {
            path(Stream.of(path).map(c -> PathElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPath(Collection<PathElement.BuilderImpl> path) {
            this.path = PathElementListCopier.copyFromBuilder(path);
        }

        public final Span.Builder getSpan() {
            return span != null ? span.toBuilder() : null;
        }

        @Override
        public final Builder span(Span span) {
            this.span = span;
            return this;
        }

        public final void setSpan(Span.BuilderImpl span) {
            this.span = span != null ? span.build() : null;
        }

        @Override
        public Location build() {
            return new Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
