/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPreviewRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CreateAccessPreviewRequest.Builder, CreateAccessPreviewRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerArn").getter(getter(CreateAccessPreviewRequest::analyzerArn))
            .setter(setter(Builder::analyzerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAccessPreviewRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, Configuration>> CONFIGURATIONS_FIELD = SdkField
            .<Map<String, Configuration>> builder(MarshallingType.MAP)
            .memberName("configurations")
            .getter(getter(CreateAccessPreviewRequest::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD,
            CLIENT_TOKEN_FIELD, CONFIGURATIONS_FIELD));

    private final String analyzerArn;

    private final String clientToken;

    private final Map<String, Configuration> configurations;

    private CreateAccessPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.clientToken = builder.clientToken;
        this.configurations = builder.configurations;
    }

    /**
     * <p>
     * The <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN
     * of the account analyzer</a> used to generate the access preview. You can only create an access preview for
     * analyzers with an <code>Account</code> type and <code>Active</code> status.
     * </p>
     * 
     * @return The <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources"
     *         >ARN of the account analyzer</a> used to generate the access preview. You can only create an access
     *         preview for analyzers with an <code>Account</code> type and <code>Active</code> status.
     */
    public final String analyzerArn() {
        return analyzerArn;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Configurations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Access control configuration for your resource that is used to generate the access preview. The access preview
     * includes findings for external access allowed to the resource with the proposed access control configuration. The
     * configuration must contain exactly one element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Access control configuration for your resource that is used to generate the access preview. The access
     *         preview includes findings for external access allowed to the resource with the proposed access control
     *         configuration. The configuration must contain exactly one element.
     */
    public final Map<String, Configuration> configurations() {
        return configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPreviewRequest)) {
            return false;
        }
        CreateAccessPreviewRequest other = (CreateAccessPreviewRequest) obj;
        return Objects.equals(analyzerArn(), other.analyzerArn()) && Objects.equals(clientToken(), other.clientToken())
                && hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPreviewRequest").add("AnalyzerArn", analyzerArn()).add("ClientToken", clientToken())
                .add("Configurations", hasConfigurations() ? configurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerArn":
            return Optional.ofNullable(clazz.cast(analyzerArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPreviewRequest, T> g) {
        return obj -> g.apply((CreateAccessPreviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPreviewRequest> {
        /**
         * <p>
         * The <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources"
         * >ARN of the account analyzer</a> used to generate the access preview. You can only create an access preview
         * for analyzers with an <code>Account</code> type and <code>Active</code> status.
         * </p>
         * 
         * @param analyzerArn
         *        The <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources"
         *        >ARN of the account analyzer</a> used to generate the access preview. You can only create an access
         *        preview for analyzers with an <code>Account</code> type and <code>Active</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerArn(String analyzerArn);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Access control configuration for your resource that is used to generate the access preview. The access
         * preview includes findings for external access allowed to the resource with the proposed access control
         * configuration. The configuration must contain exactly one element.
         * </p>
         * 
         * @param configurations
         *        Access control configuration for your resource that is used to generate the access preview. The access
         *        preview includes findings for external access allowed to the resource with the proposed access control
         *        configuration. The configuration must contain exactly one element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Map<String, Configuration> configurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerArn;

        private String clientToken;

        private Map<String, Configuration> configurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPreviewRequest model) {
            super(model);
            analyzerArn(model.analyzerArn);
            clientToken(model.clientToken);
            configurations(model.configurations);
        }

        public final String getAnalyzerArn() {
            return analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Map<String, Configuration.Builder> getConfigurations() {
            Map<String, Configuration.Builder> result = ConfigurationsMapCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurations(Map<String, Configuration> configurations) {
            this.configurations = ConfigurationsMapCopier.copy(configurations);
            return this;
        }

        public final void setConfigurations(Map<String, Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationsMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPreviewRequest build() {
            return new CreateAccessPreviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
