/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Secrets Manager secret. For more information, see <a
 * href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret</a>.
 * </p>
 * <p>
 * You can propose a configuration for a new secret or an existing secret that you own by specifying the secret policy
 * and optional KMS encryption key. If the configuration is for an existing secret and you do not specify the secret
 * policy, the access preview uses the existing policy for the secret. If the access preview is for a new resource and
 * you do not specify the policy, the access preview assumes a secret without a policy. To propose deletion of an
 * existing policy, you can specify an empty string. If the proposed configuration is for a new secret and you do not
 * specify the KMS key ID, the access preview uses the default CMK of the AWS account. If you specify an empty string
 * for the KMS key ID, the access preview uses the default CMK of the AWS account. For more information about secret
 * policy limits, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html">Quotas
 * for AWS Secrets Manager.</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecretsManagerSecretConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SecretsManagerSecretConfiguration.Builder, SecretsManagerSecretConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(SecretsManagerSecretConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> SECRET_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretPolicy").getter(getter(SecretsManagerSecretConfiguration::secretPolicy))
            .setter(setter(Builder::secretPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            SECRET_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String secretPolicy;

    private SecretsManagerSecretConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.secretPolicy = builder.secretPolicy;
    }

    /**
     * <p>
     * The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).
     * </p>
     * 
     * @return The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The proposed resource policy defining who can access or manage the secret.
     * </p>
     * 
     * @return The proposed resource policy defining who can access or manage the secret.
     */
    public final String secretPolicy() {
        return secretPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerSecretConfiguration)) {
            return false;
        }
        SecretsManagerSecretConfiguration other = (SecretsManagerSecretConfiguration) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(secretPolicy(), other.secretPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecretsManagerSecretConfiguration").add("KmsKeyId", kmsKeyId())
                .add("SecretPolicy", secretPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "secretPolicy":
            return Optional.ofNullable(clazz.cast(secretPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerSecretConfiguration, T> g) {
        return obj -> g.apply((SecretsManagerSecretConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecretsManagerSecretConfiguration> {
        /**
         * <p>
         * The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).
         * </p>
         * 
         * @param kmsKeyId
         *        The proposed ARN, key ID, or alias of the AWS KMS customer master key (CMK).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The proposed resource policy defining who can access or manage the secret.
         * </p>
         * 
         * @param secretPolicy
         *        The proposed resource policy defining who can access or manage the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretPolicy(String secretPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String secretPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerSecretConfiguration model) {
            kmsKeyId(model.kmsKeyId);
            secretPolicy(model.secretPolicy);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getSecretPolicy() {
            return secretPolicy;
        }

        @Override
        public final Builder secretPolicy(String secretPolicy) {
            this.secretPolicy = secretPolicy;
            return this;
        }

        public final void setSecretPolicy(String secretPolicy) {
            this.secretPolicy = secretPolicy;
        }

        @Override
        public SecretsManagerSecretConfiguration build() {
            return new SecretsManagerSecretConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
