/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the CloudTrail trail being analyzed to generate a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trail implements SdkPojo, Serializable, ToCopyableBuilder<Trail.Builder, Trail> {
    private static final SdkField<Boolean> ALL_REGIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allRegions").getter(getter(Trail::allRegions)).setter(setter(Builder::allRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allRegions").build()).build();

    private static final SdkField<String> CLOUD_TRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudTrailArn").getter(getter(Trail::cloudTrailArn)).setter(setter(Builder::cloudTrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailArn").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(Trail::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_REGIONS_FIELD,
            CLOUD_TRAIL_ARN_FIELD, REGIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allRegions;

    private final String cloudTrailArn;

    private final List<String> regions;

    private Trail(BuilderImpl builder) {
        this.allRegions = builder.allRegions;
        this.cloudTrailArn = builder.cloudTrailArn;
        this.regions = builder.regions;
    }

    /**
     * <p>
     * Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access Analyzer
     * retrieves CloudTrail data from all regions to analyze and generate a policy.
     * </p>
     * 
     * @return Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access Analyzer
     *         retrieves CloudTrail data from all regions to analyze and generate a policy.
     */
    public final Boolean allRegions() {
        return allRegions;
    }

    /**
     * <p>
     * Specifies the ARN of the trail. The format of a trail ARN is
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.
     * </p>
     * 
     * @return Specifies the ARN of the trail. The format of a trail ARN is
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.
     */
    public final String cloudTrailArn() {
        return cloudTrailArn;
    }

    /**
     * Returns true if the Regions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regions to get CloudTrail data from and analyze to generate a policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of regions to get CloudTrail data from and analyze to generate a policy.
     */
    public final List<String> regions() {
        return regions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allRegions());
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trail)) {
            return false;
        }
        Trail other = (Trail) obj;
        return Objects.equals(allRegions(), other.allRegions()) && Objects.equals(cloudTrailArn(), other.cloudTrailArn())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Trail").add("AllRegions", allRegions()).add("CloudTrailArn", cloudTrailArn())
                .add("Regions", hasRegions() ? regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allRegions":
            return Optional.ofNullable(clazz.cast(allRegions()));
        case "cloudTrailArn":
            return Optional.ofNullable(clazz.cast(cloudTrailArn()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trail, T> g) {
        return obj -> g.apply((Trail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trail> {
        /**
         * <p>
         * Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access Analyzer
         * retrieves CloudTrail data from all regions to analyze and generate a policy.
         * </p>
         * 
         * @param allRegions
         *        Possible values are <code>true</code> or <code>false</code>. If set to <code>true</code>, Access
         *        Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allRegions(Boolean allRegions);

        /**
         * <p>
         * Specifies the ARN of the trail. The format of a trail ARN is
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.
         * </p>
         * 
         * @param cloudTrailArn
         *        Specifies the ARN of the trail. The format of a trail ARN is
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrailArn(String cloudTrailArn);

        /**
         * <p>
         * A list of regions to get CloudTrail data from and analyze to generate a policy.
         * </p>
         * 
         * @param regions
         *        A list of regions to get CloudTrail data from and analyze to generate a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * A list of regions to get CloudTrail data from and analyze to generate a policy.
         * </p>
         * 
         * @param regions
         *        A list of regions to get CloudTrail data from and analyze to generate a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allRegions;

        private String cloudTrailArn;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Trail model) {
            allRegions(model.allRegions);
            cloudTrailArn(model.cloudTrailArn);
            regions(model.regions);
        }

        public final Boolean getAllRegions() {
            return allRegions;
        }

        @Override
        public final Builder allRegions(Boolean allRegions) {
            this.allRegions = allRegions;
            return this;
        }

        public final void setAllRegions(Boolean allRegions) {
            this.allRegions = allRegions;
        }

        public final String getCloudTrailArn() {
            return cloudTrailArn;
        }

        @Override
        public final Builder cloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
            return this;
        }

        public final void setCloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public Trail build() {
            return new Trail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
