/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyGenerationsResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListPolicyGenerationsResponse.Builder, ListPolicyGenerationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPolicyGenerationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PolicyGeneration>> POLICY_GENERATIONS_FIELD = SdkField
            .<List<PolicyGeneration>> builder(MarshallingType.LIST)
            .memberName("policyGenerations")
            .getter(getter(ListPolicyGenerationsResponse::policyGenerations))
            .setter(setter(Builder::policyGenerations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyGeneration> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyGeneration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            POLICY_GENERATIONS_FIELD));

    private final String nextToken;

    private final List<PolicyGeneration> policyGenerations;

    private ListPolicyGenerationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policyGenerations = builder.policyGenerations;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PolicyGenerations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPolicyGenerations() {
        return policyGenerations != null && !(policyGenerations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>PolicyGeneration</code> object that contains details about the generated policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyGenerations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A <code>PolicyGeneration</code> object that contains details about the generated policy.
     */
    public final List<PolicyGeneration> policyGenerations() {
        return policyGenerations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyGenerations() ? policyGenerations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGenerationsResponse)) {
            return false;
        }
        ListPolicyGenerationsResponse other = (ListPolicyGenerationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPolicyGenerations() == other.hasPolicyGenerations()
                && Objects.equals(policyGenerations(), other.policyGenerations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyGenerationsResponse").add("NextToken", nextToken())
                .add("PolicyGenerations", hasPolicyGenerations() ? policyGenerations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "policyGenerations":
            return Optional.ofNullable(clazz.cast(policyGenerations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGenerationsResponse, T> g) {
        return obj -> g.apply((ListPolicyGenerationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPolicyGenerationsResponse> {
        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A <code>PolicyGeneration</code> object that contains details about the generated policy.
         * </p>
         * 
         * @param policyGenerations
         *        A <code>PolicyGeneration</code> object that contains details about the generated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyGenerations(Collection<PolicyGeneration> policyGenerations);

        /**
         * <p>
         * A <code>PolicyGeneration</code> object that contains details about the generated policy.
         * </p>
         * 
         * @param policyGenerations
         *        A <code>PolicyGeneration</code> object that contains details about the generated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyGenerations(PolicyGeneration... policyGenerations);

        /**
         * <p>
         * A <code>PolicyGeneration</code> object that contains details about the generated policy.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyGeneration>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyGeneration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyGeneration>.Builder#build()} is called immediately and
         * its result is passed to {@link #policyGenerations(List<PolicyGeneration>)}.
         * 
         * @param policyGenerations
         *        a consumer that will call methods on {@link List<PolicyGeneration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyGenerations(List<PolicyGeneration>)
         */
        Builder policyGenerations(Consumer<PolicyGeneration.Builder>... policyGenerations);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PolicyGeneration> policyGenerations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGenerationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            policyGenerations(model.policyGenerations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<PolicyGeneration.Builder> getPolicyGenerations() {
            List<PolicyGeneration.Builder> result = PolicyGenerationListCopier.copyToBuilder(this.policyGenerations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policyGenerations(Collection<PolicyGeneration> policyGenerations) {
            this.policyGenerations = PolicyGenerationListCopier.copy(policyGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerations(PolicyGeneration... policyGenerations) {
            policyGenerations(Arrays.asList(policyGenerations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerations(Consumer<PolicyGeneration.Builder>... policyGenerations) {
            policyGenerations(Stream.of(policyGenerations).map(c -> PolicyGeneration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyGenerations(Collection<PolicyGeneration.BuilderImpl> policyGenerations) {
            this.policyGenerations = PolicyGenerationListCopier.copyFromBuilder(policyGenerations);
        }

        @Override
        public ListPolicyGenerationsResponse build() {
            return new ListPolicyGenerationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
