/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessPreviewResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetAccessPreviewResponse.Builder, GetAccessPreviewResponse> {
    private static final SdkField<AccessPreview> ACCESS_PREVIEW_FIELD = SdkField
            .<AccessPreview> builder(MarshallingType.SDK_POJO).memberName("accessPreview")
            .getter(getter(GetAccessPreviewResponse::accessPreview)).setter(setter(Builder::accessPreview))
            .constructor(AccessPreview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPreview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_PREVIEW_FIELD));

    private final AccessPreview accessPreview;

    private GetAccessPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.accessPreview = builder.accessPreview;
    }

    /**
     * <p>
     * An object that contains information about the access preview.
     * </p>
     * 
     * @return An object that contains information about the access preview.
     */
    public final AccessPreview accessPreview() {
        return accessPreview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPreview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPreviewResponse)) {
            return false;
        }
        GetAccessPreviewResponse other = (GetAccessPreviewResponse) obj;
        return Objects.equals(accessPreview(), other.accessPreview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessPreviewResponse").add("AccessPreview", accessPreview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPreview":
            return Optional.ofNullable(clazz.cast(accessPreview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPreviewResponse, T> g) {
        return obj -> g.apply((GetAccessPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessPreviewResponse> {
        /**
         * <p>
         * An object that contains information about the access preview.
         * </p>
         * 
         * @param accessPreview
         *        An object that contains information about the access preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPreview(AccessPreview accessPreview);

        /**
         * <p>
         * An object that contains information about the access preview.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessPreview.Builder} avoiding the need to
         * create one manually via {@link AccessPreview#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessPreview.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPreview(AccessPreview)}.
         * 
         * @param accessPreview
         *        a consumer that will call methods on {@link AccessPreview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPreview(AccessPreview)
         */
        default Builder accessPreview(Consumer<AccessPreview.Builder> accessPreview) {
            return accessPreview(AccessPreview.builder().applyMutation(accessPreview).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private AccessPreview accessPreview;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPreviewResponse model) {
            super(model);
            accessPreview(model.accessPreview);
        }

        public final AccessPreview.Builder getAccessPreview() {
            return accessPreview != null ? accessPreview.toBuilder() : null;
        }

        @Override
        public final Builder accessPreview(AccessPreview accessPreview) {
            this.accessPreview = accessPreview;
            return this;
        }

        public final void setAccessPreview(AccessPreview.BuilderImpl accessPreview) {
            this.accessPreview = accessPreview != null ? accessPreview.build() : null;
        }

        @Override
        public GetAccessPreviewResponse build() {
            return new GetAccessPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
