/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a substring of a literal string in a JSON document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Substring implements SdkPojo, Serializable, ToCopyableBuilder<Substring.Builder, Substring> {
    private static final SdkField<Integer> LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("length").getter(getter(Substring::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final SdkField<Integer> START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("start")
            .getter(getter(Substring::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENGTH_FIELD, START_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer length;

    private final Integer start;

    private Substring(BuilderImpl builder) {
        this.length = builder.length;
        this.start = builder.start;
    }

    /**
     * <p>
     * The length of the substring.
     * </p>
     * 
     * @return The length of the substring.
     */
    public final Integer length() {
        return length;
    }

    /**
     * <p>
     * The start index of the substring, starting from 0.
     * </p>
     * 
     * @return The start index of the substring, starting from 0.
     */
    public final Integer start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Substring)) {
            return false;
        }
        Substring other = (Substring) obj;
        return Objects.equals(length(), other.length()) && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Substring").add("Length", length()).add("Start", start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Substring, T> g) {
        return obj -> g.apply((Substring) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Substring> {
        /**
         * <p>
         * The length of the substring.
         * </p>
         * 
         * @param length
         *        The length of the substring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Integer length);

        /**
         * <p>
         * The start index of the substring, starting from 0.
         * </p>
         * 
         * @param start
         *        The start index of the substring, starting from 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Integer start);
    }

    static final class BuilderImpl implements Builder {
        private Integer length;

        private Integer start;

        private BuilderImpl() {
        }

        private BuilderImpl(Substring model) {
            length(model.length);
            start(model.start);
        }

        public final Integer getLength() {
            return length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        public final Integer getStart() {
            return start;
        }

        @Override
        public final Builder start(Integer start) {
            this.start = start;
            return this;
        }

        public final void setStart(Integer start) {
            this.start = start;
        }

        @Override
        public Substring build() {
            return new Substring(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
