/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of information about an access preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPreviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPreviewSummary.Builder, AccessPreviewSummary> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerArn").getter(getter(AccessPreviewSummary::analyzerArn)).setter(setter(Builder::analyzerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AccessPreviewSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AccessPreviewSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AccessPreviewSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<AccessPreviewStatusReason> STATUS_REASON_FIELD = SdkField
            .<AccessPreviewStatusReason> builder(MarshallingType.SDK_POJO).memberName("statusReason")
            .getter(getter(AccessPreviewSummary::statusReason)).setter(setter(Builder::statusReason))
            .constructor(AccessPreviewStatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD,
            CREATED_AT_FIELD, ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String analyzerArn;

    private final Instant createdAt;

    private final String id;

    private final String status;

    private final AccessPreviewStatusReason statusReason;

    private AccessPreviewSummary(BuilderImpl builder) {
        this.analyzerArn = builder.analyzerArn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The ARN of the analyzer used to generate the access preview.
     * </p>
     * 
     * @return The ARN of the analyzer used to generate the access preview.
     */
    public final String analyzerArn() {
        return analyzerArn;
    }

    /**
     * <p>
     * The time at which the access preview was created.
     * </p>
     * 
     * @return The time at which the access preview was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The unique ID for the access preview.
     * </p>
     * 
     * @return The unique ID for the access preview.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the access preview.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - The access preview creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - The access preview is complete and previews the findings for external access to the
     * resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The access preview creation has failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the access preview.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code> - The access preview creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The access preview is complete and previews the findings for external access to
     *         the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The access preview creation has failed.
     *         </p>
     *         </li>
     * @see AccessPreviewStatus
     */
    public final AccessPreviewStatus status() {
        return AccessPreviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the access preview.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code> - The access preview creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Completed</code> - The access preview is complete and previews the findings for external access to the
     * resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The access preview creation has failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the access preview.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code> - The access preview creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Completed</code> - The access preview is complete and previews the findings for external access to
     *         the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The access preview creation has failed.
     *         </p>
     *         </li>
     * @see AccessPreviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusReason property for this object.
     * 
     * @return The value of the StatusReason property for this object.
     */
    public final AccessPreviewStatusReason statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreviewSummary)) {
            return false;
        }
        AccessPreviewSummary other = (AccessPreviewSummary) obj;
        return Objects.equals(analyzerArn(), other.analyzerArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPreviewSummary").add("AnalyzerArn", analyzerArn()).add("CreatedAt", createdAt())
                .add("Id", id()).add("Status", statusAsString()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerArn":
            return Optional.ofNullable(clazz.cast(analyzerArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPreviewSummary, T> g) {
        return obj -> g.apply((AccessPreviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPreviewSummary> {
        /**
         * <p>
         * The ARN of the analyzer used to generate the access preview.
         * </p>
         * 
         * @param analyzerArn
         *        The ARN of the analyzer used to generate the access preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerArn(String analyzerArn);

        /**
         * <p>
         * The time at which the access preview was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the access preview was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The unique ID for the access preview.
         * </p>
         * 
         * @param id
         *        The unique ID for the access preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the access preview.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code> - The access preview creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - The access preview is complete and previews the findings for external access to the
         * resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The access preview creation has failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the access preview.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code> - The access preview creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The access preview is complete and previews the findings for external access
         *        to the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The access preview creation has failed.
         *        </p>
         *        </li>
         * @see AccessPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPreviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the access preview.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code> - The access preview creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Completed</code> - The access preview is complete and previews the findings for external access to the
         * resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The access preview creation has failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the access preview.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code> - The access preview creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Completed</code> - The access preview is complete and previews the findings for external access
         *        to the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The access preview creation has failed.
         *        </p>
         *        </li>
         * @see AccessPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPreviewStatus
         */
        Builder status(AccessPreviewStatus status);

        /**
         * Sets the value of the StatusReason property for this object.
         *
         * @param statusReason
         *        The new value for the StatusReason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(AccessPreviewStatusReason statusReason);

        /**
         * Sets the value of the StatusReason property for this object.
         *
         * This is a convenience that creates an instance of the {@link AccessPreviewStatusReason.Builder} avoiding the
         * need to create one manually via {@link AccessPreviewStatusReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessPreviewStatusReason.Builder#build()} is called immediately
         * and its result is passed to {@link #statusReason(AccessPreviewStatusReason)}.
         * 
         * @param statusReason
         *        a consumer that will call methods on {@link AccessPreviewStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReason(AccessPreviewStatusReason)
         */
        default Builder statusReason(Consumer<AccessPreviewStatusReason.Builder> statusReason) {
            return statusReason(AccessPreviewStatusReason.builder().applyMutation(statusReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String analyzerArn;

        private Instant createdAt;

        private String id;

        private String status;

        private AccessPreviewStatusReason statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreviewSummary model) {
            analyzerArn(model.analyzerArn);
            createdAt(model.createdAt);
            id(model.id);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getAnalyzerArn() {
            return analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccessPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final AccessPreviewStatusReason.Builder getStatusReason() {
            return statusReason != null ? statusReason.toBuilder() : null;
        }

        @Override
        public final Builder statusReason(AccessPreviewStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(AccessPreviewStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public AccessPreviewSummary build() {
            return new AccessPreviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
