/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An access preview finding generated by the access preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPreviewFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPreviewFinding.Builder, AccessPreviewFinding> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(AccessPreviewFinding::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeType").getter(getter(AccessPreviewFinding::changeTypeAsString))
            .setter(setter(Builder::changeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()).build();

    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("condition")
            .getter(getter(AccessPreviewFinding::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AccessPreviewFinding::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(AccessPreviewFinding::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> EXISTING_FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingFindingId").getter(getter(AccessPreviewFinding::existingFindingId))
            .setter(setter(Builder::existingFindingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingFindingId").build()).build();

    private static final SdkField<String> EXISTING_FINDING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingFindingStatus").getter(getter(AccessPreviewFinding::existingFindingStatusAsString))
            .setter(setter(Builder::existingFindingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingFindingStatus").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AccessPreviewFinding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPublic").getter(getter(AccessPreviewFinding::isPublic)).setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("principal")
            .getter(getter(AccessPreviewFinding::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(AccessPreviewFinding::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwnerAccount").getter(getter(AccessPreviewFinding::resourceOwnerAccount))
            .setter(setter(Builder::resourceOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(AccessPreviewFinding::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField
            .<List<FindingSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(AccessPreviewFinding::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AccessPreviewFinding::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CHANGE_TYPE_FIELD, CONDITION_FIELD, CREATED_AT_FIELD, ERROR_FIELD, EXISTING_FINDING_ID_FIELD,
            EXISTING_FINDING_STATUS_FIELD, ID_FIELD, IS_PUBLIC_FIELD, PRINCIPAL_FIELD, RESOURCE_FIELD,
            RESOURCE_OWNER_ACCOUNT_FIELD, RESOURCE_TYPE_FIELD, SOURCES_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> action;

    private final String changeType;

    private final Map<String, String> condition;

    private final Instant createdAt;

    private final String error;

    private final String existingFindingId;

    private final String existingFindingStatus;

    private final String id;

    private final Boolean isPublic;

    private final Map<String, String> principal;

    private final String resource;

    private final String resourceOwnerAccount;

    private final String resourceType;

    private final List<FindingSource> sources;

    private final String status;

    private AccessPreviewFinding(BuilderImpl builder) {
        this.action = builder.action;
        this.changeType = builder.changeType;
        this.condition = builder.condition;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.existingFindingId = builder.existingFindingId;
        this.existingFindingStatus = builder.existingFindingStatus;
        this.id = builder.id;
        this.isPublic = builder.isPublic;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceType = builder.resourceType;
        this.sources = builder.sources;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Action property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action in the analyzed policy statement that an external principal has permission to perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAction} method.
     * </p>
     * 
     * @return The action in the analyzed policy statement that an external principal has permission to perform.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * <p>
     * Provides context on how the access preview finding compares to existing access identified in IAM Access Analyzer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>New</code> - The finding is for newly-introduced access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Changed</code> - The preview finding is an existing finding with a change in status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a
     * result of the proposed permissions change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link FindingChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Provides context on how the access preview finding compares to existing access identified in IAM Access
     *         Analyzer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>New</code> - The finding is for newly-introduced access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Changed</code> - The preview finding is an existing finding with a change in status.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     *         <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code>
     *         as a result of the proposed permissions change.
     * @see FindingChangeType
     */
    public final FindingChangeType changeType() {
        return FindingChangeType.fromValue(changeType);
    }

    /**
     * <p>
     * Provides context on how the access preview finding compares to existing access identified in IAM Access Analyzer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>New</code> - The finding is for newly-introduced access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Changed</code> - The preview finding is an existing finding with a change in status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a
     * result of the proposed permissions change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeType} will
     * return {@link FindingChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changeTypeAsString}.
     * </p>
     * 
     * @return Provides context on how the access preview finding compares to existing access identified in IAM Access
     *         Analyzer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>New</code> - The finding is for newly-introduced access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Changed</code> - The preview finding is an existing finding with a change in status.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     *         <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code>
     *         as a result of the proposed permissions change.
     * @see FindingChangeType
     */
    public final String changeTypeAsString() {
        return changeType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Condition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCondition() {
        return condition != null && !(condition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The condition in the analyzed policy statement that resulted in a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCondition} method.
     * </p>
     * 
     * @return The condition in the analyzed policy statement that resulted in a finding.
     */
    public final Map<String, String> condition() {
        return condition;
    }

    /**
     * <p>
     * The time at which the access preview finding was created.
     * </p>
     * 
     * @return The time at which the access preview finding was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An error.
     * </p>
     * 
     * @return An error.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
     * </p>
     * 
     * @return The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
     */
    public final String existingFindingId() {
        return existingFindingId;
    }

    /**
     * <p>
     * The existing status of the finding, provided only for existing findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #existingFindingStatus} will return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #existingFindingStatusAsString}.
     * </p>
     * 
     * @return The existing status of the finding, provided only for existing findings.
     * @see FindingStatus
     */
    public final FindingStatus existingFindingStatus() {
        return FindingStatus.fromValue(existingFindingStatus);
    }

    /**
     * <p>
     * The existing status of the finding, provided only for existing findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #existingFindingStatus} will return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #existingFindingStatusAsString}.
     * </p>
     * 
     * @return The existing status of the finding, provided only for existing findings.
     * @see FindingStatus
     */
    public final String existingFindingStatusAsString() {
        return existingFindingStatus;
    }

    /**
     * <p>
     * The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview
     * findings and is not related to the finding ID in Access Analyzer.
     * </p>
     * 
     * @return The ID of the access preview finding. This ID uniquely identifies the element in the list of access
     *         preview findings and is not related to the finding ID in Access Analyzer.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates whether the policy that generated the finding allows public access to the resource.
     * </p>
     * 
     * @return Indicates whether the policy that generated the finding allows public access to the resource.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principal property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The external principal that has access to a resource within the zone of trust.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipal} method.
     * </p>
     * 
     * @return The external principal that has access to a resource within the zone of trust.
     */
    public final Map<String, String> principal() {
        return principal;
    }

    /**
     * <p>
     * The resource that an external principal has access to. This is the resource associated with the access preview.
     * </p>
     * 
     * @return The resource that an external principal has access to. This is the resource associated with the access
     *         preview.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
     * account is the account in which the resource was created.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the
     *         owning account is the account in which the resource was created.
     */
    public final String resourceOwnerAccount() {
        return resourceOwnerAccount;
    }

    /**
     * <p>
     * The type of the resource that can be accessed in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that can be accessed in the finding.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource that can be accessed in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that can be accessed in the finding.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated
     * for Amazon S3 bucket findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources of the finding. This indicates how the access that generated the finding is granted. It is
     *         populated for Amazon S3 bucket findings.
     */
    public final List<FindingSource> sources() {
        return sources;
    }

    /**
     * <p>
     * The preview status of the finding. This is what the status of the finding would be after permissions deployment.
     * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a
     * result of the proposed permissions change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The preview status of the finding. This is what the status of the finding would be after permissions
     *         deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
     *         existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
     *         <code>Resolved</code> as a result of the proposed permissions change.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The preview status of the finding. This is what the status of the finding would be after permissions deployment.
     * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
     * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as a
     * result of the proposed permissions change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The preview status of the finding. This is what the status of the finding would be after permissions
     *         deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
     *         existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
     *         <code>Resolved</code> as a result of the proposed permissions change.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCondition() ? condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(existingFindingId());
        hashCode = 31 * hashCode + Objects.hashCode(existingFindingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreviewFinding)) {
            return false;
        }
        AccessPreviewFinding other = (AccessPreviewFinding) obj;
        return hasAction() == other.hasAction() && Objects.equals(action(), other.action())
                && Objects.equals(changeTypeAsString(), other.changeTypeAsString()) && hasCondition() == other.hasCondition()
                && Objects.equals(condition(), other.condition()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(error(), other.error()) && Objects.equals(existingFindingId(), other.existingFindingId())
                && Objects.equals(existingFindingStatusAsString(), other.existingFindingStatusAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(isPublic(), other.isPublic())
                && hasPrincipal() == other.hasPrincipal() && Objects.equals(principal(), other.principal())
                && Objects.equals(resource(), other.resource())
                && Objects.equals(resourceOwnerAccount(), other.resourceOwnerAccount())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPreviewFinding").add("Action", hasAction() ? action() : null)
                .add("ChangeType", changeTypeAsString()).add("Condition", hasCondition() ? condition() : null)
                .add("CreatedAt", createdAt()).add("Error", error()).add("ExistingFindingId", existingFindingId())
                .add("ExistingFindingStatus", existingFindingStatusAsString()).add("Id", id()).add("IsPublic", isPublic())
                .add("Principal", hasPrincipal() ? principal() : null).add("Resource", resource())
                .add("ResourceOwnerAccount", resourceOwnerAccount()).add("ResourceType", resourceTypeAsString())
                .add("Sources", hasSources() ? sources() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "changeType":
            return Optional.ofNullable(clazz.cast(changeTypeAsString()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "existingFindingId":
            return Optional.ofNullable(clazz.cast(existingFindingId()));
        case "existingFindingStatus":
            return Optional.ofNullable(clazz.cast(existingFindingStatusAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "resourceOwnerAccount":
            return Optional.ofNullable(clazz.cast(resourceOwnerAccount()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPreviewFinding, T> g) {
        return obj -> g.apply((AccessPreviewFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPreviewFinding> {
        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to perform.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to perform.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * Provides context on how the access preview finding compares to existing access identified in IAM Access
         * Analyzer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>New</code> - The finding is for newly-introduced access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Changed</code> - The preview finding is an existing finding with a change in status.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
         * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as
         * a result of the proposed permissions change.
         * </p>
         * 
         * @param changeType
         *        Provides context on how the access preview finding compares to existing access identified in IAM
         *        Access Analyzer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>New</code> - The finding is for newly-introduced access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Changed</code> - The preview finding is an existing finding with a change in status.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing
         *        status <code>Active</code> indicates the existing <code>Active</code> finding would become
         *        <code>Resolved</code> as a result of the proposed permissions change.
         * @see FindingChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingChangeType
         */
        Builder changeType(String changeType);

        /**
         * <p>
         * Provides context on how the access preview finding compares to existing access identified in IAM Access
         * Analyzer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>New</code> - The finding is for newly-introduced access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Changed</code> - The preview finding is an existing finding with a change in status.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing status
         * <code>Active</code> indicates the existing <code>Active</code> finding would become <code>Resolved</code> as
         * a result of the proposed permissions change.
         * </p>
         * 
         * @param changeType
         *        Provides context on how the access preview finding compares to existing access identified in IAM
         *        Access Analyzer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>New</code> - The finding is for newly-introduced access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unchanged</code> - The preview finding is an existing finding that would remain unchanged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Changed</code> - The preview finding is an existing finding with a change in status.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and existing
         *        status <code>Active</code> indicates the existing <code>Active</code> finding would become
         *        <code>Resolved</code> as a result of the proposed permissions change.
         * @see FindingChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingChangeType
         */
        Builder changeType(FindingChangeType changeType);

        /**
         * <p>
         * The condition in the analyzed policy statement that resulted in a finding.
         * </p>
         * 
         * @param condition
         *        The condition in the analyzed policy statement that resulted in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Map<String, String> condition);

        /**
         * <p>
         * The time at which the access preview finding was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the access preview finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An error.
         * </p>
         * 
         * @param error
         *        An error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
         * </p>
         * 
         * @param existingFindingId
         *        The existing ID of the finding in IAM Access Analyzer, provided only for existing findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingFindingId(String existingFindingId);

        /**
         * <p>
         * The existing status of the finding, provided only for existing findings.
         * </p>
         * 
         * @param existingFindingStatus
         *        The existing status of the finding, provided only for existing findings.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder existingFindingStatus(String existingFindingStatus);

        /**
         * <p>
         * The existing status of the finding, provided only for existing findings.
         * </p>
         * 
         * @param existingFindingStatus
         *        The existing status of the finding, provided only for existing findings.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder existingFindingStatus(FindingStatus existingFindingStatus);

        /**
         * <p>
         * The ID of the access preview finding. This ID uniquely identifies the element in the list of access preview
         * findings and is not related to the finding ID in Access Analyzer.
         * </p>
         * 
         * @param id
         *        The ID of the access preview finding. This ID uniquely identifies the element in the list of access
         *        preview findings and is not related to the finding ID in Access Analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates whether the policy that generated the finding allows public access to the resource.
         * </p>
         * 
         * @param isPublic
         *        Indicates whether the policy that generated the finding allows public access to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);

        /**
         * <p>
         * The external principal that has access to a resource within the zone of trust.
         * </p>
         * 
         * @param principal
         *        The external principal that has access to a resource within the zone of trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Map<String, String> principal);

        /**
         * <p>
         * The resource that an external principal has access to. This is the resource associated with the access
         * preview.
         * </p>
         * 
         * @param resource
         *        The resource that an external principal has access to. This is the resource associated with the access
         *        preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
         * account is the account in which the resource was created.
         * </p>
         * 
         * @param resourceOwnerAccount
         *        The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the
         *        owning account is the account in which the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerAccount(String resourceOwnerAccount);

        /**
         * <p>
         * The type of the resource that can be accessed in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that can be accessed in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource that can be accessed in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that can be accessed in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the finding. This indicates how the access that generated the finding is granted. It is
         *        populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<FindingSource> sources);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the finding. This indicates how the access that generated the finding is granted. It is
         *        populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(FindingSource... sources);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FindingSource>.Builder} avoiding the
         * need to create one manually via {@link List<FindingSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #sources(List<FindingSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<FindingSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<FindingSource>)
         */
        Builder sources(Consumer<FindingSource.Builder>... sources);

        /**
         * <p>
         * The preview status of the finding. This is what the status of the finding would be after permissions
         * deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
         * existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
         * <code>Resolved</code> as a result of the proposed permissions change.
         * </p>
         * 
         * @param status
         *        The preview status of the finding. This is what the status of the finding would be after permissions
         *        deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
         *        existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
         *        <code>Resolved</code> as a result of the proposed permissions change.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The preview status of the finding. This is what the status of the finding would be after permissions
         * deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
         * existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
         * <code>Resolved</code> as a result of the proposed permissions change.
         * </p>
         * 
         * @param status
         *        The preview status of the finding. This is what the status of the finding would be after permissions
         *        deployment. For example, a <code>Changed</code> finding with preview status <code>Resolved</code> and
         *        existing status <code>Active</code> indicates the existing <code>Active</code> finding would become
         *        <code>Resolved</code> as a result of the proposed permissions change.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private String changeType;

        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private String error;

        private String existingFindingId;

        private String existingFindingStatus;

        private String id;

        private Boolean isPublic;

        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();

        private String resource;

        private String resourceOwnerAccount;

        private String resourceType;

        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreviewFinding model) {
            action(model.action);
            changeType(model.changeType);
            condition(model.condition);
            createdAt(model.createdAt);
            error(model.error);
            existingFindingId(model.existingFindingId);
            existingFindingStatus(model.existingFindingStatus);
            id(model.id);
            isPublic(model.isPublic);
            principal(model.principal);
            resource(model.resource);
            resourceOwnerAccount(model.resourceOwnerAccount);
            resourceType(model.resourceType);
            sources(model.sources);
            status(model.status);
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final String getChangeType() {
            return changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(FindingChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final Map<String, String> getCondition() {
            if (condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getExistingFindingId() {
            return existingFindingId;
        }

        public final void setExistingFindingId(String existingFindingId) {
            this.existingFindingId = existingFindingId;
        }

        @Override
        public final Builder existingFindingId(String existingFindingId) {
            this.existingFindingId = existingFindingId;
            return this;
        }

        public final String getExistingFindingStatus() {
            return existingFindingStatus;
        }

        public final void setExistingFindingStatus(String existingFindingStatus) {
            this.existingFindingStatus = existingFindingStatus;
        }

        @Override
        public final Builder existingFindingStatus(String existingFindingStatus) {
            this.existingFindingStatus = existingFindingStatus;
            return this;
        }

        @Override
        public final Builder existingFindingStatus(FindingStatus existingFindingStatus) {
            this.existingFindingStatus(existingFindingStatus == null ? null : existingFindingStatus.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceOwnerAccount() {
            return resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> FindingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AccessPreviewFinding build() {
            return new AccessPreviewFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
