/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPolicyGenerationRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<StartPolicyGenerationRequest.Builder, StartPolicyGenerationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartPolicyGenerationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CloudTrailDetails> CLOUD_TRAIL_DETAILS_FIELD = SdkField
            .<CloudTrailDetails> builder(MarshallingType.SDK_POJO).memberName("cloudTrailDetails")
            .getter(getter(StartPolicyGenerationRequest::cloudTrailDetails)).setter(setter(Builder::cloudTrailDetails))
            .constructor(CloudTrailDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailDetails").build()).build();

    private static final SdkField<PolicyGenerationDetails> POLICY_GENERATION_DETAILS_FIELD = SdkField
            .<PolicyGenerationDetails> builder(MarshallingType.SDK_POJO).memberName("policyGenerationDetails")
            .getter(getter(StartPolicyGenerationRequest::policyGenerationDetails))
            .setter(setter(Builder::policyGenerationDetails)).constructor(PolicyGenerationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CLOUD_TRAIL_DETAILS_FIELD, POLICY_GENERATION_DETAILS_FIELD));

    private final String clientToken;

    private final CloudTrailDetails cloudTrailDetails;

    private final PolicyGenerationDetails policyGenerationDetails;

    private StartPolicyGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.cloudTrailDetails = builder.cloudTrailDetails;
        this.policyGenerationDetails = builder.policyGenerationDetails;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to analyze
     * to generate policies.
     * </p>
     * 
     * @return A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
     *         analyze to generate policies.
     */
    public final CloudTrailDetails cloudTrailDetails() {
        return cloudTrailDetails;
    }

    /**
     * <p>
     * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @return Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    public final PolicyGenerationDetails policyGenerationDetails() {
        return policyGenerationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrailDetails());
        hashCode = 31 * hashCode + Objects.hashCode(policyGenerationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPolicyGenerationRequest)) {
            return false;
        }
        StartPolicyGenerationRequest other = (StartPolicyGenerationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(cloudTrailDetails(), other.cloudTrailDetails())
                && Objects.equals(policyGenerationDetails(), other.policyGenerationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPolicyGenerationRequest").add("ClientToken", clientToken())
                .add("CloudTrailDetails", cloudTrailDetails()).add("PolicyGenerationDetails", policyGenerationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "cloudTrailDetails":
            return Optional.ofNullable(clazz.cast(cloudTrailDetails()));
        case "policyGenerationDetails":
            return Optional.ofNullable(clazz.cast(policyGenerationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPolicyGenerationRequest, T> g) {
        return obj -> g.apply((StartPolicyGenerationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartPolicyGenerationRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
         * analyze to generate policies.
         * </p>
         * 
         * @param cloudTrailDetails
         *        A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want
         *        to analyze to generate policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrailDetails(CloudTrailDetails cloudTrailDetails);

        /**
         * <p>
         * A <code>CloudTrailDetails</code> object that contains details about a <code>Trail</code> that you want to
         * analyze to generate policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudTrailDetails.Builder} avoiding the
         * need to create one manually via {@link CloudTrailDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudTrailDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudTrailDetails(CloudTrailDetails)}.
         * 
         * @param cloudTrailDetails
         *        a consumer that will call methods on {@link CloudTrailDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudTrailDetails(CloudTrailDetails)
         */
        default Builder cloudTrailDetails(Consumer<CloudTrailDetails.Builder> cloudTrailDetails) {
            return cloudTrailDetails(CloudTrailDetails.builder().applyMutation(cloudTrailDetails).build());
        }

        /**
         * <p>
         * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
         * </p>
         * 
         * @param policyGenerationDetails
         *        Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyGenerationDetails(PolicyGenerationDetails policyGenerationDetails);

        /**
         * <p>
         * Contains the ARN of the IAM entity (user or role) for which you are generating a policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyGenerationDetails.Builder} avoiding
         * the need to create one manually via {@link PolicyGenerationDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyGenerationDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #policyGenerationDetails(PolicyGenerationDetails)}.
         * 
         * @param policyGenerationDetails
         *        a consumer that will call methods on {@link PolicyGenerationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyGenerationDetails(PolicyGenerationDetails)
         */
        default Builder policyGenerationDetails(Consumer<PolicyGenerationDetails.Builder> policyGenerationDetails) {
            return policyGenerationDetails(PolicyGenerationDetails.builder().applyMutation(policyGenerationDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private CloudTrailDetails cloudTrailDetails;

        private PolicyGenerationDetails policyGenerationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPolicyGenerationRequest model) {
            super(model);
            clientToken(model.clientToken);
            cloudTrailDetails(model.cloudTrailDetails);
            policyGenerationDetails(model.policyGenerationDetails);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CloudTrailDetails.Builder getCloudTrailDetails() {
            return cloudTrailDetails != null ? cloudTrailDetails.toBuilder() : null;
        }

        public final void setCloudTrailDetails(CloudTrailDetails.BuilderImpl cloudTrailDetails) {
            this.cloudTrailDetails = cloudTrailDetails != null ? cloudTrailDetails.build() : null;
        }

        @Override
        public final Builder cloudTrailDetails(CloudTrailDetails cloudTrailDetails) {
            this.cloudTrailDetails = cloudTrailDetails;
            return this;
        }

        public final PolicyGenerationDetails.Builder getPolicyGenerationDetails() {
            return policyGenerationDetails != null ? policyGenerationDetails.toBuilder() : null;
        }

        public final void setPolicyGenerationDetails(PolicyGenerationDetails.BuilderImpl policyGenerationDetails) {
            this.policyGenerationDetails = policyGenerationDetails != null ? policyGenerationDetails.build() : null;
        }

        @Override
        public final Builder policyGenerationDetails(PolicyGenerationDetails policyGenerationDetails) {
            this.policyGenerationDetails = policyGenerationDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPolicyGenerationRequest build() {
            return new StartPolicyGenerationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
