/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access control configuration structures for your resource. You specify the configuration as a type-value pair. You
 * can specify only one type of access control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<IamRoleConfiguration> IAM_ROLE_FIELD = SdkField
            .<IamRoleConfiguration> builder(MarshallingType.SDK_POJO).memberName("iamRole")
            .getter(getter(Configuration::iamRole)).setter(setter(Builder::iamRole)).constructor(IamRoleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<KmsKeyConfiguration> KMS_KEY_FIELD = SdkField
            .<KmsKeyConfiguration> builder(MarshallingType.SDK_POJO).memberName("kmsKey").getter(getter(Configuration::kmsKey))
            .setter(setter(Builder::kmsKey)).constructor(KmsKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final SdkField<SecretsManagerSecretConfiguration> SECRETS_MANAGER_SECRET_FIELD = SdkField
            .<SecretsManagerSecretConfiguration> builder(MarshallingType.SDK_POJO).memberName("secretsManagerSecret")
            .getter(getter(Configuration::secretsManagerSecret)).setter(setter(Builder::secretsManagerSecret))
            .constructor(SecretsManagerSecretConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerSecret").build())
            .build();

    private static final SdkField<S3BucketConfiguration> S3_BUCKET_FIELD = SdkField
            .<S3BucketConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Bucket")
            .getter(getter(Configuration::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3BucketConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<SqsQueueConfiguration> SQS_QUEUE_FIELD = SdkField
            .<SqsQueueConfiguration> builder(MarshallingType.SDK_POJO).memberName("sqsQueue")
            .getter(getter(Configuration::sqsQueue)).setter(setter(Builder::sqsQueue))
            .constructor(SqsQueueConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsQueue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_FIELD, KMS_KEY_FIELD,
            SECRETS_MANAGER_SECRET_FIELD, S3_BUCKET_FIELD, SQS_QUEUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final IamRoleConfiguration iamRole;

    private final KmsKeyConfiguration kmsKey;

    private final SecretsManagerSecretConfiguration secretsManagerSecret;

    private final S3BucketConfiguration s3Bucket;

    private final SqsQueueConfiguration sqsQueue;

    private final Type type;

    private Configuration(BuilderImpl builder) {
        this.iamRole = builder.iamRole;
        this.kmsKey = builder.kmsKey;
        this.secretsManagerSecret = builder.secretsManagerSecret;
        this.s3Bucket = builder.s3Bucket;
        this.sqsQueue = builder.sqsQueue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @return The access control configuration is for an IAM role.
     */
    public final IamRoleConfiguration iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @return The access control configuration is for a KMS key.
     */
    public final KmsKeyConfiguration kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @return The access control configuration is for a Secrets Manager secret.
     */
    public final SecretsManagerSecretConfiguration secretsManagerSecret() {
        return secretsManagerSecret;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon S3 Bucket.
     * </p>
     * 
     * @return The access control configuration is for an Amazon S3 Bucket.
     */
    public final S3BucketConfiguration s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @return The access control configuration is for an Amazon SQS queue.
     */
    public final SqsQueueConfiguration sqsQueue() {
        return sqsQueue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecret());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(iamRole(), other.iamRole()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(secretsManagerSecret(), other.secretsManagerSecret())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(sqsQueue(), other.sqsQueue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configuration").add("IamRole", iamRole()).add("KmsKey", kmsKey())
                .add("SecretsManagerSecret", secretsManagerSecret()).add("S3Bucket", s3Bucket()).add("SqsQueue", sqsQueue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "secretsManagerSecret":
            return Optional.ofNullable(clazz.cast(secretsManagerSecret()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "sqsQueue":
            return Optional.ofNullable(clazz.cast(sqsQueue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #iamRole()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @param iamRole
     *        The access control configuration is for an IAM role.
     */
    public static Configuration fromIamRole(IamRoleConfiguration iamRole) {
        return builder().iamRole(iamRole).build();
    }

    /**
     * Create an instance of this class with {@link #iamRole()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @param iamRole
     *        The access control configuration is for an IAM role.
     */
    public static Configuration fromIamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
        IamRoleConfiguration.Builder builder = IamRoleConfiguration.builder();
        iamRole.accept(builder);
        return fromIamRole(builder.build());
    }

    /**
     * Create an instance of this class with {@link #kmsKey()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @param kmsKey
     *        The access control configuration is for a KMS key.
     */
    public static Configuration fromKmsKey(KmsKeyConfiguration kmsKey) {
        return builder().kmsKey(kmsKey).build();
    }

    /**
     * Create an instance of this class with {@link #kmsKey()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @param kmsKey
     *        The access control configuration is for a KMS key.
     */
    public static Configuration fromKmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
        KmsKeyConfiguration.Builder builder = KmsKeyConfiguration.builder();
        kmsKey.accept(builder);
        return fromKmsKey(builder.build());
    }

    /**
     * Create an instance of this class with {@link #secretsManagerSecret()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @param secretsManagerSecret
     *        The access control configuration is for a Secrets Manager secret.
     */
    public static Configuration fromSecretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
        return builder().secretsManagerSecret(secretsManagerSecret).build();
    }

    /**
     * Create an instance of this class with {@link #secretsManagerSecret()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @param secretsManagerSecret
     *        The access control configuration is for a Secrets Manager secret.
     */
    public static Configuration fromSecretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
        SecretsManagerSecretConfiguration.Builder builder = SecretsManagerSecretConfiguration.builder();
        secretsManagerSecret.accept(builder);
        return fromSecretsManagerSecret(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 Bucket.
     * </p>
     * 
     * @param s3Bucket
     *        The access control configuration is for an Amazon S3 Bucket.
     */
    public static Configuration fromS3Bucket(S3BucketConfiguration s3Bucket) {
        return builder().s3Bucket(s3Bucket).build();
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 Bucket.
     * </p>
     * 
     * @param s3Bucket
     *        The access control configuration is for an Amazon S3 Bucket.
     */
    public static Configuration fromS3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
        S3BucketConfiguration.Builder builder = S3BucketConfiguration.builder();
        s3Bucket.accept(builder);
        return fromS3Bucket(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sqsQueue()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @param sqsQueue
     *        The access control configuration is for an Amazon SQS queue.
     */
    public static Configuration fromSqsQueue(SqsQueueConfiguration sqsQueue) {
        return builder().sqsQueue(sqsQueue).build();
    }

    /**
     * Create an instance of this class with {@link #sqsQueue()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @param sqsQueue
     *        The access control configuration is for an Amazon SQS queue.
     */
    public static Configuration fromSqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
        SqsQueueConfiguration.Builder builder = SqsQueueConfiguration.builder();
        sqsQueue.accept(builder);
        return fromSqsQueue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         * <p>
         * The access control configuration is for an IAM role.
         * </p>
         * 
         * @param iamRole
         *        The access control configuration is for an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(IamRoleConfiguration iamRole);

        /**
         * <p>
         * The access control configuration is for an IAM role.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamRoleConfiguration.Builder} avoiding
         * the need to create one manually via {@link IamRoleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamRoleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #iamRole(IamRoleConfiguration)}.
         * 
         * @param iamRole
         *        a consumer that will call methods on {@link IamRoleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRole(IamRoleConfiguration)
         */
        default Builder iamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
            return iamRole(IamRoleConfiguration.builder().applyMutation(iamRole).build());
        }

        /**
         * <p>
         * The access control configuration is for a KMS key.
         * </p>
         * 
         * @param kmsKey
         *        The access control configuration is for a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(KmsKeyConfiguration kmsKey);

        /**
         * <p>
         * The access control configuration is for a KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link KmsKeyConfiguration.Builder} avoiding the
         * need to create one manually via {@link KmsKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KmsKeyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kmsKey(KmsKeyConfiguration)}.
         * 
         * @param kmsKey
         *        a consumer that will call methods on {@link KmsKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsKey(KmsKeyConfiguration)
         */
        default Builder kmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
            return kmsKey(KmsKeyConfiguration.builder().applyMutation(kmsKey).build());
        }

        /**
         * <p>
         * The access control configuration is for a Secrets Manager secret.
         * </p>
         * 
         * @param secretsManagerSecret
         *        The access control configuration is for a Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret);

        /**
         * <p>
         * The access control configuration is for a Secrets Manager secret.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerSecretConfiguration.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerSecretConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerSecretConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #secretsManagerSecret(SecretsManagerSecretConfiguration)}.
         * 
         * @param secretsManagerSecret
         *        a consumer that will call methods on {@link SecretsManagerSecretConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerSecret(SecretsManagerSecretConfiguration)
         */
        default Builder secretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
            return secretsManagerSecret(SecretsManagerSecretConfiguration.builder().applyMutation(secretsManagerSecret).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon S3 Bucket.
         * </p>
         * 
         * @param s3Bucket
         *        The access control configuration is for an Amazon S3 Bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3BucketConfiguration s3Bucket);

        /**
         * <p>
         * The access control configuration is for an Amazon S3 Bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3BucketConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Bucket(S3BucketConfiguration)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3BucketConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3BucketConfiguration)
         */
        default Builder s3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
            return s3Bucket(S3BucketConfiguration.builder().applyMutation(s3Bucket).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon SQS queue.
         * </p>
         * 
         * @param sqsQueue
         *        The access control configuration is for an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueue(SqsQueueConfiguration sqsQueue);

        /**
         * <p>
         * The access control configuration is for an Amazon SQS queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsQueueConfiguration.Builder} avoiding
         * the need to create one manually via {@link SqsQueueConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsQueueConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sqsQueue(SqsQueueConfiguration)}.
         * 
         * @param sqsQueue
         *        a consumer that will call methods on {@link SqsQueueConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueue(SqsQueueConfiguration)
         */
        default Builder sqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
            return sqsQueue(SqsQueueConfiguration.builder().applyMutation(sqsQueue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamRoleConfiguration iamRole;

        private KmsKeyConfiguration kmsKey;

        private SecretsManagerSecretConfiguration secretsManagerSecret;

        private S3BucketConfiguration s3Bucket;

        private SqsQueueConfiguration sqsQueue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            iamRole(model.iamRole);
            kmsKey(model.kmsKey);
            secretsManagerSecret(model.secretsManagerSecret);
            s3Bucket(model.s3Bucket);
            sqsQueue(model.sqsQueue);
        }

        public final IamRoleConfiguration.Builder getIamRole() {
            return iamRole != null ? iamRole.toBuilder() : null;
        }

        public final void setIamRole(IamRoleConfiguration.BuilderImpl iamRole) {
            Object oldValue = this.iamRole;
            this.iamRole = iamRole != null ? iamRole.build() : null;
            handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
        }

        @Override
        public final Builder iamRole(IamRoleConfiguration iamRole) {
            Object oldValue = this.iamRole;
            this.iamRole = iamRole;
            handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
            return this;
        }

        public final KmsKeyConfiguration.Builder getKmsKey() {
            return kmsKey != null ? kmsKey.toBuilder() : null;
        }

        public final void setKmsKey(KmsKeyConfiguration.BuilderImpl kmsKey) {
            Object oldValue = this.kmsKey;
            this.kmsKey = kmsKey != null ? kmsKey.build() : null;
            handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
        }

        @Override
        public final Builder kmsKey(KmsKeyConfiguration kmsKey) {
            Object oldValue = this.kmsKey;
            this.kmsKey = kmsKey;
            handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
            return this;
        }

        public final SecretsManagerSecretConfiguration.Builder getSecretsManagerSecret() {
            return secretsManagerSecret != null ? secretsManagerSecret.toBuilder() : null;
        }

        public final void setSecretsManagerSecret(SecretsManagerSecretConfiguration.BuilderImpl secretsManagerSecret) {
            Object oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret != null ? secretsManagerSecret.build() : null;
            handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
        }

        @Override
        public final Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
            Object oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret;
            handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
            return this;
        }

        public final S3BucketConfiguration.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3BucketConfiguration.BuilderImpl s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        public final Builder s3Bucket(S3BucketConfiguration s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final SqsQueueConfiguration.Builder getSqsQueue() {
            return sqsQueue != null ? sqsQueue.toBuilder() : null;
        }

        public final void setSqsQueue(SqsQueueConfiguration.BuilderImpl sqsQueue) {
            Object oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue != null ? sqsQueue.build() : null;
            handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
        }

        @Override
        public final Builder sqsQueue(SqsQueueConfiguration sqsQueue) {
            Object oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue;
            handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Configuration#type()
     */
    public enum Type {
        IAM_ROLE,

        KMS_KEY,

        SECRETS_MANAGER_SECRET,

        S3_BUCKET,

        SQS_QUEUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
