/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides more details about the current status of the access preview. For example, if the creation of the access
 * preview fails, a <code>Failed</code> status is returned. This failure can be due to an internal issue with the
 * analysis or due to an invalid proposed resource configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPreviewStatusReason implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPreviewStatusReason.Builder, AccessPreviewStatusReason> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(AccessPreviewStatusReason::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private AccessPreviewStatusReason(BuilderImpl builder) {
        this.code = builder.code;
    }

    /**
     * <p>
     * The reason code for the current status of the access preview.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AccessPreviewStatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return The reason code for the current status of the access preview.
     * @see AccessPreviewStatusReasonCode
     */
    public final AccessPreviewStatusReasonCode code() {
        return AccessPreviewStatusReasonCode.fromValue(code);
    }

    /**
     * <p>
     * The reason code for the current status of the access preview.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AccessPreviewStatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return The reason code for the current status of the access preview.
     * @see AccessPreviewStatusReasonCode
     */
    public final String codeAsString() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreviewStatusReason)) {
            return false;
        }
        AccessPreviewStatusReason other = (AccessPreviewStatusReason) obj;
        return Objects.equals(codeAsString(), other.codeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPreviewStatusReason").add("Code", codeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPreviewStatusReason, T> g) {
        return obj -> g.apply((AccessPreviewStatusReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPreviewStatusReason> {
        /**
         * <p>
         * The reason code for the current status of the access preview.
         * </p>
         * 
         * @param code
         *        The reason code for the current status of the access preview.
         * @see AccessPreviewStatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPreviewStatusReasonCode
         */
        Builder code(String code);

        /**
         * <p>
         * The reason code for the current status of the access preview.
         * </p>
         * 
         * @param code
         *        The reason code for the current status of the access preview.
         * @see AccessPreviewStatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPreviewStatusReasonCode
         */
        Builder code(AccessPreviewStatusReasonCode code);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreviewStatusReason model) {
            code(model.code);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        @Transient
        public final Builder code(AccessPreviewStatusReasonCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        @Override
        public AccessPreviewStatusReason build() {
            return new AccessPreviewStatusReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
