/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proposed access control configuration for a KMS key. You can propose a configuration for a new KMS key or an existing
 * KMS key that you own by specifying the key policy and KMS grant configuration. If the configuration is for an
 * existing key and you do not specify the key policy, the access preview uses the existing policy for the key. If the
 * access preview is for a new resource and you do not specify the key policy, then the access preview uses the default
 * key policy. The proposed key policy cannot be an empty string. For more information, see <a
 * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
 * policy</a>. For more information about key policy limits, see <a
 * href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource quotas</a>.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KmsKeyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KmsKeyConfiguration.Builder, KmsKeyConfiguration> {
    private static final SdkField<List<KmsGrantConfiguration>> GRANTS_FIELD = SdkField
            .<List<KmsGrantConfiguration>> builder(MarshallingType.LIST)
            .memberName("grants")
            .getter(getter(KmsKeyConfiguration::grants))
            .setter(setter(Builder::grants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KmsGrantConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KmsGrantConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> KEY_POLICIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("keyPolicies")
            .getter(getter(KmsKeyConfiguration::keyPolicies))
            .setter(setter(Builder::keyPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPolicies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTS_FIELD,
            KEY_POLICIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<KmsGrantConfiguration> grants;

    private final Map<String, String> keyPolicies;

    private KmsKeyConfiguration(BuilderImpl builder) {
        this.grants = builder.grants;
        this.keyPolicies = builder.keyPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Grants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGrants() {
        return grants != null && !(grants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an existing
     * key, the access preview uses the proposed list of grant configurations in place of the existing grants.
     * Otherwise, the access preview uses the existing grants for the key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrants} method.
     * </p>
     * 
     * @return A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
     *         existing key, the access preview uses the proposed list of grant configurations in place of the existing
     *         grants. Otherwise, the access preview uses the existing grants for the key.
     */
    public final List<KmsGrantConfiguration> grants() {
        return grants;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyPolicies() {
        return keyPolicies != null && !(keyPolicies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Resource policy configuration for the KMS key. The only valid value for the name of the key policy is
     * <code>default</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
     * policy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPolicies} method.
     * </p>
     * 
     * @return Resource policy configuration for the KMS key. The only valid value for the name of the key policy is
     *         <code>default</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default
     *         key policy</a>.
     */
    public final Map<String, String> keyPolicies() {
        return keyPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGrants() ? grants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyPolicies() ? keyPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsKeyConfiguration)) {
            return false;
        }
        KmsKeyConfiguration other = (KmsKeyConfiguration) obj;
        return hasGrants() == other.hasGrants() && Objects.equals(grants(), other.grants())
                && hasKeyPolicies() == other.hasKeyPolicies() && Objects.equals(keyPolicies(), other.keyPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KmsKeyConfiguration").add("Grants", hasGrants() ? grants() : null)
                .add("KeyPolicies", hasKeyPolicies() ? keyPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grants":
            return Optional.ofNullable(clazz.cast(grants()));
        case "keyPolicies":
            return Optional.ofNullable(clazz.cast(keyPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsKeyConfiguration, T> g) {
        return obj -> g.apply((KmsKeyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KmsKeyConfiguration> {
        /**
         * <p>
         * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
         * existing key, the access preview uses the proposed list of grant configurations in place of the existing
         * grants. Otherwise, the access preview uses the existing grants for the key.
         * </p>
         * 
         * @param grants
         *        A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
         *        existing key, the access preview uses the proposed list of grant configurations in place of the
         *        existing grants. Otherwise, the access preview uses the existing grants for the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<KmsGrantConfiguration> grants);

        /**
         * <p>
         * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
         * existing key, the access preview uses the proposed list of grant configurations in place of the existing
         * grants. Otherwise, the access preview uses the existing grants for the key.
         * </p>
         * 
         * @param grants
         *        A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
         *        existing key, the access preview uses the proposed list of grant configurations in place of the
         *        existing grants. Otherwise, the access preview uses the existing grants for the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(KmsGrantConfiguration... grants);

        /**
         * <p>
         * A list of proposed grant configurations for the KMS key. If the proposed grant configuration is for an
         * existing key, the access preview uses the proposed list of grant configurations in place of the existing
         * grants. Otherwise, the access preview uses the existing grants for the key.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KmsGrantConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<KmsGrantConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KmsGrantConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #grants(List<KmsGrantConfiguration>)}.
         * 
         * @param grants
         *        a consumer that will call methods on {@link List<KmsGrantConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grants(List<KmsGrantConfiguration>)
         */
        Builder grants(Consumer<KmsGrantConfiguration.Builder>... grants);

        /**
         * <p>
         * Resource policy configuration for the KMS key. The only valid value for the name of the key policy is
         * <code>default</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
         * policy</a>.
         * </p>
         * 
         * @param keyPolicies
         *        Resource policy configuration for the KMS key. The only valid value for the name of the key policy is
         *        <code>default</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default"
         *        >Default key policy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPolicies(Map<String, String> keyPolicies);
    }

    static final class BuilderImpl implements Builder {
        private List<KmsGrantConfiguration> grants = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> keyPolicies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KmsKeyConfiguration model) {
            grants(model.grants);
            keyPolicies(model.keyPolicies);
        }

        public final List<KmsGrantConfiguration.Builder> getGrants() {
            List<KmsGrantConfiguration.Builder> result = KmsGrantConfigurationsListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrants(Collection<KmsGrantConfiguration.BuilderImpl> grants) {
            this.grants = KmsGrantConfigurationsListCopier.copyFromBuilder(grants);
        }

        @Override
        @Transient
        public final Builder grants(Collection<KmsGrantConfiguration> grants) {
            this.grants = KmsGrantConfigurationsListCopier.copy(grants);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grants(KmsGrantConfiguration... grants) {
            grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grants(Consumer<KmsGrantConfiguration.Builder>... grants) {
            grants(Stream.of(grants).map(c -> KmsGrantConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getKeyPolicies() {
            if (keyPolicies instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyPolicies;
        }

        public final void setKeyPolicies(Map<String, String> keyPolicies) {
            this.keyPolicies = KmsKeyPoliciesMapCopier.copy(keyPolicies);
        }

        @Override
        @Transient
        public final Builder keyPolicies(Map<String, String> keyPolicies) {
            this.keyPolicies = KmsKeyPoliciesMapCopier.copy(keyPolicies);
            return this;
        }

        @Override
        public KmsKeyConfiguration build() {
            return new KmsKeyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
