/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>PublicAccessBlock</code> configuration to apply to this Amazon S3 bucket. If the proposed configuration is
 * for an existing Amazon S3 bucket and the configuration is not specified, the access preview uses the existing
 * setting. If the proposed configuration is for a new bucket and the configuration is not specified, the access preview
 * uses <code>false</code>. If the proposed configuration is for a new access point or multi-region access point and the
 * access point BPA configuration is not specified, the access preview uses <code>true</code>. For more information, see
 * <a href=
 * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html"
 * >PublicAccessBlockConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3PublicAccessBlockConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3PublicAccessBlockConfiguration.Builder, S3PublicAccessBlockConfiguration> {
    private static final SdkField<Boolean> IGNORE_PUBLIC_ACLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignorePublicAcls").getter(getter(S3PublicAccessBlockConfiguration::ignorePublicAcls))
            .setter(setter(Builder::ignorePublicAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignorePublicAcls").build()).build();

    private static final SdkField<Boolean> RESTRICT_PUBLIC_BUCKETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("restrictPublicBuckets").getter(getter(S3PublicAccessBlockConfiguration::restrictPublicBuckets))
            .setter(setter(Builder::restrictPublicBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictPublicBuckets").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_PUBLIC_ACLS_FIELD,
            RESTRICT_PUBLIC_BUCKETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean ignorePublicAcls;

    private final Boolean restrictPublicBuckets;

    private S3PublicAccessBlockConfiguration(BuilderImpl builder) {
        this.ignorePublicAcls = builder.ignorePublicAcls;
        this.restrictPublicBuckets = builder.restrictPublicBuckets;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
     */
    public final Boolean ignorePublicAcls() {
        return ignorePublicAcls;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
     * </p>
     * 
     * @return Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
     */
    public final Boolean restrictPublicBuckets() {
        return restrictPublicBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ignorePublicAcls());
        hashCode = 31 * hashCode + Objects.hashCode(restrictPublicBuckets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3PublicAccessBlockConfiguration)) {
            return false;
        }
        S3PublicAccessBlockConfiguration other = (S3PublicAccessBlockConfiguration) obj;
        return Objects.equals(ignorePublicAcls(), other.ignorePublicAcls())
                && Objects.equals(restrictPublicBuckets(), other.restrictPublicBuckets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3PublicAccessBlockConfiguration").add("IgnorePublicAcls", ignorePublicAcls())
                .add("RestrictPublicBuckets", restrictPublicBuckets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ignorePublicAcls":
            return Optional.ofNullable(clazz.cast(ignorePublicAcls()));
        case "restrictPublicBuckets":
            return Optional.ofNullable(clazz.cast(restrictPublicBuckets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3PublicAccessBlockConfiguration, T> g) {
        return obj -> g.apply((S3PublicAccessBlockConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3PublicAccessBlockConfiguration> {
        /**
         * <p>
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
         * </p>
         * 
         * @param ignorePublicAcls
         *        Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignorePublicAcls(Boolean ignorePublicAcls);

        /**
         * <p>
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         * </p>
         * 
         * @param restrictPublicBuckets
         *        Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictPublicBuckets(Boolean restrictPublicBuckets);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ignorePublicAcls;

        private Boolean restrictPublicBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(S3PublicAccessBlockConfiguration model) {
            ignorePublicAcls(model.ignorePublicAcls);
            restrictPublicBuckets(model.restrictPublicBuckets);
        }

        public final Boolean getIgnorePublicAcls() {
            return ignorePublicAcls;
        }

        public final void setIgnorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
        }

        @Override
        public final Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            this.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        public final Boolean getRestrictPublicBuckets() {
            return restrictPublicBuckets;
        }

        public final void setRestrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
        }

        @Override
        public final Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            this.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        @Override
        public S3PublicAccessBlockConfiguration build() {
            return new S3PublicAccessBlockConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
