/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason;
import software.amazon.awssdk.services.accessanalyzer.model.Configuration;
import software.amazon.awssdk.services.accessanalyzer.model.ConfigurationsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPreview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPreview> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AccessPreview.getter(AccessPreview::id)).setter(AccessPreview.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(AccessPreview.getter(AccessPreview::analyzerArn)).setter(AccessPreview.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<Map<String, Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configurations").getter(AccessPreview.getter(AccessPreview::configurations)).setter(AccessPreview.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AccessPreview.getter(AccessPreview::createdAt)).setter(AccessPreview.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AccessPreview.getter(AccessPreview::statusAsString)).setter(AccessPreview.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<AccessPreviewStatusReason> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusReason").getter(AccessPreview.getter(AccessPreview::statusReason)).setter(AccessPreview.setter(Builder::statusReason)).constructor(AccessPreviewStatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ANALYZER_ARN_FIELD, CONFIGURATIONS_FIELD, CREATED_AT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String analyzerArn;
    private final Map<String, Configuration> configurations;
    private final Instant createdAt;
    private final String status;
    private final AccessPreviewStatusReason statusReason;

    private AccessPreview(BuilderImpl builder) {
        this.id = builder.id;
        this.analyzerArn = builder.analyzerArn;
        this.configurations = builder.configurations;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String id() {
        return this.id;
    }

    public final String analyzerArn() {
        return this.analyzerArn;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, Configuration> configurations() {
        return this.configurations;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final AccessPreviewStatus status() {
        return AccessPreviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AccessPreviewStatusReason statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreview)) {
            return false;
        }
        AccessPreview other = (AccessPreview)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.analyzerArn(), other.analyzerArn()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPreview").add("Id", (Object)this.id()).add("AnalyzerArn", (Object)this.analyzerArn()).add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPreview, T> g) {
        return obj -> g.apply((AccessPreview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String analyzerArn;
        private Map<String, Configuration> configurations = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private String status;
        private AccessPreviewStatusReason statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreview model) {
            this.id(model.id);
            this.analyzerArn(model.analyzerArn);
            this.configurations(model.configurations);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final Map<String, Configuration.Builder> getConfigurations() {
            Map<String, Configuration.Builder> result = ConfigurationsMapCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Map<String, Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationsMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Map<String, Configuration> configurations) {
            this.configurations = ConfigurationsMapCopier.copy(configurations);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccessPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AccessPreviewStatusReason.Builder getStatusReason() {
            return this.statusReason != null ? this.statusReason.toBuilder() : null;
        }

        public final void setStatusReason(AccessPreviewStatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(AccessPreviewStatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public AccessPreview build() {
            return new AccessPreview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPreview> {
        public Builder id(String var1);

        public Builder analyzerArn(String var1);

        public Builder configurations(Map<String, Configuration> var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(AccessPreviewStatus var1);

        public Builder statusReason(AccessPreviewStatusReason var1);

        default public Builder statusReason(Consumer<AccessPreviewStatusReason.Builder> statusReason) {
            return this.statusReason((AccessPreviewStatusReason)((AccessPreviewStatusReason.Builder)AccessPreviewStatusReason.builder().applyMutation(statusReason)).build());
        }
    }
}

