/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanResponse;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher;
import software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher;

/**
 * Service client for accessing Access Analyzer asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Identity and Access Management Access Analyzer helps identify potential resource-access risks by enabling you to
 * identify any policies that grant access to an external principal. It does this by using logic-based reasoning to
 * analyze resource-based policies in your Amazon Web Services environment. An external principal can be another Amazon
 * Web Services account, a root user, an IAM user or role, a federated user, an Amazon Web Services service, or an
 * anonymous user. You can also use IAM Access Analyzer to preview and validate public and cross-account access to your
 * resources before deploying permissions changes. This guide describes the Identity and Access Management Access
 * Analyzer operations that you can call programmatically. For general information about IAM Access Analyzer, see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html">Identity and Access Management
 * Access Analyzer</a> in the <b>IAM User Guide</b>.
 * </p>
 * <p>
 * To start using IAM Access Analyzer, you first need to create an analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AccessAnalyzerAsyncClient extends AwsClient {
    String SERVICE_NAME = "access-analyzer";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "access-analyzer";

    /**
     * <p>
     * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
     * </p>
     *
     * @param applyArchiveRuleRequest
     *        Retroactively applies an archive rule.
     * @return A Java Future containing the result of the ApplyArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ApplyArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyArchiveRuleResponse> applyArchiveRule(ApplyArchiveRuleRequest applyArchiveRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyArchiveRuleRequest.Builder} avoiding the need
     * to create one manually via {@link ApplyArchiveRuleRequest#builder()}
     * </p>
     *
     * @param applyArchiveRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest.Builder} to create a
     *        request. Retroactively applies an archive rule.
     * @return A Java Future containing the result of the ApplyArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ApplyArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ApplyArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyArchiveRuleResponse> applyArchiveRule(
            Consumer<ApplyArchiveRuleRequest.Builder> applyArchiveRuleRequest) {
        return applyArchiveRule(ApplyArchiveRuleRequest.builder().applyMutation(applyArchiveRuleRequest).build());
    }

    /**
     * <p>
     * Cancels the requested policy generation.
     * </p>
     *
     * @param cancelPolicyGenerationRequest
     * @return A Java Future containing the result of the CancelPolicyGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CancelPolicyGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CancelPolicyGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPolicyGenerationResponse> cancelPolicyGeneration(
            CancelPolicyGenerationRequest cancelPolicyGenerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the requested policy generation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelPolicyGenerationRequest.Builder} avoiding the
     * need to create one manually via {@link CancelPolicyGenerationRequest#builder()}
     * </p>
     *
     * @param cancelPolicyGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelPolicyGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CancelPolicyGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CancelPolicyGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelPolicyGenerationResponse> cancelPolicyGeneration(
            Consumer<CancelPolicyGenerationRequest.Builder> cancelPolicyGenerationRequest) {
        return cancelPolicyGeneration(CancelPolicyGenerationRequest.builder().applyMutation(cancelPolicyGenerationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before
     * deploying resource permissions.
     * </p>
     *
     * @param createAccessPreviewRequest
     * @return A Java Future containing the result of the CreateAccessPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateAccessPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAccessPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPreviewResponse> createAccessPreview(
            CreateAccessPreviewRequest createAccessPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before
     * deploying resource permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessPreviewRequest#builder()}
     * </p>
     *
     * @param createAccessPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAccessPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateAccessPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAccessPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPreviewResponse> createAccessPreview(
            Consumer<CreateAccessPreviewRequest.Builder> createAccessPreviewRequest) {
        return createAccessPreview(CreateAccessPreviewRequest.builder().applyMutation(createAccessPreviewRequest).build());
    }

    /**
     * <p>
     * Creates an analyzer for your account.
     * </p>
     *
     * @param createAnalyzerRequest
     *        Creates an analyzer.
     * @return A Java Future containing the result of the CreateAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnalyzerResponse> createAnalyzer(CreateAnalyzerRequest createAnalyzerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an analyzer for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnalyzerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAnalyzerRequest#builder()}
     * </p>
     *
     * @param createAnalyzerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest.Builder} to create a
     *        request. Creates an analyzer.
     * @return A Java Future containing the result of the CreateAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnalyzerResponse> createAnalyzer(Consumer<CreateAnalyzerRequest.Builder> createAnalyzerRequest) {
        return createAnalyzer(CreateAnalyzerRequest.builder().applyMutation(createAnalyzerRequest).build());
    }

    /**
     * <p>
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet
     * the criteria you define when you create the rule.
     * </p>
     * <p>
     * To learn about filter keys that you can use to create an archive rule, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     *
     * @param createArchiveRuleRequest
     *        Creates an archive rule.
     * @return A Java Future containing the result of the CreateArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateArchiveRuleResponse> createArchiveRule(CreateArchiveRuleRequest createArchiveRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet
     * the criteria you define when you create the rule.
     * </p>
     * <p>
     * To learn about filter keys that you can use to create an archive rule, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArchiveRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateArchiveRuleRequest#builder()}
     * </p>
     *
     * @param createArchiveRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest.Builder} to create a
     *        request. Creates an archive rule.
     * @return A Java Future containing the result of the CreateArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.CreateArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/CreateArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateArchiveRuleResponse> createArchiveRule(
            Consumer<CreateArchiveRuleRequest.Builder> createArchiveRuleRequest) {
        return createArchiveRule(CreateArchiveRuleRequest.builder().applyMutation(createArchiveRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or
     * organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You
     * cannot undo this action.
     * </p>
     *
     * @param deleteAnalyzerRequest
     *        Deletes an analyzer.
     * @return A Java Future containing the result of the DeleteAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.DeleteAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnalyzerResponse> deleteAnalyzer(DeleteAnalyzerRequest deleteAnalyzerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or
     * organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You
     * cannot undo this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnalyzerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAnalyzerRequest#builder()}
     * </p>
     *
     * @param deleteAnalyzerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest.Builder} to create a
     *        request. Deletes an analyzer.
     * @return A Java Future containing the result of the DeleteAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.DeleteAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnalyzerResponse> deleteAnalyzer(Consumer<DeleteAnalyzerRequest.Builder> deleteAnalyzerRequest) {
        return deleteAnalyzer(DeleteAnalyzerRequest.builder().applyMutation(deleteAnalyzerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified archive rule.
     * </p>
     *
     * @param deleteArchiveRuleRequest
     *        Deletes an archive rule.
     * @return A Java Future containing the result of the DeleteArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.DeleteArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteArchiveRuleResponse> deleteArchiveRule(DeleteArchiveRuleRequest deleteArchiveRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified archive rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArchiveRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteArchiveRuleRequest#builder()}
     * </p>
     *
     * @param deleteArchiveRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest.Builder} to create a
     *        request. Deletes an archive rule.
     * @return A Java Future containing the result of the DeleteArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.DeleteArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteArchiveRuleResponse> deleteArchiveRule(
            Consumer<DeleteArchiveRuleRequest.Builder> deleteArchiveRuleRequest) {
        return deleteArchiveRule(DeleteArchiveRuleRequest.builder().applyMutation(deleteArchiveRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an access preview for the specified analyzer.
     * </p>
     *
     * @param getAccessPreviewRequest
     * @return A Java Future containing the result of the GetAccessPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAccessPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAccessPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessPreviewResponse> getAccessPreview(GetAccessPreviewRequest getAccessPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an access preview for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessPreviewRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccessPreviewRequest#builder()}
     * </p>
     *
     * @param getAccessPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccessPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAccessPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAccessPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessPreviewResponse> getAccessPreview(
            Consumer<GetAccessPreviewRequest.Builder> getAccessPreviewRequest) {
        return getAccessPreview(GetAccessPreviewRequest.builder().applyMutation(getAccessPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a resource that was analyzed.
     * </p>
     *
     * @param getAnalyzedResourceRequest
     *        Retrieves an analyzed resource.
     * @return A Java Future containing the result of the GetAnalyzedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAnalyzedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnalyzedResourceResponse> getAnalyzedResource(
            GetAnalyzedResourceRequest getAnalyzedResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a resource that was analyzed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnalyzedResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnalyzedResourceRequest#builder()}
     * </p>
     *
     * @param getAnalyzedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest.Builder} to create
     *        a request. Retrieves an analyzed resource.
     * @return A Java Future containing the result of the GetAnalyzedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAnalyzedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnalyzedResourceResponse> getAnalyzedResource(
            Consumer<GetAnalyzedResourceRequest.Builder> getAnalyzedResourceRequest) {
        return getAnalyzedResource(GetAnalyzedResourceRequest.builder().applyMutation(getAnalyzedResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified analyzer.
     * </p>
     *
     * @param getAnalyzerRequest
     *        Retrieves an analyzer.
     * @return A Java Future containing the result of the GetAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnalyzerResponse> getAnalyzer(GetAnalyzerRequest getAnalyzerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnalyzerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAnalyzerRequest#builder()}
     * </p>
     *
     * @param getAnalyzerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest.Builder} to create a
     *        request. Retrieves an analyzer.
     * @return A Java Future containing the result of the GetAnalyzer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetAnalyzer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnalyzerResponse> getAnalyzer(Consumer<GetAnalyzerRequest.Builder> getAnalyzerRequest) {
        return getAnalyzer(GetAnalyzerRequest.builder().applyMutation(getAnalyzerRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an archive rule.
     * </p>
     * <p>
     * To learn about filter keys that you can use to create an archive rule, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     *
     * @param getArchiveRuleRequest
     *        Retrieves an archive rule.
     * @return A Java Future containing the result of the GetArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveRuleResponse> getArchiveRule(GetArchiveRuleRequest getArchiveRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an archive rule.
     * </p>
     * <p>
     * To learn about filter keys that you can use to create an archive rule, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetArchiveRuleRequest#builder()}
     * </p>
     *
     * @param getArchiveRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest.Builder} to create a
     *        request. Retrieves an archive rule.
     * @return A Java Future containing the result of the GetArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveRuleResponse> getArchiveRule(Consumer<GetArchiveRuleRequest.Builder> getArchiveRuleRequest) {
        return getArchiveRule(GetArchiveRuleRequest.builder().applyMutation(getArchiveRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified finding.
     * </p>
     *
     * @param getFindingRequest
     *        Retrieves a finding.
     * @return A Java Future containing the result of the GetFinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetFinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingResponse> getFinding(GetFindingRequest getFindingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified finding.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingRequest#builder()}
     * </p>
     *
     * @param getFindingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest.Builder} to create a
     *        request. Retrieves a finding.
     * @return A Java Future containing the result of the GetFinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetFinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetFinding" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingResponse> getFinding(Consumer<GetFindingRequest.Builder> getFindingRequest) {
        return getFinding(GetFindingRequest.builder().applyMutation(getFindingRequest).build());
    }

    /**
     * <p>
     * Retrieves the policy that was generated using <code>StartPolicyGeneration</code>.
     * </p>
     *
     * @param getGeneratedPolicyRequest
     * @return A Java Future containing the result of the GetGeneratedPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetGeneratedPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetGeneratedPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedPolicyResponse> getGeneratedPolicy(GetGeneratedPolicyRequest getGeneratedPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the policy that was generated using <code>StartPolicyGeneration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeneratedPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetGeneratedPolicyRequest#builder()}
     * </p>
     *
     * @param getGeneratedPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGeneratedPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.GetGeneratedPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetGeneratedPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGeneratedPolicyResponse> getGeneratedPolicy(
            Consumer<GetGeneratedPolicyRequest.Builder> getGeneratedPolicyRequest) {
        return getGeneratedPolicy(GetGeneratedPolicyRequest.builder().applyMutation(getGeneratedPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of access preview findings generated by the specified access preview.
     * </p>
     *
     * @param listAccessPreviewFindingsRequest
     * @return A Java Future containing the result of the ListAccessPreviewFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviewFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPreviewFindingsResponse> listAccessPreviewFindings(
            ListAccessPreviewFindingsRequest listAccessPreviewFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of access preview findings generated by the specified access preview.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPreviewFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessPreviewFindingsRequest#builder()}
     * </p>
     *
     * @param listAccessPreviewFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessPreviewFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviewFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPreviewFindingsResponse> listAccessPreviewFindings(
            Consumer<ListAccessPreviewFindingsRequest.Builder> listAccessPreviewFindingsRequest) {
        return listAccessPreviewFindings(ListAccessPreviewFindingsRequest.builder()
                .applyMutation(listAccessPreviewFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of access preview findings generated by the specified access preview.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPreviewFindings(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher publisher = client.listAccessPreviewFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher publisher = client.listAccessPreviewFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPreviewFindings(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPreviewFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviewFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPreviewFindingsPublisher listAccessPreviewFindingsPaginator(
            ListAccessPreviewFindingsRequest listAccessPreviewFindingsRequest) {
        return new ListAccessPreviewFindingsPublisher(this, listAccessPreviewFindingsRequest);
    }

    /**
     * <p>
     * Retrieves a list of access preview findings generated by the specified access preview.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPreviewFindings(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher publisher = client.listAccessPreviewFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewFindingsPublisher publisher = client.listAccessPreviewFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPreviewFindings(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPreviewFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessPreviewFindingsRequest#builder()}
     * </p>
     *
     * @param listAccessPreviewFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviewFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviewFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPreviewFindingsPublisher listAccessPreviewFindingsPaginator(
            Consumer<ListAccessPreviewFindingsRequest.Builder> listAccessPreviewFindingsRequest) {
        return listAccessPreviewFindingsPaginator(ListAccessPreviewFindingsRequest.builder()
                .applyMutation(listAccessPreviewFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of access previews for the specified analyzer.
     * </p>
     *
     * @param listAccessPreviewsRequest
     * @return A Java Future containing the result of the ListAccessPreviews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPreviewsResponse> listAccessPreviews(ListAccessPreviewsRequest listAccessPreviewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of access previews for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPreviewsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPreviewsRequest#builder()}
     * </p>
     *
     * @param listAccessPreviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccessPreviews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPreviewsResponse> listAccessPreviews(
            Consumer<ListAccessPreviewsRequest.Builder> listAccessPreviewsRequest) {
        return listAccessPreviews(ListAccessPreviewsRequest.builder().applyMutation(listAccessPreviewsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of access previews for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPreviews(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher publisher = client.listAccessPreviewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher publisher = client.listAccessPreviewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPreviews(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPreviewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPreviewsPublisher listAccessPreviewsPaginator(ListAccessPreviewsRequest listAccessPreviewsRequest) {
        return new ListAccessPreviewsPublisher(this, listAccessPreviewsRequest);
    }

    /**
     * <p>
     * Retrieves a list of access previews for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccessPreviews(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher publisher = client.listAccessPreviewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAccessPreviewsPublisher publisher = client.listAccessPreviewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPreviews(software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPreviewsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPreviewsRequest#builder()}
     * </p>
     *
     * @param listAccessPreviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAccessPreviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAccessPreviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPreviewsPublisher listAccessPreviewsPaginator(
            Consumer<ListAccessPreviewsRequest.Builder> listAccessPreviewsRequest) {
        return listAccessPreviewsPaginator(ListAccessPreviewsRequest.builder().applyMutation(listAccessPreviewsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
     * </p>
     *
     * @param listAnalyzedResourcesRequest
     *        Retrieves a list of resources that have been analyzed.
     * @return A Java Future containing the result of the ListAnalyzedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnalyzedResourcesResponse> listAnalyzedResources(
            ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzedResourcesRequest#builder()}
     * </p>
     *
     * @param listAnalyzedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest.Builder} to
     *        create a request. Retrieves a list of resources that have been analyzed.
     * @return A Java Future containing the result of the ListAnalyzedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnalyzedResourcesResponse> listAnalyzedResources(
            Consumer<ListAnalyzedResourcesRequest.Builder> listAnalyzedResourcesRequest) {
        return listAnalyzedResources(ListAnalyzedResourcesRequest.builder().applyMutation(listAnalyzedResourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzedResources(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher publisher = client.listAnalyzedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher publisher = client.listAnalyzedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzedResources(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnalyzedResourcesRequest
     *        Retrieves a list of resources that have been analyzed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzedResourcesPublisher listAnalyzedResourcesPaginator(
            ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) {
        return new ListAnalyzedResourcesPublisher(this, listAnalyzedResourcesRequest);
    }

    /**
     * <p>
     * Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzedResources(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher publisher = client.listAnalyzedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesPublisher publisher = client.listAnalyzedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzedResources(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalyzedResourcesRequest#builder()}
     * </p>
     *
     * @param listAnalyzedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest.Builder} to
     *        create a request. Retrieves a list of resources that have been analyzed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyzedResourcesPublisher listAnalyzedResourcesPaginator(
            Consumer<ListAnalyzedResourcesRequest.Builder> listAnalyzedResourcesRequest) {
        return listAnalyzedResourcesPaginator(ListAnalyzedResourcesRequest.builder().applyMutation(listAnalyzedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of analyzers.
     * </p>
     *
     * @param listAnalyzersRequest
     *        Retrieves a list of analyzers.
     * @return A Java Future containing the result of the ListAnalyzers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnalyzersResponse> listAnalyzers(ListAnalyzersRequest listAnalyzersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of analyzers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnalyzersRequest#builder()}
     * </p>
     *
     * @param listAnalyzersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest.Builder} to create a
     *        request. Retrieves a list of analyzers.
     * @return A Java Future containing the result of the ListAnalyzers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnalyzersResponse> listAnalyzers(Consumer<ListAnalyzersRequest.Builder> listAnalyzersRequest) {
        return listAnalyzers(ListAnalyzersRequest.builder().applyMutation(listAnalyzersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of analyzers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzers(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher publisher = client.listAnalyzersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher publisher = client.listAnalyzersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzers(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest)} operation.</b>
     * </p>
     *
     * @param listAnalyzersRequest
     *        Retrieves a list of analyzers.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnalyzersPublisher listAnalyzersPaginator(ListAnalyzersRequest listAnalyzersRequest) {
        return new ListAnalyzersPublisher(this, listAnalyzersRequest);
    }

    /**
     * <p>
     * Retrieves a list of analyzers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalyzers(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher publisher = client.listAnalyzersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersPublisher publisher = client.listAnalyzersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyzers(software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyzersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnalyzersRequest#builder()}
     * </p>
     *
     * @param listAnalyzersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest.Builder} to create a
     *        request. Retrieves a list of analyzers.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListAnalyzers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnalyzersPublisher listAnalyzersPaginator(Consumer<ListAnalyzersRequest.Builder> listAnalyzersRequest) {
        return listAnalyzersPaginator(ListAnalyzersRequest.builder().applyMutation(listAnalyzersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of archive rules created for the specified analyzer.
     * </p>
     *
     * @param listArchiveRulesRequest
     *        Retrieves a list of archive rules created for the specified analyzer.
     * @return A Java Future containing the result of the ListArchiveRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListArchiveRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveRulesResponse> listArchiveRules(ListArchiveRulesRequest listArchiveRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of archive rules created for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListArchiveRulesRequest#builder()}
     * </p>
     *
     * @param listArchiveRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest.Builder} to create a
     *        request. Retrieves a list of archive rules created for the specified analyzer.
     * @return A Java Future containing the result of the ListArchiveRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListArchiveRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveRulesResponse> listArchiveRules(
            Consumer<ListArchiveRulesRequest.Builder> listArchiveRulesRequest) {
        return listArchiveRules(ListArchiveRulesRequest.builder().applyMutation(listArchiveRulesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of archive rules created for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArchiveRules(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher publisher = client.listArchiveRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher publisher = client.listArchiveRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveRules(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listArchiveRulesRequest
     *        Retrieves a list of archive rules created for the specified analyzer.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListArchiveRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveRulesPublisher listArchiveRulesPaginator(ListArchiveRulesRequest listArchiveRulesRequest) {
        return new ListArchiveRulesPublisher(this, listArchiveRulesRequest);
    }

    /**
     * <p>
     * Retrieves a list of archive rules created for the specified analyzer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArchiveRules(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher publisher = client.listArchiveRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesPublisher publisher = client.listArchiveRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveRules(software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListArchiveRulesRequest#builder()}
     * </p>
     *
     * @param listArchiveRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest.Builder} to create a
     *        request. Retrieves a list of archive rules created for the specified analyzer.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListArchiveRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListArchiveRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveRulesPublisher listArchiveRulesPaginator(Consumer<ListArchiveRulesRequest.Builder> listArchiveRulesRequest) {
        return listArchiveRulesPaginator(ListArchiveRulesRequest.builder().applyMutation(listArchiveRulesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of findings generated by the specified analyzer.
     * </p>
     * <p>
     * To learn about filter keys that you can use to retrieve a list of findings, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     *
     * @param listFindingsRequest
     *        Retrieves a list of findings generated by the specified analyzer.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of findings generated by the specified analyzer.
     * </p>
     * <p>
     * To learn about filter keys that you can use to retrieve a list of findings, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest.Builder} to create a
     *        request. Retrieves a list of findings generated by the specified analyzer.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of findings generated by the specified analyzer.
     * </p>
     * <p>
     * To learn about filter keys that you can use to retrieve a list of findings, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindings(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     *        Retrieves a list of findings generated by the specified analyzer.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, listFindingsRequest);
    }

    /**
     * <p>
     * Retrieves a list of findings generated by the specified analyzer.
     * </p>
     * <p>
     * To learn about filter keys that you can use to retrieve a list of findings, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
     * Analyzer filter keys</a> in the <b>IAM User Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindings(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest.Builder} to create a
     *        request. Retrieves a list of findings generated by the specified analyzer.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists all of the policy generations requested in the last seven days.
     * </p>
     *
     * @param listPolicyGenerationsRequest
     * @return A Java Future containing the result of the ListPolicyGenerations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListPolicyGenerations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPolicyGenerationsResponse> listPolicyGenerations(
            ListPolicyGenerationsRequest listPolicyGenerationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the policy generations requested in the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGenerationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyGenerationsRequest#builder()}
     * </p>
     *
     * @param listPolicyGenerationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPolicyGenerations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListPolicyGenerations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPolicyGenerationsResponse> listPolicyGenerations(
            Consumer<ListPolicyGenerationsRequest.Builder> listPolicyGenerationsRequest) {
        return listPolicyGenerations(ListPolicyGenerationsRequest.builder().applyMutation(listPolicyGenerationsRequest).build());
    }

    /**
     * <p>
     * Lists all of the policy generations requested in the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyGenerations(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher publisher = client.listPolicyGenerationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher publisher = client.listPolicyGenerationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGenerations(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPolicyGenerationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListPolicyGenerations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPolicyGenerationsPublisher listPolicyGenerationsPaginator(
            ListPolicyGenerationsRequest listPolicyGenerationsRequest) {
        return new ListPolicyGenerationsPublisher(this, listPolicyGenerationsRequest);
    }

    /**
     * <p>
     * Lists all of the policy generations requested in the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyGenerations(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher publisher = client.listPolicyGenerationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ListPolicyGenerationsPublisher publisher = client.listPolicyGenerationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyGenerations(software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyGenerationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyGenerationsRequest#builder()}
     * </p>
     *
     * @param listPolicyGenerationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListPolicyGenerations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListPolicyGenerations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPolicyGenerationsPublisher listPolicyGenerationsPaginator(
            Consumer<ListPolicyGenerationsRequest.Builder> listPolicyGenerationsRequest) {
        return listPolicyGenerationsPaginator(ListPolicyGenerationsRequest.builder().applyMutation(listPolicyGenerationsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of tags applied to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        Retrieves a list of tags applied to the specified resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags applied to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceRequest.Builder} to create
     *        a request. Retrieves a list of tags applied to the specified resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the policy generation request.
     * </p>
     *
     * @param startPolicyGenerationRequest
     * @return A Java Future containing the result of the StartPolicyGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.StartPolicyGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartPolicyGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPolicyGenerationResponse> startPolicyGeneration(
            StartPolicyGenerationRequest startPolicyGenerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the policy generation request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPolicyGenerationRequest.Builder} avoiding the
     * need to create one manually via {@link StartPolicyGenerationRequest#builder()}
     * </p>
     *
     * @param startPolicyGenerationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartPolicyGeneration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception error.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Service quote met error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.StartPolicyGeneration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartPolicyGeneration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPolicyGenerationResponse> startPolicyGeneration(
            Consumer<StartPolicyGenerationRequest.Builder> startPolicyGenerationRequest) {
        return startPolicyGeneration(StartPolicyGenerationRequest.builder().applyMutation(startPolicyGenerationRequest).build());
    }

    /**
     * <p>
     * Immediately starts a scan of the policies applied to the specified resource.
     * </p>
     *
     * @param startResourceScanRequest
     *        Starts a scan of the policies applied to the specified resource.
     * @return A Java Future containing the result of the StartResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.StartResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartResourceScanResponse> startResourceScan(StartResourceScanRequest startResourceScanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Immediately starts a scan of the policies applied to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartResourceScanRequest.Builder} avoiding the need
     * to create one manually via {@link StartResourceScanRequest#builder()}
     * </p>
     *
     * @param startResourceScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest.Builder} to create a
     *        request. Starts a scan of the policies applied to the specified resource.
     * @return A Java Future containing the result of the StartResourceScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.StartResourceScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/StartResourceScan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartResourceScanResponse> startResourceScan(
            Consumer<StartResourceScanRequest.Builder> startResourceScanRequest) {
        return startResourceScan(StartResourceScanRequest.builder().applyMutation(startResourceScanRequest).build());
    }

    /**
     * <p>
     * Adds a tag to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds a tag to the specified resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest.Builder} to create a
     *        request. Adds a tag to the specified resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from the specified resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.UntagResourceRequest.Builder} to create a
     *        request. Removes a tag from the specified resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the criteria and values for the specified archive rule.
     * </p>
     *
     * @param updateArchiveRuleRequest
     *        Updates the specified archive rule.
     * @return A Java Future containing the result of the UpdateArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UpdateArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateArchiveRuleResponse> updateArchiveRule(UpdateArchiveRuleRequest updateArchiveRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the criteria and values for the specified archive rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateArchiveRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateArchiveRuleRequest#builder()}
     * </p>
     *
     * @param updateArchiveRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest.Builder} to create a
     *        request. Updates the specified archive rule.
     * @return A Java Future containing the result of the UpdateArchiveRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UpdateArchiveRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateArchiveRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateArchiveRuleResponse> updateArchiveRule(
            Consumer<UpdateArchiveRuleRequest.Builder> updateArchiveRuleRequest) {
        return updateArchiveRule(UpdateArchiveRuleRequest.builder().applyMutation(updateArchiveRuleRequest).build());
    }

    /**
     * <p>
     * Updates the status for the specified findings.
     * </p>
     *
     * @param updateFindingsRequest
     *        Updates findings with the new values provided in the request.
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(UpdateFindingsRequest updateFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status for the specified findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFindingsRequest#builder()}
     * </p>
     *
     * @param updateFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest.Builder} to create a
     *        request. Updates findings with the new values provided in the request.
     * @return A Java Future containing the result of the UpdateFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsResponse> updateFindings(Consumer<UpdateFindingsRequest.Builder> updateFindingsRequest) {
        return updateFindings(UpdateFindingsRequest.builder().applyMutation(updateFindingsRequest).build());
    }

    /**
     * <p>
     * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and
     * provide actionable recommendations to resolve the issue and enable you to author functional policies that meet
     * security best practices.
     * </p>
     *
     * @param validatePolicyRequest
     * @return A Java Future containing the result of the ValidatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ValidatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ValidatePolicyResponse> validatePolicy(ValidatePolicyRequest validatePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and
     * provide actionable recommendations to resolve the issue and enable you to author functional policies that meet
     * security best practices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link ValidatePolicyRequest#builder()}
     * </p>
     *
     * @param validatePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ValidatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ValidatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ValidatePolicyResponse> validatePolicy(Consumer<ValidatePolicyRequest.Builder> validatePolicyRequest) {
        return validatePolicy(ValidatePolicyRequest.builder().applyMutation(validatePolicyRequest).build());
    }

    /**
     * <p>
     * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and
     * provide actionable recommendations to resolve the issue and enable you to author functional policies that meet
     * security best practices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #validatePolicy(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher publisher = client.validatePolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher publisher = client.validatePolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #validatePolicy(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param validatePolicyRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ValidatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default ValidatePolicyPublisher validatePolicyPaginator(ValidatePolicyRequest validatePolicyRequest) {
        return new ValidatePolicyPublisher(this, validatePolicyRequest);
    }

    /**
     * <p>
     * Requests the validation of a policy and returns a list of findings. The findings help you identify issues and
     * provide actionable recommendations to resolve the issue and enable you to author functional policies that meet
     * security best practices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #validatePolicy(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher publisher = client.validatePolicyPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.accessanalyzer.paginators.ValidatePolicyPublisher publisher = client.validatePolicyPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #validatePolicy(software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link ValidatePolicyRequest#builder()}
     * </p>
     *
     * @param validatePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validation exception error.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ThrottlingException Throttling limit exceeded error.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccessAnalyzerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AccessAnalyzerAsyncClient.ValidatePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ValidatePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default ValidatePolicyPublisher validatePolicyPaginator(Consumer<ValidatePolicyRequest.Builder> validatePolicyRequest) {
        return validatePolicyPaginator(ValidatePolicyRequest.builder().applyMutation(validatePolicyRequest).build());
    }

    @Override
    default AccessAnalyzerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AccessAnalyzerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AccessAnalyzerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AccessAnalyzerAsyncClient}.
     */
    static AccessAnalyzerAsyncClientBuilder builder() {
        return new DefaultAccessAnalyzerAsyncClientBuilder();
    }
}
