/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an unused access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedAccessConfiguration.Builder, UnusedAccessConfiguration> {
    private static final SdkField<Integer> UNUSED_ACCESS_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unusedAccessAge").getter(getter(UnusedAccessConfiguration::unusedAccessAge))
            .setter(setter(Builder::unusedAccessAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessAge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNUSED_ACCESS_AGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer unusedAccessAge;

    private UnusedAccessConfiguration(BuilderImpl builder) {
        this.unusedAccessAge = builder.unusedAccessAge;
    }

    /**
     * <p>
     * The specified access age in days for which to generate findings for unused access. For example, if you specify 90
     * days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for
     * any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value
     * between 1 and 180 days.
     * </p>
     * 
     * @return The specified access age in days for which to generate findings for unused access. For example, if you
     *         specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected
     *         organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You
     *         can choose a value between 1 and 180 days.
     */
    public final Integer unusedAccessAge() {
        return unusedAccessAge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccessAge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedAccessConfiguration)) {
            return false;
        }
        UnusedAccessConfiguration other = (UnusedAccessConfiguration) obj;
        return Objects.equals(unusedAccessAge(), other.unusedAccessAge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedAccessConfiguration").add("UnusedAccessAge", unusedAccessAge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unusedAccessAge":
            return Optional.ofNullable(clazz.cast(unusedAccessAge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnusedAccessConfiguration, T> g) {
        return obj -> g.apply((UnusedAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedAccessConfiguration> {
        /**
         * <p>
         * The specified access age in days for which to generate findings for unused access. For example, if you
         * specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected
         * organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can
         * choose a value between 1 and 180 days.
         * </p>
         * 
         * @param unusedAccessAge
         *        The specified access age in days for which to generate findings for unused access. For example, if you
         *        specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the
         *        selected organization for any access that hasn't been used in 90 or more days since the analyzer's
         *        last scan. You can choose a value between 1 and 180 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccessAge(Integer unusedAccessAge);
    }

    static final class BuilderImpl implements Builder {
        private Integer unusedAccessAge;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedAccessConfiguration model) {
            unusedAccessAge(model.unusedAccessAge);
        }

        public final Integer getUnusedAccessAge() {
            return unusedAccessAge;
        }

        public final void setUnusedAccessAge(Integer unusedAccessAge) {
            this.unusedAccessAge = unusedAccessAge;
        }

        @Override
        public final Builder unusedAccessAge(Integer unusedAccessAge) {
            this.unusedAccessAge = unusedAccessAge;
            return this;
        }

        @Override
        public UnusedAccessConfiguration build() {
            return new UnusedAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
