/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an unused access finding for an action. IAM Access Analyzer charges for unused access
 * analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see <a
 * href="https://aws.amazon.com/iam/access-analyzer/pricing">IAM Access Analyzer pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedAction implements SdkPojo, Serializable, ToCopyableBuilder<UnusedAction.Builder, UnusedAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UnusedAction::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAccessed")
            .getter(getter(UnusedAction::lastAccessed))
            .setter(setter(Builder::lastAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccessed").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            LAST_ACCESSED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Instant lastAccessed;

    private UnusedAction(BuilderImpl builder) {
        this.action = builder.action;
        this.lastAccessed = builder.lastAccessed;
    }

    /**
     * <p>
     * The action for which the unused access finding was generated.
     * </p>
     * 
     * @return The action for which the unused access finding was generated.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The time at which the action was last accessed.
     * </p>
     * 
     * @return The time at which the action was last accessed.
     */
    public final Instant lastAccessed() {
        return lastAccessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedAction)) {
            return false;
        }
        UnusedAction other = (UnusedAction) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(lastAccessed(), other.lastAccessed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedAction").add("Action", action()).add("LastAccessed", lastAccessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "lastAccessed":
            return Optional.ofNullable(clazz.cast(lastAccessed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnusedAction, T> g) {
        return obj -> g.apply((UnusedAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedAction> {
        /**
         * <p>
         * The action for which the unused access finding was generated.
         * </p>
         * 
         * @param action
         *        The action for which the unused access finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The time at which the action was last accessed.
         * </p>
         * 
         * @param lastAccessed
         *        The time at which the action was last accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessed(Instant lastAccessed);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Instant lastAccessed;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedAction model) {
            action(model.action);
            lastAccessed(model.lastAccessed);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Instant getLastAccessed() {
            return lastAccessed;
        }

        public final void setLastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public final Builder lastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        @Override
        public UnusedAction build() {
            return new UnusedAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
