/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates an analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnalyzerRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<CreateAnalyzerRequest.Builder, CreateAnalyzerRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerName").getter(getter(CreateAnalyzerRequest::analyzerName)).setter(setter(Builder::analyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateAnalyzerRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<InlineArchiveRule>> ARCHIVE_RULES_FIELD = SdkField
            .<List<InlineArchiveRule>> builder(MarshallingType.LIST)
            .memberName("archiveRules")
            .getter(getter(CreateAnalyzerRequest::archiveRules))
            .setter(setter(Builder::archiveRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InlineArchiveRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(InlineArchiveRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAnalyzerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAnalyzerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AnalyzerConfiguration> CONFIGURATION_FIELD = SdkField
            .<AnalyzerConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateAnalyzerRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AnalyzerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD,
            TYPE_FIELD, ARCHIVE_RULES_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD));

    private final String analyzerName;

    private final String type;

    private final List<InlineArchiveRule> archiveRules;

    private final Map<String, String> tags;

    private final String clientToken;

    private final AnalyzerConfiguration configuration;

    private CreateAnalyzerRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.type = builder.type;
        this.archiveRules = builder.archiveRules;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The name of the analyzer to create.
     * </p>
     * 
     * @return The name of the analyzer to create.
     */
    public final String analyzerName() {
        return analyzerName;
    }

    /**
     * <p>
     * The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
     * <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported. You can
     * create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
     *         <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported.
     *         You can create only one analyzer per account per Region. You can create up to 5 analyzers per
     *         organization per Region.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
     * <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported. You can
     * create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
     *         <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported.
     *         You can create only one analyzer per account per Region. You can create up to 5 analyzers per
     *         organization per Region.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArchiveRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchiveRules() {
        return archiveRules != null && !(archiveRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the
     * criteria you define for the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchiveRules} method.
     * </p>
     * 
     * @return Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
     *         meet the criteria you define for the rule.
     */
    public final List<InlineArchiveRule> archiveRules() {
        return archiveRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of key-value pairs to apply to the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to apply to the analyzer.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified scope of
     * unused access is used for the configuration. If the analyzer is an external access analyzer, this field is not
     * used.
     * </p>
     * 
     * @return Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified
     *         scope of unused access is used for the configuration. If the analyzer is an external access analyzer,
     *         this field is not used.
     */
    public final AnalyzerConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchiveRules() ? archiveRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalyzerRequest)) {
            return false;
        }
        CreateAnalyzerRequest other = (CreateAnalyzerRequest) obj;
        return Objects.equals(analyzerName(), other.analyzerName()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasArchiveRules() == other.hasArchiveRules() && Objects.equals(archiveRules(), other.archiveRules())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnalyzerRequest").add("AnalyzerName", analyzerName()).add("Type", typeAsString())
                .add("ArchiveRules", hasArchiveRules() ? archiveRules() : null).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerName":
            return Optional.ofNullable(clazz.cast(analyzerName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "archiveRules":
            return Optional.ofNullable(clazz.cast(archiveRules()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalyzerRequest, T> g) {
        return obj -> g.apply((CreateAnalyzerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnalyzerRequest> {
        /**
         * <p>
         * The name of the analyzer to create.
         * </p>
         * 
         * @param analyzerName
         *        The name of the analyzer to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerName(String analyzerName);

        /**
         * <p>
         * The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
         * <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported. You
         * can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per
         * Region.
         * </p>
         * 
         * @param type
         *        The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
         *        <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are
         *        supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers
         *        per organization per Region.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
         * <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are supported. You
         * can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per
         * Region.
         * </p>
         * 
         * @param type
         *        The type of analyzer to create. Only <code>ACCOUNT</code>, <code>ORGANIZATION</code>,
         *        <code>ACCOUNT_UNUSED_ACCESS</code>, and <code>ORGANIZTAION_UNUSED_ACCESS</code> analyzers are
         *        supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers
         *        per organization per Region.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * 
         * @param archiveRules
         *        Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
         *        meet the criteria you define for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(Collection<InlineArchiveRule> archiveRules);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * 
         * @param archiveRules
         *        Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that
         *        meet the criteria you define for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(InlineArchiveRule... archiveRules);

        /**
         * <p>
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet
         * the criteria you define for the rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule.Builder#build()} is called
         * immediately and its result is passed to {@link #archiveRules(List<InlineArchiveRule>)}.
         * 
         * @param archiveRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveRules(java.util.Collection<InlineArchiveRule>)
         */
        Builder archiveRules(Consumer<InlineArchiveRule.Builder>... archiveRules);

        /**
         * <p>
         * An array of key-value pairs to apply to the analyzer.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified
         * scope of unused access is used for the configuration. If the analyzer is an external access analyzer, this
         * field is not used.
         * </p>
         * 
         * @param configuration
         *        Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the
         *        specified scope of unused access is used for the configuration. If the analyzer is an external access
         *        analyzer, this field is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AnalyzerConfiguration configuration);

        /**
         * <p>
         * Specifies the configuration of the analyzer. If the analyzer is an unused access analyzer, the specified
         * scope of unused access is used for the configuration. If the analyzer is an external access analyzer, this
         * field is not used.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalyzerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AnalyzerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalyzerConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(AnalyzerConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AnalyzerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AnalyzerConfiguration)
         */
        default Builder configuration(Consumer<AnalyzerConfiguration.Builder> configuration) {
            return configuration(AnalyzerConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerName;

        private String type;

        private List<InlineArchiveRule> archiveRules = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private AnalyzerConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalyzerRequest model) {
            super(model);
            analyzerName(model.analyzerName);
            type(model.type);
            archiveRules(model.archiveRules);
            tags(model.tags);
            clientToken(model.clientToken);
            configuration(model.configuration);
        }

        public final String getAnalyzerName() {
            return analyzerName;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<InlineArchiveRule.Builder> getArchiveRules() {
            List<InlineArchiveRule.Builder> result = InlineArchiveRulesListCopier.copyToBuilder(this.archiveRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchiveRules(Collection<InlineArchiveRule.BuilderImpl> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        @Override
        public final Builder archiveRules(Collection<InlineArchiveRule> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(InlineArchiveRule... archiveRules) {
            archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(Consumer<InlineArchiveRule.Builder>... archiveRules) {
            archiveRules(Stream.of(archiveRules).map(c -> InlineArchiveRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AnalyzerConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnalyzerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnalyzerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalyzerRequest build() {
            return new CreateAnalyzerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
