/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckAccessNotGrantedResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<CheckAccessNotGrantedResponse.Builder, CheckAccessNotGrantedResponse> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(CheckAccessNotGrantedResponse::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(CheckAccessNotGrantedResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<List<ReasonSummary>> REASONS_FIELD = SdkField
            .<List<ReasonSummary>> builder(MarshallingType.LIST)
            .memberName("reasons")
            .getter(getter(CheckAccessNotGrantedResponse::reasons))
            .setter(setter(Builder::reasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReasonSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReasonSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, MESSAGE_FIELD,
            REASONS_FIELD));

    private final String result;

    private final String message;

    private final List<ReasonSummary> reasons;

    private CheckAccessNotGrantedResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
        this.message = builder.message;
        this.reasons = builder.reasons;
    }

    /**
     * <p>
     * The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the specified
     * policy doesn't allow any of the specified permissions in the access object. If the result is <code>FAIL</code>,
     * the specified policy might allow some or all of the permissions in the access object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link CheckAccessNotGrantedResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultAsString}.
     * </p>
     * 
     * @return The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the
     *         specified policy doesn't allow any of the specified permissions in the access object. If the result is
     *         <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access object.
     * @see CheckAccessNotGrantedResult
     */
    public final CheckAccessNotGrantedResult result() {
        return CheckAccessNotGrantedResult.fromValue(result);
    }

    /**
     * <p>
     * The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the specified
     * policy doesn't allow any of the specified permissions in the access object. If the result is <code>FAIL</code>,
     * the specified policy might allow some or all of the permissions in the access object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link CheckAccessNotGrantedResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultAsString}.
     * </p>
     * 
     * @return The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the
     *         specified policy doesn't allow any of the specified permissions in the access object. If the result is
     *         <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access object.
     * @see CheckAccessNotGrantedResult
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The message indicating whether the specified access is allowed.
     * </p>
     * 
     * @return The message indicating whether the specified access is allowed.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of the reasoning of the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return A description of the reasoning of the result.
     */
    public final List<ReasonSummary> reasons() {
        return reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckAccessNotGrantedResponse)) {
            return false;
        }
        CheckAccessNotGrantedResponse other = (CheckAccessNotGrantedResponse) obj;
        return Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(message(), other.message())
                && hasReasons() == other.hasReasons() && Objects.equals(reasons(), other.reasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckAccessNotGrantedResponse").add("Result", resultAsString()).add("Message", message())
                .add("Reasons", hasReasons() ? reasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "reasons":
            return Optional.ofNullable(clazz.cast(reasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckAccessNotGrantedResponse, T> g) {
        return obj -> g.apply((CheckAccessNotGrantedResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckAccessNotGrantedResponse> {
        /**
         * <p>
         * The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the specified
         * policy doesn't allow any of the specified permissions in the access object. If the result is
         * <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access object.
         * </p>
         * 
         * @param result
         *        The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the
         *        specified policy doesn't allow any of the specified permissions in the access object. If the result is
         *        <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access
         *        object.
         * @see CheckAccessNotGrantedResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckAccessNotGrantedResult
         */
        Builder result(String result);

        /**
         * <p>
         * The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the specified
         * policy doesn't allow any of the specified permissions in the access object. If the result is
         * <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access object.
         * </p>
         * 
         * @param result
         *        The result of the check for whether the access is allowed. If the result is <code>PASS</code>, the
         *        specified policy doesn't allow any of the specified permissions in the access object. If the result is
         *        <code>FAIL</code>, the specified policy might allow some or all of the permissions in the access
         *        object.
         * @see CheckAccessNotGrantedResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CheckAccessNotGrantedResult
         */
        Builder result(CheckAccessNotGrantedResult result);

        /**
         * <p>
         * The message indicating whether the specified access is allowed.
         * </p>
         * 
         * @param message
         *        The message indicating whether the specified access is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A description of the reasoning of the result.
         * </p>
         * 
         * @param reasons
         *        A description of the reasoning of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<ReasonSummary> reasons);

        /**
         * <p>
         * A description of the reasoning of the result.
         * </p>
         * 
         * @param reasons
         *        A description of the reasoning of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(ReasonSummary... reasons);

        /**
         * <p>
         * A description of the reasoning of the result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.ReasonSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.accessanalyzer.model.ReasonSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.ReasonSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #reasons(List<ReasonSummary>)}.
         * 
         * @param reasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.ReasonSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasons(java.util.Collection<ReasonSummary>)
         */
        Builder reasons(Consumer<ReasonSummary.Builder>... reasons);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private String result;

        private String message;

        private List<ReasonSummary> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckAccessNotGrantedResponse model) {
            super(model);
            result(model.result);
            message(model.message);
            reasons(model.reasons);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(CheckAccessNotGrantedResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<ReasonSummary.Builder> getReasons() {
            List<ReasonSummary.Builder> result = ReasonSummaryListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<ReasonSummary.BuilderImpl> reasons) {
            this.reasons = ReasonSummaryListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<ReasonSummary> reasons) {
            this.reasons = ReasonSummaryListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(ReasonSummary... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<ReasonSummary.Builder>... reasons) {
            reasons(Stream.of(reasons).map(c -> ReasonSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CheckAccessNotGrantedResponse build() {
            return new CheckAccessNotGrantedResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
