/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CheckAccessNotGrantedRequestAccessListCopier {
    static List<Access> copy(Collection<? extends Access> checkAccessNotGrantedRequestAccessListParam) {
        List<Access> list;
        if (checkAccessNotGrantedRequestAccessListParam == null
                || checkAccessNotGrantedRequestAccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Access> modifiableList = new ArrayList<>();
            checkAccessNotGrantedRequestAccessListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Access> copyFromBuilder(Collection<? extends Access.Builder> checkAccessNotGrantedRequestAccessListParam) {
        List<Access> list;
        if (checkAccessNotGrantedRequestAccessListParam == null
                || checkAccessNotGrantedRequestAccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Access> modifiableList = new ArrayList<>();
            checkAccessNotGrantedRequestAccessListParam.forEach(entry -> {
                Access member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Access.Builder> copyToBuilder(Collection<? extends Access> checkAccessNotGrantedRequestAccessListParam) {
        List<Access.Builder> list;
        if (checkAccessNotGrantedRequestAccessListParam == null
                || checkAccessNotGrantedRequestAccessListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Access.Builder> modifiableList = new ArrayList<>();
            checkAccessNotGrantedRequestAccessListParam.forEach(entry -> {
                Access.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
