/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingV2Response extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetFindingV2Response.Builder, GetFindingV2Response> {
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("analyzedAt")
            .getter(getter(GetFindingV2Response::analyzedAt))
            .setter(setter(Builder::analyzedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetFindingV2Response::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(GetFindingV2Response::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetFindingV2Response::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetFindingV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(GetFindingV2Response::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetFindingV2Response::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwnerAccount").getter(getter(GetFindingV2Response::resourceOwnerAccount))
            .setter(setter(Builder::resourceOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFindingV2Response::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetFindingV2Response::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<FindingDetails>> FINDING_DETAILS_FIELD = SdkField
            .<List<FindingDetails>> builder(MarshallingType.LIST)
            .memberName("findingDetails")
            .getter(getter(GetFindingV2Response::findingDetails))
            .setter(setter(Builder::findingDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingType").getter(getter(GetFindingV2Response::findingTypeAsString))
            .setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_AT_FIELD,
            CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, NEXT_TOKEN_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD,
            RESOURCE_OWNER_ACCOUNT_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, FINDING_DETAILS_FIELD, FINDING_TYPE_FIELD));

    private final Instant analyzedAt;

    private final Instant createdAt;

    private final String error;

    private final String id;

    private final String nextToken;

    private final String resource;

    private final String resourceType;

    private final String resourceOwnerAccount;

    private final String status;

    private final Instant updatedAt;

    private final List<FindingDetails> findingDetails;

    private final String findingType;

    private GetFindingV2Response(BuilderImpl builder) {
        super(builder);
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.nextToken = builder.nextToken;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.findingDetails = builder.findingDetails;
        this.findingType = builder.findingType;
    }

    /**
     * <p>
     * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     * </p>
     * 
     * @return The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     */
    public final Instant analyzedAt() {
        return analyzedAt;
    }

    /**
     * <p>
     * The time at which the finding was created.
     * </p>
     * 
     * @return The time at which the finding was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An error.
     * </p>
     * 
     * @return An error.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The ID of the finding to retrieve.
     * </p>
     * 
     * @return The ID of the finding to retrieve.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The resource that generated the finding.
     * </p>
     * 
     * @return The resource that generated the finding.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The type of the resource identified in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource identified in the finding.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource identified in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource identified in the finding.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Tye Amazon Web Services account ID that owns the resource.
     * </p>
     * 
     * @return Tye Amazon Web Services account ID that owns the resource.
     */
    public final String resourceOwnerAccount() {
        return resourceOwnerAccount;
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the finding was updated.
     * </p>
     * 
     * @return The time at which the finding was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingDetails() {
        return findingDetails != null && !(findingDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A localized message that explains the finding and provides guidance on how to address it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingDetails} method.
     * </p>
     * 
     * @return A localized message that explains the finding and provides guidance on how to address it.
     */
    public final List<FindingDetails> findingDetails() {
        return findingDetails;
    }

    /**
     * <p>
     * The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For unused
     * access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
     *         unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     *         <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
     * @see FindingType
     */
    public final FindingType findingType() {
        return FindingType.fromValue(findingType);
    }

    /**
     * <p>
     * The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For unused
     * access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
     *         unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     *         <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
     * @see FindingType
     */
    public final String findingTypeAsString() {
        return findingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingDetails() ? findingDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingV2Response)) {
            return false;
        }
        GetFindingV2Response other = (GetFindingV2Response) obj;
        return Objects.equals(analyzedAt(), other.analyzedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(error(), other.error()) && Objects.equals(id(), other.id())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(resource(), other.resource())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceOwnerAccount(), other.resourceOwnerAccount())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasFindingDetails() == other.hasFindingDetails() && Objects.equals(findingDetails(), other.findingDetails())
                && Objects.equals(findingTypeAsString(), other.findingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingV2Response").add("AnalyzedAt", analyzedAt()).add("CreatedAt", createdAt())
                .add("Error", error()).add("Id", id()).add("NextToken", nextToken()).add("Resource", resource())
                .add("ResourceType", resourceTypeAsString()).add("ResourceOwnerAccount", resourceOwnerAccount())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .add("FindingDetails", hasFindingDetails() ? findingDetails() : null).add("FindingType", findingTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzedAt":
            return Optional.ofNullable(clazz.cast(analyzedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceOwnerAccount":
            return Optional.ofNullable(clazz.cast(resourceOwnerAccount()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "findingDetails":
            return Optional.ofNullable(clazz.cast(findingDetails()));
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingV2Response, T> g) {
        return obj -> g.apply((GetFindingV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingV2Response> {
        /**
         * <p>
         * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         * </p>
         * 
         * @param analyzedAt
         *        The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedAt(Instant analyzedAt);

        /**
         * <p>
         * The time at which the finding was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An error.
         * </p>
         * 
         * @param error
         *        An error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The ID of the finding to retrieve.
         * </p>
         * 
         * @param id
         *        The ID of the finding to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The resource that generated the finding.
         * </p>
         * 
         * @param resource
         *        The resource that generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The type of the resource identified in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource identified in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource identified in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource identified in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Tye Amazon Web Services account ID that owns the resource.
         * </p>
         * 
         * @param resourceOwnerAccount
         *        Tye Amazon Web Services account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerAccount(String resourceOwnerAccount);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);

        /**
         * <p>
         * The time at which the finding was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the finding was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A localized message that explains the finding and provides guidance on how to address it.
         * </p>
         * 
         * @param findingDetails
         *        A localized message that explains the finding and provides guidance on how to address it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDetails(Collection<FindingDetails> findingDetails);

        /**
         * <p>
         * A localized message that explains the finding and provides guidance on how to address it.
         * </p>
         * 
         * @param findingDetails
         *        A localized message that explains the finding and provides guidance on how to address it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingDetails(FindingDetails... findingDetails);

        /**
         * <p>
         * A localized message that explains the finding and provides guidance on how to address it.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingDetails.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.accessanalyzer.model.FindingDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #findingDetails(List<FindingDetails>)}.
         * 
         * @param findingDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.FindingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingDetails(java.util.Collection<FindingDetails>)
         */
        Builder findingDetails(Consumer<FindingDetails.Builder>... findingDetails);

        /**
         * <p>
         * The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For unused
         * access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
         * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
         * </p>
         * 
         * @param findingType
         *        The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
         *        unused access analyzers, the type can be <code>UnusedIAMRole</code>,
         *        <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or
         *        <code>UnusedPermission</code>.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For unused
         * access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
         * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>.
         * </p>
         * 
         * @param findingType
         *        The type of the finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
         *        unused access analyzers, the type can be <code>UnusedIAMRole</code>,
         *        <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or
         *        <code>UnusedPermission</code>.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder findingType(FindingType findingType);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private Instant analyzedAt;

        private Instant createdAt;

        private String error;

        private String id;

        private String nextToken;

        private String resource;

        private String resourceType;

        private String resourceOwnerAccount;

        private String status;

        private Instant updatedAt;

        private List<FindingDetails> findingDetails = DefaultSdkAutoConstructList.getInstance();

        private String findingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingV2Response model) {
            super(model);
            analyzedAt(model.analyzedAt);
            createdAt(model.createdAt);
            error(model.error);
            id(model.id);
            nextToken(model.nextToken);
            resource(model.resource);
            resourceType(model.resourceType);
            resourceOwnerAccount(model.resourceOwnerAccount);
            status(model.status);
            updatedAt(model.updatedAt);
            findingDetails(model.findingDetails);
            findingType(model.findingType);
        }

        public final Instant getAnalyzedAt() {
            return analyzedAt;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<FindingDetails.Builder> getFindingDetails() {
            List<FindingDetails.Builder> result = FindingDetailsListCopier.copyToBuilder(this.findingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingDetails(Collection<FindingDetails.BuilderImpl> findingDetails) {
            this.findingDetails = FindingDetailsListCopier.copyFromBuilder(findingDetails);
        }

        @Override
        public final Builder findingDetails(Collection<FindingDetails> findingDetails) {
            this.findingDetails = FindingDetailsListCopier.copy(findingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(FindingDetails... findingDetails) {
            findingDetails(Arrays.asList(findingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(Consumer<FindingDetails.Builder>... findingDetails) {
            findingDetails(Stream.of(findingDetails).map(c -> FindingDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(FindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        @Override
        public GetFindingV2Response build() {
            return new GetFindingV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
