/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AccessCheckResourceType {
    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),

    AWS_DYNAMO_DB_STREAM("AWS::DynamoDB::Stream"),

    AWS_EFS_FILE_SYSTEM("AWS::EFS::FileSystem"),

    AWS_OPEN_SEARCH_SERVICE_DOMAIN("AWS::OpenSearchService::Domain"),

    AWS_KINESIS_STREAM("AWS::Kinesis::Stream"),

    AWS_KINESIS_STREAM_CONSUMER("AWS::Kinesis::StreamConsumer"),

    AWS_KMS_KEY("AWS::KMS::Key"),

    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),

    AWS_S3_BUCKET("AWS::S3::Bucket"),

    AWS_S3_ACCESS_POINT("AWS::S3::AccessPoint"),

    AWS_S3_EXPRESS_DIRECTORY_BUCKET("AWS::S3Express::DirectoryBucket"),

    AWS_S3_GLACIER("AWS::S3::Glacier"),

    AWS_S3_OUTPOSTS_BUCKET("AWS::S3Outposts::Bucket"),

    AWS_S3_OUTPOSTS_ACCESS_POINT("AWS::S3Outposts::AccessPoint"),

    AWS_SECRETS_MANAGER_SECRET("AWS::SecretsManager::Secret"),

    AWS_SNS_TOPIC("AWS::SNS::Topic"),

    AWS_SQS_QUEUE("AWS::SQS::Queue"),

    AWS_IAM_ASSUME_ROLE_POLICY_DOCUMENT("AWS::IAM::AssumeRolePolicyDocument"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessCheckResourceType> VALUE_MAP = EnumUtils.uniqueIndex(AccessCheckResourceType.class,
            AccessCheckResourceType::toString);

    private final String value;

    private AccessCheckResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AccessCheckResourceType corresponding to the value
     */
    public static AccessCheckResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AccessCheckResourceType}s
     */
    public static Set<AccessCheckResourceType> knownValues() {
        Set<AccessCheckResourceType> knownValues = EnumSet.allOf(AccessCheckResourceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
