/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proposed access control configuration for an Amazon S3 directory bucket. You can propose a configuration for a new
 * Amazon S3 directory bucket or an existing Amazon S3 directory bucket that you own by specifying the Amazon S3 bucket
 * policy. If the configuration is for an existing Amazon S3 directory bucket and you do not specify the Amazon S3
 * bucket policy, the access preview uses the existing policy attached to the directory bucket. If the access preview is
 * for a new resource and you do not specify the Amazon S3 bucket policy, the access preview assumes an directory bucket
 * without a policy. To propose deletion of an existing bucket policy, you can specify an empty string. For more
 * information about Amazon S3 directory bucket policies, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html"
 * >Example directory bucket policies for S3 Express One Zone</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ExpressDirectoryBucketConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ExpressDirectoryBucketConfiguration.Builder, S3ExpressDirectoryBucketConfiguration> {
    private static final SdkField<String> BUCKET_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPolicy").getter(getter(S3ExpressDirectoryBucketConfiguration::bucketPolicy))
            .setter(setter(Builder::bucketPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketPolicy;

    private S3ExpressDirectoryBucketConfiguration(BuilderImpl builder) {
        this.bucketPolicy = builder.bucketPolicy;
    }

    /**
     * <p>
     * The proposed bucket policy for the Amazon S3 directory bucket.
     * </p>
     * 
     * @return The proposed bucket policy for the Amazon S3 directory bucket.
     */
    public final String bucketPolicy() {
        return bucketPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExpressDirectoryBucketConfiguration)) {
            return false;
        }
        S3ExpressDirectoryBucketConfiguration other = (S3ExpressDirectoryBucketConfiguration) obj;
        return Objects.equals(bucketPolicy(), other.bucketPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ExpressDirectoryBucketConfiguration").add("BucketPolicy", bucketPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketPolicy":
            return Optional.ofNullable(clazz.cast(bucketPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ExpressDirectoryBucketConfiguration, T> g) {
        return obj -> g.apply((S3ExpressDirectoryBucketConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ExpressDirectoryBucketConfiguration> {
        /**
         * <p>
         * The proposed bucket policy for the Amazon S3 directory bucket.
         * </p>
         * 
         * @param bucketPolicy
         *        The proposed bucket policy for the Amazon S3 directory bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPolicy(String bucketPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String bucketPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExpressDirectoryBucketConfiguration model) {
            bucketPolicy(model.bucketPolicy);
        }

        public final String getBucketPolicy() {
            return bucketPolicy;
        }

        public final void setBucketPolicy(String bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
        }

        @Override
        public final Builder bucketPolicy(String bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        @Override
        public S3ExpressDirectoryBucketConfiguration build() {
            return new S3ExpressDirectoryBucketConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
